#include <stdio.h>         
#include "kant.h" 
#include "anf.h" 
#include "real.e"


t_logical
anf_ceiling_fincke_init  WITH_2_ARGS( 
	order,		ord,
	anf_ceiling *,	ceil
)
/*******************************************************************************
 
Description:
 
	The function create a ceiling and returns the first vector 
	(= (0,...,0) )    for the ellipsoid method of U. Fincke.

 
Calling sequence:
 
	log= anf_ceiling_fincke_init(ord, ceil);
 
      	order  	        ord      = t_handle of an order 
      	anf_ceiling     ceil     = t_handle of an ceiling
	t_logical		log	 = 1

 
History:
 
	92-06-11 AJ    written
 
*******************************************************************************/
{  
	block_declarations;
                              
	integer_small	j;

	*ceil= anf_ceiling_alloc(ord);

        for (j= 1; j<= order_abs_degree(ord); j++)
	  anf_ceiling_lambda(*ceil,j)= conv_int_to_real(order_reals(ord),1); 

	return TRUE;
} 

