// This may look like C code, but it is really -*- C++ -*-

#include "representation.h"
#include "cell.h"

extern Cell* cell[];
#ifdef _NEW_STREAMS
float Representation::time = 0;
#endif

// Constructor: Representation initializer function
Representation::Representation( Int high , Int wid ) 
{
  size = high * wid;
  height = high;
  width = wid;
  representation = new Int[size];
  // Indexed from 0,height-1 and 0,width-1 
  tag = new bool[size];
//  swapAttempt = swapFailure = 0;

  Int *ptr = representation;
  Int *EndPtr= representation + size;
  while ( ptr != EndPtr ) *ptr++ = Environment;
}

#if 0
// change of representation
void
Representation::resetSize( Int high, Int wid) 
{
  delete representation;
  delete tag;
  size = high * wid;
  height = high;
  width = wid;
  representation = new Int[size];
  // Indexed from 0,height-1 and 0,width-1 
  tag = new bool[size];

  Int *ptr = representation;
  Int *EndPtr= representation + size;
  while ( ptr != EndPtr ) *ptr++ = Environment;
}
#endif

Point Representation::findLocation(Int c) 
{ 
  if (getCell( location[c]) != c && !cell[c]->dummy) 
    setLocationToCentreofCell( c);  
  return(location [c]);
}
  
void
Representation::setLocationToCentreofCell( Int c)
{
  // too be debugged, not tested yet
  int sumY = 0, sumX = 0, area = 0;
  for (int y = 0; y < height; y++)
    for(int x = 0; x < width; x++)
      if ( *(representation + y * width + x) == c) {
	area++;
	sumX += x;
	sumY += y;
      }
  if (area == 0) {
    cerr << c << " cell not found " << location[c] << ":cell presumed killed\n";
//    cellNumberImage( cerr);
    cell[c]->die(); // TODO: It should be an exception and come put
    // of the nested procedure calls
    return;
  }
  location[ c] = Point( sumX/area, sumY/area); // Centre of cell
  if ( getCell( location[ c]) != c) {
    // Implementing a simple bfs on neighbors, tagging all visited points
    Point p = location[c];
    PointList search;
    search.addNeighbors(p);
    
    initializeTags();
    *(tag + p.arrayindex(width)) = TRUE; // This point visited
    while (!search.emptyList())
      {
	p = search.delget();
//	cerr << "point " << p << " cell " << getCell(p) <<'\n';
	if (getCell(p) == c) {
	  location[c] = p;
	  return;
	}
	*(tag + p.arrayindex(width)) = TRUE; // This point visited
	PointList temp; temp.addNeighbors(p);
	// For each of the points in the temp list if they ahve not been
	// tagged add them to the search list
	while (!temp.emptyList())
	  {
	    p = temp.delget();
	    if ( *(tag + p.arrayindex(width)) == FALSE) // not visited yet
	      search.insert(p);
	  }
      }
  }
}

void
Representation::initializeTags()
{ // set tags to 0
  bool *ptr = tag;
  bool *EndPtr= tag + size;
  while ( ptr != EndPtr ) *ptr++ = FALSE; // This point NOT visited.
}

#ifdef GEOMETRY
void
Representation::makeHexagonCell(int cx, int cy, int r, Int Value)
     // makes the hexagon belong to the specified cell 
{
// In a hexagon of radius n there are 3n(n+1)+1 points, with a 
// perimeter of 6n 
  //improved and much faster algorithm
  int i,j;

  if ((r+cx >= width-1) || (r+cy >= height-1) || (cx-r <=0) || (cy-r <= 0))
    error("Insuffucient Simulation Size: Cells over growing boundary");
  for ( j = r; j>= 0; j--) 
    for ( i= -r;i<= r-j; i++)
      putCell( Point(i+cx,j+cy), Value);
  for ( j = -1; j>= -r; j--) 
    for ( i= -r-j;i<= r; i++)
      putCell( Point(i+cx,j+cy), Value);
  location[ Value] = Point( cx, cy);
#ifdef TWO_POINT_CELL
  if (r==0){ 
    putCell( Point(1+cx,cy), Value);
//    cout << Point(cx,cy) << Point (cx+1,cy)<< Value << '\n';
  }
#endif
}
#endif GEOMETRY

Point
Representation::randomDirection() const
{
  const Precision = 100000;
  const Radius = 10000; // Pick point on a circle with Radius
  const TwoPi = 2*314159; // Number of digits in twoPi and Precision should
  // be same
  int angle = randBetween( 0, TwoPi);
  int x = (int) (Radius * cos( (double) angle/Precision));
  int y = (int) (Radius * sin( (double) angle/Precision));
  return ( Point( x, y));
}

void
Representation::dumpImage(ostream& s) const
{
  for (int y = height - 1; y >= 0; y--)
    {
      s << "@ " << y << ":";
      for(int x = 0; x < width; x++)
	s << ' ' << *(representation + y * width + x);
      s << ":" << y << "\n";
    }
  s << "  :";
}

void
Representation::tissueImage(ostream& s) const
{
  s << "Time = " << time << '\n';
  for (int y = height - 1; y >= 0; y--)
    {
      s << "@ " << y << ":";
      for(int x = 0; x < width; x++)
	s << cell[ *(representation + y * width + x)]->getTissueType() << ' ';
      s << ":" << y << "\n";
    }
}


void
Representation::cellNumberImage(ostream& s) const
{
  s << "Time = " << time << '\n';
  for (int y = height - 1; y >= 0; y--)
    {
      s << "@ " << y << ":";
      for(int x = 0; x < width; x++)
	s << cell[ *(representation + y * width + x)]->cellNumber << ' ';
      s << ":" << y << "\n";
    }
}

void
Representation::stateImage(ostream& s) const
{
  s << "Time = " << time << '\n';
  for (int y = height - 1; y >= 0; y--)
    {
      s << "@ " << y << ":";
      for(int x = 0; x < width; x++)
//	if ( *(representation + y * width + x) == 0) s << "-1 ";
//	else 
	s << cell[ *(representation + y * width + x)]->getState() << ' ';
      s << ":" << y << "\n";
    }
}

void
Representation::printNumber(int x, int width, ostream &s) const
// TODO only written for width = 2
{
  if (width == 2) {
    if (x >= 10 && x <100) s << x;
    else if (x <100) s << " " << x;
    else printNumber( x%100, width, s);
  }
  else if (width == 4) {
    s << x << ' ';
  }
}

void
Representation::outlineImage(ostream& s) const
{
  s << "  :";
  for(int x = 0; x < width; x++) printNumber(x, 2, s);
  s << '\n';
  for (int y = height - 1; y >= 0; y--)
    {
      printNumber( y, 2, s);
      s << ":";
      for(x = 0; x < width; x++)
	if (*(representation + y * width + x)  != 0) s << "XX";
	else s << "  ";
      s << ":" << y << "\n";
    }
  s << "  :";
  for(x = 0; x < width; x++) printNumber(x, 2, s);
  s << '\n';
}

void
Representation::move( Int c, int stepsToMove, FPoint direction)
     // move the cell c stepsToMove steps in the direction. direction is taken
     // be the one closest to the 6 possible
// Buggy has not been tested
{
  cerr << " In move " << c; direction.display(cerr);
//  direction = direction.closestPoint();
//  cerr << " In move " << c; direction.display(cerr);
  Point Rdirection = randomDirection();

  if (direction == Point(0,0)) direction = randomDirection();
  else direction = stepsToMove * direction;

  // Now generate stepsToMove in direction
//  cout << c << " in move " << stepsToMove ; direction.print();

  Point startPoint(0,0);
  Point newPoint = startPoint;
  for (int i = 0; i < stepsToMove; i++) {
    // Find a small step in the direction
    PointList search; search.addNeighbors( startPoint);
    float distance = MAX_FLOAT;
    Point p;
    do {
      p = search.delget();
//      cout << p.distanceSquared( direction) << " " << distance << '\n';
      if (direction.distanceSquared( p) < distance) {
	distance = direction.distanceSquared( p);
	newPoint = p;
      }
    } while  (!search.emptyList());
    Point mDirection = newPoint - startPoint;
    cerr << "taking a step in move in direction "; mDirection.print(cerr);
    startPoint = newPoint;

    Point neighborPoint = findBoundary( c, Rdirection);
    // neighborPoint is a point on the boundary not belonging to cell c1
    
    Point cellPoint;
    
    search.empty();
    search.addNeighbors( neighborPoint);
    do {
      p = search.delget();
    } while  (!search.emptyList() && getCell(p) != c);
    cellPoint = p;
    
    PointList moveList;
    Point startCellPoint = cellPoint, startNeighborPoint = neighborPoint;
    do {
      // Step through cellPoint and neighborPoint 
      Point next = p = cellPoint.nextPointInRotation( neighborPoint);
      if ( getCell( p) == c) {
	if ( getCell( p + mDirection) !=c)
	  moveList.insert( p);
	cellPoint = next;
      }
      else neighborPoint = next;
    } while ( (startCellPoint != cellPoint) ||
	     (startNeighborPoint != neighborPoint));
    while ( !moveList.emptyList()) {
      p = moveList.delget();
      if ( canStealPoint( p + mDirection) ) {
	putCell( p + mDirection, c);
	// move line forward
	while ( getCell( p -= mDirection) == c);
	Point cellP = p + mDirection; // cellP is the last cell point in this
	// line 
	// At cellP put any cell which is not c and has a neighbor to cellP
	search.empty();
	search.addNeighbors( cellP);
	do {
	  p = search.delget();
	} while  (!search.emptyList() && getCell(p) == c);
	if (getCell( p) != c) {
	  putCell( cellP, getCell( p));
	  decrementCellArea( getCell(p), Point(1000 * Point(-mDirection)));
	}
      }
    }
  }
}

void 
Representation::tagPointAndNeighbors( Point p)
{
  *(tag + p.arrayindex(width)) = TRUE;
  PointList nei; nei.addNeighbors( p);
  while ( !nei.emptyList()) *(tag + (nei.delget()).arrayindex(width)) = TRUE;
}

Point
Representation::findBoundary( Int c, FPoint towards) 
// Find boundary in specified direction: returns a neighbors point on the
// boundary, towards is an absolute direction it is not relative to the
// location of the cell, This was inconsistent until 5/29/92 may have lead to
// errors in findextremepoints and swapcelldirection.
{
  findLocation( c);
  if (towards == FPoint(location[c])) {
//    error("Random direction used in find boundary, may lead to future anomalies");
    towards = FPoint(randomDirection());
  }
  enum { LARGE_INT = 100};
  while (towards.distanceSquared( location[c]) < LARGE_INT*LARGE_INT ) {
    towards =  LARGE_INT * (towards - location[c]) + location[c];
  }  

  Point p = location[ c];
  Point next( p);
  double min = towards.distanceSquared( p);
  while ( getCell( p) == c) {
    PointList  search; search.addNeighbors( p);
    while (! search.emptyList()) {
      Point newP = search.delget();
//TODO not optimal
      FPoint newPF = p.directionFloat( newP);
      if ( min >= newPF.distanceSquared( towards)) {
	min = newPF.distanceSquared( towards);
	next = newP;
      }
    }
    p = next;
  }
  return p;
}

void
Representation::saveState( ostream& s)
{
  s << time << '\n';
  for (int i =0; i < Cell::numberDefined; i++) location[i].saveState( s);
  for ( i = 0; i < size; i++) s << representation[i] << ' ';
  s << '\n';
}

void
Representation::recoverState( istream& s)
{
  s >> time;

  for (int i =0; i < Cell::numberDefined; i++) location[i].recoverState( s);
  for ( i = 0; i < size; i++) s >> representation[i];
}

#ifdef UNIT_CELLS
// #ifndef SPACE_SAVER
// cellList*
// Representation::neighborList(Int c, int& perimeter)
//      // Returns a list of neighboring cells of the cell c 
//      // There are two contact lengths that can be counted, we count the
//      // exterior one
// {
//   Point cellPoint = findLocation( c); // location of cell c
//   PointList neighbors; neighbors.addNeighbors( cellPoint);
//   cellList* cellNeighbors = new cellList();
//   perimeter = 0;
//   while (!neighbors.emptyList()) {
//     Point neighborPoint = neighbors.delget();
//     cellNeighbors->insert( cell[ getCell( neighborPoint)], 
// 			  new PointList( neighborPoint), 1, 
// 			  cellPoint.relDirectionFloat( neighborPoint));
//     perimeter += 1;
//   }
//   return cellNeighbors;
// }
// 
// #endif SPACE_SAVER
// #ifdef SPACE_SAVER

cellList*
Representation::neighborList(Int c, int& perimeter)
     // Returns a list of neighboring cells of the cell c 
     // There are two contact lengths that can be counted, we count the
     // exterior one
{
  Point cellPoint = findLocation( c); // location of cell c
  PointList neighbors; neighbors.addNeighbors( cellPoint);
  cellList* cellNeighbors = new cellList();
  perimeter = 0;
  while (!neighbors.emptyList()) {
    Point neighborPoint = neighbors.delget();
    cellNeighbors->insert( cell[ getCell( neighborPoint)], 
			  cellPoint.relDirectionFloat( neighborPoint));
    perimeter += 1;
  }
  cellNeighbors->resetList();
  return cellNeighbors;
}
//#endif SPACE_SAVER

void 
Representation::swapCells( Int c1, Int c2, FPoint direction)
     // swap the locations of the adjoining cells c1 and c2
{
  if (direction == Point(0,0)){
    return; // very weak direction
  }
  if (! cell[ c2]->dummy) {// do not swap with dummy cells
    putCell( location[c1], c2);
    putCell( location[c2], c1);
    Point loc = location[ c1];
    location[ c1] = location[ c2];
    location[ c2] = loc;
    cell[ c1]->reformNeighborList();
    cell[ c2]->reformNeighborList();
  }
}

#endif UNIT_CELLS
