/* Lexical analysis  file for CPL */
%a 5000 /* Number of transitions, default is 3000 */
%p 5000
%o 6000
%{
extern FILE* cCode;
extern YYSTYPE yylval;
extern int addtosymboltable(); /* return the index to the symbol
				      table where it is stored */
int line_number=1;
void saveStr();
%}
%%
[ \t]+	;
"//"[^\n]*  {
                           /* ignore everything on this line: COMMENT*/  
			 }
[\n]	{line_number++;
#if 0
	 fprintf(cCode,"\n#line %d \"%s\"\n",line_number,inputFile);
#endif
       }

time_interval  return(INTERVAL);
steps return( STEPS);
simulation_size return(SIZE);
biochemical return( BIOCHEMICAL);
global return (GLOBAL);
local return (LOCAL);
shared return (GLOBAL);
individual return (LOCAL);
integer return(INTEGER);
int return(INT_EXP);
float return(FLOAT);
vector return( VECTOR);
direction return(VECTOR);
point return(POINT);
write return(WRITE);
echo  return(WECHO);
image   return (IMAGE);
save return( SAVE);
dummy  return(DUMMY);
trace return (TRACE);
if	return( IF);
then	return( THEN);
else	return( ELSE);

tissue	return( TISSUE);
state	return( STATE);
like    return( LIKE);

die     return(DIE);
attach  return (ATTACH);
grow    return( GROW);
swap	return( SWAP);
move 	return( SWAP);
goto	return( GOTO);
differentiate_to	return( DIFFERENTIATE_TO);
divide	return( DIVIDE);
configure {return( CONFIGURE);}
roundup {return( CONFIGURE);}
unit_area {return( UNIT_AREA);}
start_up_area return(START_UP_AREA);
union	return( UNION);
rectangle	return( RECTANGLE);
circle	return( CIRCLE);
hexagon	return( HEXAGON);
triangle return( TRIANGLE);
cell	return( CELL);
type 	return(TYPE);

"==" 	return(EQ);
"!="    return(NE);
"<="	return(LE);
">="	return(GE);
"&&"    return(AND);
AND  	return(AND);
"||"	return(OR);
OR	return(OR);
"!"	return(NOT);
NOT	return(NOT);
and  	return(AND);
or	return(OR);
not	return(NOT);
"%"     return(MOD);
mod     return(MOD);

"for each neighbor do" return(FOR_EACH_NEIGHBOR_DO); 
"for_each_neighbor_do" return(FOR_EACH_NEIGHBOR_DO); 
"with neighbor in direction" {return(WITH_NEIGHBOR_DO);}
"with_neighbor_in_direction" {return(WITH_NEIGHBOR_DO);}
horizontal return(HORIZONTAL);
vertical   return(VERTICAL);
perpendicular  return(PERPENDICULAR);
shortest   return(SHORTEST);
random_direction 	   return(RANDOM_DIR);
random 	   return(RANDOM_INT);
any 	   return(ANY);
time	   return(TIME);
exit       return(EXIT);

area    return(AREA);
perimeter   return(PERIMETER);
cell_number    return(CELLNUMBER);
cellNumber    return(CELLNUMBER);
location return(LOCATION);
sqrt return(SQRT);
sin60 return(SIN60);
deriv  {return (DERIV);}
tissue_type  {return(TISSUE_TYPE);}
"neighbor."state  {return(NEIGHBOR_STATE);}
"neighbor."area  {return(NEIGHBOR_AREA);}
"neighbor."perimeter  {return(NEIGHBOR_PERIMETER);}
"neighbor."contact_length  {return(CONTACT_LENGTH);}
"neighbor."direction  {return(DIRECTION);}
"neighbor."cell_number  {return(NEIGHBOR_CELLNUMBER);}
"neighbor."cellNumber  {return(NEIGHBOR_CELLNUMBER);}
"neighbor."tissue_type  {return(NEIGHBOR_TISS_TYP);}
"neighbor."[a-zA-Z]+[a-zA-Z0-9]* {saveStr( yytext+9);return(NEIGHBOR_VAR);}
\"[^"]*\" {saveStr( yytext);return(STRING);}
[a-zA-Z]+[a-zA-Z0-9_]* {saveStr(yytext);return(ID);}
[0-9]	{yylval.ival=yytext[yyleng-1]-'0';return(DIGIT);}
"#"[^\n]*\n {
  sscanf(yytext,"# %d ",&line_number);
  fprintf(cCode,"\n#line %d \"%s\"\n",line_number,inputFile);
}
. 	return(yytext[yyleng-1]);
%%
/*
"//"[a-zA-Z0-9_\.\(\)\-\*\+\|\/\{\}\<\>=!;, \t]*  {
                           /* ignore everything on this line: COMMENT
			 }
*/
