#ifndef CELL_H
#define CELL_H
#ifdef __GNUG__
#pragma interface
#endif
#define DEBUG FALSE
#define DEBUG2 FALSE
extern void saveSimulation(float);

#include "hash_define.h"
#include "cellList.h"
#include "representation.h"
#include "tissue.h"

pmf stateCode[MAX_NUMBER_STATES];
    // Pointer to the start state function to execute for all the states
    // enables recovery after a save
class Cell{ 
friend class Representation;
private:
  static float time;

  Int tissueType; // The enumeration number of the Tissue class it belongs to
  bool exists; // Does the cell exist at the present time?
  int stateCounter; // Pointer to the first instruction of the state the cell
		     // is currently in, changes only on executing the
		     // instruction goto stateName
  Cell *parent; // Pointer to its parent cell

  Point lastDividingLine; // Keeps track of the cells last division
  class neighborInfo* currentNeighbor; //Information about the current neighbor
				       //whose variables are being used
  class cellList* neighbor; // List of all the neighbors of the cell, in
			    // neighborInfo format computed during FOR_EACH
  static Representation *matrix;
  bool dummy; // indicates if the cell is a dummy being used for environmental
	      // purposes, such a cell still has to be connected, but its area
	      // need not be be maintained consistently. environment is marked
	      // as dummy too even though it does not have to be conencted
  bool trace; // Should we trace the operations of this cell
//  int areaDeviation; // The deviation of the representation's area from the
		     // area desired. Thus if the cell's area should be 100
		     // but the represenation contains 99, then areaDeviation
		     // is +1.
public:
  // database for each cell
  Int area,perimeter;
  Int cellNumber; // The number used to represent this cell in the
		  // representation essentially cell[cellNumber] points to
		  // this cell 
  // cellNumber made public for debugging
  Cell( Cell* parent, bool createdByDivision = TRUE);
  Cell( ifstream& s) { recoverState( s);}
  static float intervalf; // floating point interval
                         //The time interval at which the program for each
			 //cell is executed. It is also the time difference
			 //with which the biochemical difference equation is
			 //implicity multiplied. Thus if interval = 5 then
			 //every step of the simulation corresponds to 5 time
			 //units of the model, and this makes the simulation
			 //run 5 times faster. However interval = 0.5 slows
			 //down the simulation to half. Only the biochem deriv
			 //is implicit the rest have to use timeInterval
			 //explicitly. 
  static int height; // height and width of representation
  static int width; 
  static int numberDefined; // Number of cells that have been defined so
			      // far, when just the environment is defined it
			      // is set to 1.
  static void setTime( float thisTime) {time = thisTime;
				 Representation::setTime( time);}
  static bool debug;
  void saveState( ofstream& s);
  void recoverState( ifstream& s);
  void saveVar( ofstream& s);
  void recoverVar( ifstream& s);
  ostream& operator<<( ostream& s); 
  void printInfo( ostream& s = cout); 
    // prints all the information about the cell
  void dumpImage(ostream& s = cout) const { matrix->dumpImage(s);}
  void outlineImage(ostream& s = cout) const { matrix->outlineImage(s);}
  void tissueImage(ostream& s = cout) const 
    { matrix->tissueImage(s);} // prints the tissue numbers not the cell#'s
  void executeState();
  pmf code; // points to the C++ code to be executed by this cell in its
		  // current state
  static void setCodePointers();
  void endTimeStep();
  void die();
  void reformNeighborList(); //informs the cells neighbors that they have to
			     //redo their neighbor lists
  void _cellInitialize();
#include "cplCode.h"

private: // Functions only called by class members
  bool neighborListCurrent;
  void divide( divideOptions dO);
  void divideCopyVar( Cell*);
  int getTissueType() const {return tissueType;}
  int getState() const {return stateCounter;}
  void executeState(int pc); // Make the cell execute the list of instructions
			     // in its current state
  int randBet( int low, int high) const 
    // Returns a random number r, low<=r<=high
    {   
	return ( random()%(high-low+1)+low );
    }
};

#endif CELL_H
