#include <stdio.h>
#include <sys/types.h>
#include <utmp.h>
#include <sys/stat.h>
#include "ttyactivity.h"
/*
 *	read /etc/utmp.  for each login, stat tty
 *	return time of most recent activity.
 */

#ifndef	UTMP_FILE
#define	UTMP_FILE	"/etc/utmp"
#endif

time_t
ttyactivity()
{
	struct	utmp	ttytmp;
	FILE	*utmpfp;
	time_t	most_recent = 0;
	char	ttyname[30];
	struct	stat	ttystat;

	if ((utmpfp = fopen(UTMP_FILE, "r")) == NULL) {
		fprintf(stderr,
		    "Cannot open %s\n", UTMP_FILE);
		return 0;
	}
	while (	fread(&ttytmp, sizeof ttytmp, 1, utmpfp)) {
		if (ttytmp.ut_name[0]) {
			strcpy(ttyname, "/dev/");
#ifdef hp700
			strcat(ttyname,ttytmp.ut_line);
#else
			strncat(ttyname, ttytmp.ut_line,
			    sizeof ttytmp.ut_name);
#endif
			if (stat(ttyname, &ttystat)) {
				fprintf(stderr,
				    "Cannot stat %s\n", ttyname);
				continue;
			} else {
#ifdef hp700
			    if (most_recent < ttystat.st_mtime) {
				most_recent = ttystat.st_mtime;
			    }
#endif
			    if (most_recent < ttystat.st_atime) {
				most_recent = ttystat.st_atime;
			    }
			}
		}
	}
	fclose(utmpfp);
#ifdef hp700
	if (stat("/dev/hilkbd", &ttystat)) {
		fprintf(stderr,"Cannot stat /dev/hilkbd\n");
	} else {
	    if (most_recent < ttystat.st_mtime) {
		most_recent = ttystat.st_mtime;
	    }
	    if (most_recent < ttystat.st_atime) {
		most_recent = ttystat.st_atime;
	    }
	}
	if (stat("/dev/keyboard", &ttystat)) {
		fprintf(stderr,"Cannot stat /dev/keyboard\n");
	} else {
	    if (most_recent < ttystat.st_mtime) {
		most_recent = ttystat.st_mtime;
	    }
	    if (most_recent < ttystat.st_atime) {
		most_recent = ttystat.st_atime;
	    }
	}
#else
	if (stat("/dev/kbd", &ttystat)) {
		fprintf(stderr,"Cannot stat /dev/kbd\n");
	} else 
	    if (most_recent < ttystat.st_atime) {
		most_recent = ttystat.st_atime;
	    }
#endif
#ifndef hp700
	if (stat("/dev/mouse", &ttystat)) {
		fprintf(stderr,"Cannot stat /dev/mouse\n");
	} else
	    if (most_recent < ttystat.st_atime) {
		most_recent = ttystat.st_atime;
	    }
#endif
	return most_recent;
}
