/*
 *	check that the pid in run.hostname is actually running, and
 *	that we are the same uid as the file run.hostname.
 *
 *	returns:  0 if the process is running, 1 if it isn't, and -1
 *	if we are the wrong uid.
 */

#include <errno.h>
#include "checkpid.h"
#include "pid-job.h"
extern	errno;

int
checkpid()
{
	short	uid;
	int	pid;
	int	killret;

	uid = getmpqspid();
	
/*
 *	process is not running because file does not exist.
 */
	if (uid == -1) {
		return 1;
	}
	if (uid != getuid()) {
		return -1;
	}

	pid = getmpqspid();

	killret = kill(pid, 0);

	if (killret == 0) {
		return 0;
	}
	if (killret == -1) {
		if (errno == EPERM) {
			return -1;
		} else {
			return 1;
		}
	}
}
