#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "fileactivity.h"
/*
 *	read /etc/utmp.  for each login, stat tty
 *	return time of most recent activity.
 */

time_t
fileactivity(char *files[])
{
	time_t	most_recent = 0;

	for (; *files; files++) {
		struct	stat	filestat;
		if (stat(*files, &filestat)) {
			continue;
		}

		if (most_recent < filestat.st_atime) {
			most_recent = filestat.st_atime;
		}
	}
	return most_recent;
}
