
/*

Bug in g++-1.39.1

There seems to be a bug in the argument passing for delete 
operators. In the following example there is a class A with 
a new operator allocating memory using "malloc". And a delete 
operator deallocating this memory using "free". But the argument 
of the delete operator is always 0.

This error seems to occur only if A or any class member of A
has a destructor.

If I compile the program with g++-1.37.1 ro g++-1.40.3 it runs correctly, 
i.e., delete gets as argument the same pointer returned by malloc
in operator new.


*/


#include <stream.h>


struct A {

 int x;   
   
    A() { }
   ~A() { }
   
   
void*  operator new(size_t s)
{ void* p = malloc(s);
  printf("A::new      p = %d\n\n",p);
  return p;
}
   
   
void  operator delete(void* p)
{ 
  printf("A::delete p = %d\n",p);
}
  

};



main()
{ 
  A* ptr = new A;

  delete ptr;

 }
