// This may look like C code, but it is really -*- C++ -*-

// **********************************************************
// File rviewer.h
// ----------------------------------------------------------
// Created: J. Faschingbauer
// **********************************************************
#ifndef have_rviewer_h
#define have_rviewer_h

#include "hgviewer.h"
#include "rvwprot.h"

#include <hyperg/Dispatch/rpcwriter.h>
#include <hyperg/Dispatch/rpcreader.h>
#include <hyperg/Dispatch/rpchdr.h>



class LocalWriter ;
class LocalReader ;

// **********************************************************
// class RemoteViewer
// **********************************************************
class RemoteViewer : public HgViewer {
public:
   RemoteViewer (ViewerBoss*, const char* host, int port) ;
   virtual ~RemoteViewer() ;

   virtual void load (const char* doc, const char* anchors) ;
   virtual void browse (const char* dest) ;
   virtual void terminate() ;

   static const boolean binary ;

private:
   friend class LocalReader ;

   LocalWriter* _writer ;
   LocalReader* _reader ;

   boolean _ready ;
   boolean _running ;  // am I running a dispatch loop of my own ?
   boolean _propagate_errors ;
} ;











// **********************************************************
// class LocalWriter
// **********************************************************
class LocalWriter : public RpcWriter, virtual public ToRViewerProtocol {
public:
   LocalWriter (const char* host, int port, boolean fatal, boolean binary) ;

   void sendReady() ;
   void sendLoad (const char* doc, const char* anchors) ;
   void sendBrowse (const char* dest) ;
   void sendTerminate() ;
} ;



// **********************************************************
// class LocalReader
// **********************************************************
class LocalReader : public RpcReader, virtual public FromRViewerProtocol {
public:
   LocalReader (rpcstream* stream, RemoteViewer* viewer) ;

protected:
   virtual int  inputReady (int fd) ;
   virtual void connectionClosed(int) ;
   virtual void timerExpired(long, long) ;
   
   static void receive_READY      (RpcReader*, RpcHdr&, rpcstream&) ;
   static void receive_FOLLOWLINK (RpcReader*, RpcHdr&, rpcstream&) ;
   static void receive_ERROR      (RpcReader*, RpcHdr&, rpcstream&) ;
   static void receive_TERMINATED (RpcReader*, RpcHdr&, rpcstream&) ;

private:
   RemoteViewer* _viewer ;
   boolean _propagate_errors ;
} ;





#endif
