/*
 * $Log:	translate.c,v $
 * Revision 4.0  91/07/17  14:32:42  kolb
 */
#include "common.h"
#include "translat.h"
 
TransMethods *iTranslateMethods;
void TranslationMatrix();
 
Translate *
TranslateCreate()
{
	Translate *res;
 
	res = (Translate *)Malloc(sizeof(Translate));
	res->x = res->y = res->z = 0.;
	return res;
}
 
TransMethods *
TranslateMethods()
{
	if (iTranslateMethods == (TransMethods *)NULL) {
		iTranslateMethods = (TransMethods *)Malloc(sizeof(TransMethods));
		iTranslateMethods->create = (TransCreateFunc *)TranslateCreate;
		iTranslateMethods->propagate = TranslatePropagate;
	}
	return iTranslateMethods;	
}
 
void
TranslatePropagate(translate, trans, itrans)
Translate *translate;
RSMatrix *trans, *itrans;
{
	TranslationMatrix(translate->x, translate->y, translate->z, trans);
	/*
	 * Build the inverse...
	 */
	MatrixInit(itrans);
	itrans->translate.x = -translate->x;
	itrans->translate.y = -translate->y;
	itrans->translate.z = -translate->z;
}
 
void
TranslationMatrix(x, y, z, mat)
Float x, y, z;
RSMatrix *mat;
{
	MatrixInit(mat);
	mat->translate.x = x;
	mat->translate.y = y;
	mat->translate.z = z;
}
