/*
 * common.h
 * Revision 4.0  91/07/17  14:30:18  kolb
 * Initial version.
 *
 */
#ifndef COMMON_H
#define COMMON_H
 
#include <stdio.h>
#include <math.h>
#ifdef I_STDLIB
#include <stdlib.h>
#endif 

typedef double Float;

#include "config.h"
 
extern char* r_Malloc();
extern char* r_Calloc();

#ifdef AMIGA 
#include "common.h"
extern Float hypot();
#define NO_HYPOT
#endif
 
#if (VOIDFLAGS & 8) == 8
typedef void * voidstar;
#else
typedef char * voidstar;
#endif
 
#include "expr.h"
#include "vector.h"
#include "ray.h"
#include "color.h"
#include "transfor.h"
#include "error.h"
 
#ifndef TRUE
#define TRUE		1
#endif
 
#ifndef FALSE
#define FALSE		0
#endif
 
/*
 * Various useful constants and macros.
 */
#ifndef PI
#define	PI		3.14159265358979323846
#endif
#define TWOPI		(2. * PI)
#define INV_TWOPI	(1. / TWOPI)
#define deg2rad(x)	(Float)(x * PI/180.)
#define LNHALF		(-.69314718)
 
#ifndef NULL
#	define NULL 0
#endif
 
#define UNSET		-1
 
/*
 * Some systems, such as the RS6000, have fast fabs already defined.
 */
#ifndef fabs
extern Float RSabstmp;
#define fabs(x) 		((RSabstmp=x) < 0 ? -RSabstmp : RSabstmp)
#endif
 
#ifdef MULTIMAX
/*
 * On the multimax, allocate large pieces of memory as shared memory.
 */
extern char *share_malloc(), *share_calloc();
#else
/*
 * Otherwise, malloc is malloc, etc.
 */
#ifndef share_malloc
#define share_malloc(x)    Malloc(x)
#endif
#ifndef share_calloc
#define share_calloc(x,y)  Calloc(x,y)
#endif
#endif
 
/*
 * Close enough for us.
 */
#define equal(a, b)		(fabs((a) - (b)) < 0.000001)
/*
 * Maximum/Minimum functions
 */
#ifndef max
#define max(a, b)		((a) > (b) ? (a) : (b))
#define min(a, b)		((a) < (b) ? (a) : (b))
#endif
char *strsave();
/*extern voidstar Malloc();*/
/*extern voidstar Calloc();*/
extern double	drand48();	/* just in case */
#endif /* COMMON_H */
