/*
 * typedefs.h
 *
 * Copyright (C) 1989, Craig E. Kolb
 *
 * This software may be freely copied, modified, and redistributed,
 * provided that this copyright notice is preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely .  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * $Id: typedefs.h,v 3.0.1.1 90/02/12 13:22:35 craig Exp $
 *
 * $Log:	typedefs.h,v $
 * Revision 3.0.1.1  90/02/12  13:22:35  craig
 * patch4: Added prims field to Object structure.
 * patch4: Object->counter is a pointer when SHAREDMEM is defined.
 * 
 * Revision 3.0  89/10/27  02:06:07  craig
 * Baseline for first official release.
 * 
 */
#include "datatypes.h"
#include "primobj.h"

/*
 * Light definition.
 */
typedef struct {
	char type;		/* Light source type */
	Vector pos;		/* Position / direction */
	Color color;		/* Color (always normalized) */
	double radius;		/* Radius (for extended sources) */
	Primitive **cache;
	TransInfo *trans;
} Light;

/*
 * Object node definition
 */
typedef struct Object {
	char *name;		/* Object name, if any. */
	char type;		/* Type (grid, list, sphere, cone...) */
	char *data;		/* Pointer to list/grid/primitive */
	Trans *trans;		/* Transformation information */
	double bounds[2][3];	/* Bounding box */
	unsigned long prims;	/* # of primitives, including sub-objects */
#ifdef SHAREDMEM
	unsigned long *counter;
#else
	unsigned long counter;		/* # of last grid checked against */
#endif
	struct Texture *texture;	/* Texture mapping info. */
} Object;
