/*
 * input.c
 *
 * Copyright (C) 1989, Craig E. Kolb
 *
 * This software may be freely copied, modified, and redistributed,
 * provided that this copyright notice is preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely .  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * $Id: input.c,v 3.0.1.2 89/12/07 22:53:32 craig Exp $
 *
 * $Log:	input.c,v $
 * Revision 3.0.1.2  89/12/07  22:53:32  craig
 * patch2: Added comments, lint-related goofiness.
 * 
 * Revision 3.0.1.1  89/12/06  16:08:43  craig
 * patch2: Removed #include handling.  Added RSmessage(), RSwarning(),
 * patch2: and RSerror().
 * 
 * Revision 3.0  89/10/27  02:05:51  craig
 * Baseline for first official release.
 * 
 */
#include <stdio.h>

char *infilename;	/* Name of input file.  NULL signifies stdin. */

/*
 * Open input file and call yyparse().
 */
read_input_file()
{
	extern FILE *yyin;	/* lex/yacc file pointer */
	extern char yyfilename[];

	if (infilename == (char *)NULL) {
		yyin = stdin;
		strcpy(yyfilename, "stdin");
	} else {
		yyin = fopen(infilename, "r");
		if (yyin == (FILE *)NULL)
			RSerror("Cannot open %s.\n",infilename);
		strcpy(yyfilename, infilename);
	}
	yyparse();
}

/*
 * Print message to standard output with format:
 * program_name: message_type: message
 */
/*VARARGS2*/
RSmessage(type, str, pat1, pat2, pat3)
char *type, *str, *pat1, *pat2, *pat3;
{
	extern char *progname;

	fprintf(stderr,"%s: %s: ",progname, type);
	fprintf(stderr, str, pat1, pat2, pat3);
	fflush(stderr);
}

/*
 * Issue warning message if not in Quiet mode.
 */
/*VARARGS1*/
RSwarning(str, pat1, pat2, pat3)
char *str, *pat1, *pat2, *pat3;
{
	extern int Quiet;

	if (!Quiet)
		RSmessage("Warning", str, pat1, pat2, pat3);
}

/*
 * Issue error message and exit.
 */
/*VARARGS1*/
RSerror(str, pat1, pat2, pat3)
char *str, *pat1, *pat2, *pat3;
{
	RSmessage("Error", str, pat1, pat2, pat3);
	exit(1);
}
