/*
 *  xv.h  -  header file for xv, but you probably guessed as much
 */

/*
 * Copyright 1989, 1990 by the University of Pennsylvania
 *
 * Permission to use, copy, and distribute for non-commercial purposes,
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation.
 *
 * The software may be modified for your own purposes, but modified versions
 * may not be distributed.
 *
 * This software is provided "as is" without any express or implied warranty.
 */

#define REVDATE   "Rev: 11/29/90  (Patchlevel 3)"

#ifdef SVR4             /* SysV release 4 uses dirent */
#ifndef sgi             /* but Silicon Graphics doesn't */
#define DIRENT
#endif
#endif


/* include files */
#include <stdio.h>
#include <math.h>
#include <ctype.h>
/* #include <string.h>  now in globals.h */
extern int   errno;             /* this SHOULD be in errno.h */
extern char *sys_errlist[];     /* this SHOULD be in errno.h */

#ifndef __convexc__             /* Convex doesn't have <memory.h> */
#include <memory.h>             /* for 'memset()' prototype */
#endif

/* neither IBM AOS 4.3, Convex, nor BSD 4.3 on VAX have <malloc.h> */
#if !defined(ibm032) && !defined(__convexc__) && \
    !(defined(vax) && !defined(ultrix))
#if defined(hp300) || defined(hp800)
#include <sys/malloc.h>                /* it's in 'sys' on HPs*/
#else
#include <malloc.h>
#if defined(vax) 
   extern char *calloc();
#endif
#endif
#endif


#if defined(NEED_MEMROUTINES)
#define memcpy(d,s,l) bcopy(s,d,l)
#endif


#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <X11/keysym.h>


#if defined(NEEDSTIME) || defined(NEEDSDIR)
#include <sys/types.h>    /* only include <sys/types.h> once */
#endif

#ifdef NEEDSTIME
#ifndef sgi              /* silicon graphics doesn't have timeb.h */
#include <sys/timeb.h>
#endif
#include <signal.h>
#if defined(sco) && !defined(NOTIMER)
#include <sys/itimer.h>
#endif
#ifndef  sigmask
#define  sigmask(m)      (1 << ((m)-1))
#endif
#endif

#ifdef NEEDSDIR
#ifdef sco
#include <sys/ndir.h>
#define lstat stat
#else
#ifndef ATT
#include <sys/dir.h>
#endif  /* ATT */
#endif  /* sco */
#include <sys/param.h>
#include <sys/stat.h>
#ifdef DIRENT
#include <dirent.h>
#endif
#endif

#ifdef NEEDSVARARGS
#include <varargs.h>
#endif

/* signal macros */
#ifdef SVR4
#define HOLD_SIG         sighold(SIGALRM)  /* block ALRM sig from occurring */
#define RELEASE_SIG      sigrelse(SIGALRM) /* 
#define PAUSE_SIG        sigpause(SIGALRM) /* sleep until ALRM signal */
#else
#define HOLD_SIG         sigblock(sigmask(SIGALRM))
#define RELEASE_SIG      sigblock(0)
#define PAUSE_SIG        sigpause(0)
#endif


#ifdef i386
#define MAXPATHLEN    500
#define UNCOMPRESS    "/usr/local/bin/uncompress"   /* uncompress program */
#undef  HOLD_SIG
#define HOLD_SIG      /* don't know how to handle signals  MWS 10/18/90 */
#undef  RELEASE_SIG
#define RELEASE_SIG   /* */
#undef  PAUSE_SIG
#define PAUSE_SIG     /* */
#else
#define UNCOMPRESS "/usr/ucb/uncompress"   /* for uncompressing .Z files */
#endif

#define PROGNAME  "xv"             /* used in resource database */

#define DEFINFOGEOM "-10+10"       /* default position of info window */
#define DEFDIRGEOM  "-10-10"       /* default position of directory window */
#define DEFCTRLGEOM "+400+400"     /* default position of ctrl window */
#define DEFGAMGEOM  "+10-10"       /* default position of gamma window */

#define INFOWIDE 500               /* (fixed) size of info window */
#define INFOHIGH 250

#define CTRLWIDE 440               /* (fixed) size of control window */
#define CTRLHIGH 295

#define DIRWIDE  300               /* (fixed) size of directory window */
#define DIRHIGH  420

#define GAMWIDE  366               /* (fixed) size of Gamma window */
#define GAMHIGH  356

#define MAXNAMES 1024   /* max # of files (more than this?  Get REAL!)

/* strings in the INFOBOX (used in SetISTR and GetISTR) */
#define NISTR         9    /* number of ISTRs */
#define ISTR_INFO     0
#define ISTR_WARNING  1
#define ISTR_FILENAME 2
#define ISTR_FORMAT   3
#define ISTR_RES      4
#define ISTR_CROP     5
#define ISTR_EXPAND   6
#define ISTR_COLOR    7
#define ISTR_COLOR2   8

/* potential values of 'infomode', used in info box drawing routines */
#define INF_NONE 0    /* empty box */
#define INF_STR  1    /* just ISTR_INFO */
#define INF_PART 2    /* filename, format, size and infostr */
#define INF_FULL 3    /* INF_PART + clipping, expansion, colorinfo */


/* buttons in the ctrl window */
#define NBUTTS  20
#define BNEXT   0
#define BPREV   1
#define BCROP   2
#define BUNCROP 3
#define BNORM   4
#define BMAX    5
#define BUP2    6
#define BDN2    7
#define BUP10   8
#define BDN10   9
#define BQUIT   10
#define B4BY3   11
#define BSAVE   12
#define BROTL   13
#define BINFO   14
#define BGAMMA  15
#define BASPECT 16
#define BROTR   17
#define BMAXPECT 18
#define BACROP   19

/* buttons in the 'save' window */
#define S_NBUTTS 4
#define S_BOPEN  0
#define S_BSAVE  1
#define S_BCANC  2
#define S_BQUIT  3


/* buttons in the 'gamma' window */
#define G_NBUTTS  17
#define G_BAPPLY  0
#define G_BNOGAM  1
#define G_BRESET  2
#define G_BDEF    3
#define G_BGTYPE  4
#define G_BCLOSE  5
#define G_BUP_BR  6
#define G_BDN_BR  7
#define G_BUP_CN  8
#define G_BDN_CN  9
#define G_BHSVRGB 10
#define G_B1      11
#define G_B2      12
#define G_B3      13
#define G_B4      14
#define G_BSET    15
#define G_BUNDO   16


/* definitions of first char of dirnames[i] (filetype) */
#define C_FIFO  'f'    /* FIFO special file */
#define C_CHR   'c'    /* character special file */
#define C_DIR   'd'    /* directory */
#define C_BLK   'b'    /* block special file */
#define C_LNK   'l'    /* symbolic link */
#define C_SOCK  's'    /* socket */
#define C_REG   ' '    /* regular file */


/* random string-placing definitions */
#define SPACING 3      /* vertical space between strings */
#define ASCENT   (mfinfo->ascent)
#define DESCENT  (mfinfo->descent)
#define CHIGH    (ASCENT + DESCENT)
#define LINEHIGH (CHIGH + SPACING)


#define STDINSTR "<stdin>"


typedef unsigned char byte;

typedef struct { Window win;            /* window ID */
		 int len;               /* length of major axis */
		 int vert;              /* true if vertical, else horizontal */
		 int active;            /* true if scroll bar can do anything*/
		 int min,max;           /* min/max values 'pos' can take */
		 int val;               /* 'value' of scrollbar */
		 int page;              /* amt val change on pageup/pagedown */
		 int tpos;              /* thumb pos. (pixels from tmin) */
		 int tmin,tmax;         /* min/max thumb offsets (from 0,0) */
		 int tsize;             /* size of thumb (in pixels) */
		 unsigned long fg,bg;   /* colors */
		 void (*drawobj)();     /* redraws obj controlled by scrl*/
		 int uplit, dnlit;      /* true if up&down arrows are lit */
	       } SCRL;

typedef struct { Window win;            /* parent window */
		 int x,y,w,h;           /* size of button rectangle */
		 int lit;               /* if true, invert colors */
		 int active;            /* if false, stipple gray */
		 int toggle;            /* if true, clicking toggles state */
		 unsigned long fg,bg;   /* colors */
		 char *str;             /* string in button */
	       } BUTT;


typedef struct { Window win;            /* window */
		 int x,y,w,h;           /* size of window */
		 unsigned long fg,bg;   /* colors */
		 char **str;            /* ptr to list of strings */
		 int   nstr;            /* number of strings */
		 int   selected;        /* number of 'selected' string */
		 int   nlines;          /* number of lines shown at once */
		 SCRL  scrl;            /* scrollbar that controls list */
		 int   filetypes;       /* true if filetype icons to be drawn*/
		 int   dirsonly;        /* if true, only dirs selectable */
	       } LIST;


typedef struct rbutt { Window        win;      /* parent window */
		       int           x,y;      /* position in parent */
		       char         *str;      /* the message string */
		       int           selected; /* selected or not */
		       int           active;   /* selectable? */
		       struct rbutt *next;     /* pointer to next in group */
		       unsigned long fg,bg;    /* colors */
		     } RBUTT;

/* MACROS */
#define CENTERX(f,x,str) ((x)-XTextWidth(f,str,strlen(str))/2)
#define CENTERY(f,y) ((y)-((f->ascent+f->descent)/2)+f->ascent)

/* RANGE forces a to be in the range b..c (inclusive) */
#define RANGE(a,b,c) { if (a<b) a=b;  if (a>c) a=c; }

/* PTINRECT returns '1' if x,y is in rect (inclusive) */
#define PTINRECT(x,y,rx,ry,rw,rh) \
           ((x)>=(rx) && (y)>=(ry) && (x)<=(rx)+(rw) && (y)<=(ry)+(rh))

/* MONO returns total intensity of r,g,b components */
#define MONO(rd,gn,bl) (((rd)*11 + (gn)*16 + (bl)*5) >> 5)  /*.33R+ .5G+ .17B*/



/* X stuff */
WHERE Display       *theDisp;
WHERE int           theScreen;
WHERE unsigned int  ncells, dispWIDE, dispHIGH, dispDEEP;
WHERE Colormap      theCmap, LocalCmap;
WHERE Window        rootW, mainW;
WHERE GC            theGC;
WHERE unsigned long black, white, fg, bg, infofg, infobg;
WHERE Font          mfont, monofont;
WHERE XFontStruct   *mfinfo, *monofinfo;
WHERE Visual        *theVisual;
WHERE Cursor        arrow, cross;
WHERE Pixmap        iconPix;

/* global vars used by LOAD routines */
WHERE byte          *pic;                   /* ptr to loaded picture */
WHERE unsigned int   pWIDE,pHIGH;           /* size of 'pic' */
WHERE byte           r[256],g[256],b[256];  /* colormap */
WHERE char          *cmd;                   /* program name for printf's */
WHERE int            DEBUG;                 /* print debugging info */
WHERE int            mono;                  /* true if displaying grayscale */


/* more global variables, used by xv and xvmisc */
WHERE byte          *cpic;         /* cropped version of pic */
WHERE unsigned int  cWIDE, cHIGH,  /* size of cropped region */
                    cXOFF, cYOFF;  /* offset of region from 0,0 of pic */

WHERE byte          *epic;         /* expanded version of cpic */
                                   /* points to pic when at 1:1 expansion */
                                   /* this is converted to 'theImage' */
/*WHERE unsigned int  eWIDE, eHIGH;  /* size of epic */
WHERE unsigned int  normFact;      /* factor to shrink picture by for 'norm' */

WHERE byte           rorg[256],gorg[256],borg[256];  /* ORIGINAL colormap */
WHERE byte           gamcr[256];   /* gamma correction curve */
WHERE byte           fsgamcr[256]; /* gamma correction curve (for FS dither) */


WHERE XImage        *theImage;     /* X version of epic */


WHERE unsigned long freecols[256]; /* list of pixel values to free */
WHERE int           nfcols;        /* number of colors to free */
WHERE unsigned long cols[256];     /* maps pic pixel values to X pixel vals */
WHERE int           fc2pcol[256];  /* maps freecols into pic pixel values */
WHERE int           numcols;       /* # of desired colors in picture */
WHERE int           ncols;         /* max # of (different) colors to alloc */

WHERE char          str[128];      /* dummy string used for error messages */

WHERE int           expand,        /* expansion amount */
                    bwidth,        /* border width of created windows */
                    noglob,        /* force to only use colors it alloced */
                    revvideo,      /* reverse video */
                    perfect,       /* perfect color.  install own colormap */
                    fixedaspect,   /* fixed aspect ratio */
                    slow24,        /* use slow 24to8 algorithm */
                    ninstall,      /* true if using icccm-complaint WM
				      (a WM that will does install CMaps */
                    useroot,       /* true if we should draw in rootW */
                    noqcheck,      /* true if we should NOT do QuickCheck */
                    rwcolor,       /* true if we should use R/W color cells */
                    rwthistime,    /* true if we DID use R/W color cells */
                    brokeFreeCols, /* true if server has broken XFreeColors */
                    fish,          /* turn on annoying fish */
                    fishrunning;   /* true if fish are in operation */

WHERE float         defaspect,     /* default aspect ratio to use */
                    normaspect;    /* normal aspect ratio of this picture */

WHERE int           crx1, cry1,    /* dimensions of cropping rectangle */
                    crx2, cry2;



/* stuff used for 'info' box */
WHERE Window        infoW;
WHERE int           infoUp;       /* boolean:  whether infobox is visible */
WHERE int           infoMode;


/* stuff used for 'ctrl' box */
WHERE Window        ctrlW;
WHERE int           ctrlUp;       /* boolean:  whether ctrlbox is visible */
WHERE char         *namelist[MAXNAMES];  /* list of file names from argv */
WHERE char         *dispnames[MAXNAMES]; /* truncated names shown in listbox */
WHERE int           numnames, curname;
WHERE LIST          nList;
WHERE BUTT          but[NBUTTS];         /* command buttons in ctrl window */
WHERE Pixmap        grayTile, grayStip;  /* for drawing dim things */

/* stuff used for 'directory' box */
WHERE Window        dirW, ddirW, dnamW;
WHERE int           dirUp;       /* is dirW mapped or not */
WHERE LIST          dList;       /* list of filenames in current directory */
WHERE BUTT          dbut[S_NBUTTS];

/* stuff used for 'gamma' box */
#define NUMHANDS 4
WHERE Window        gamW,graphW;
WHERE int           gamUp;       /* is gamW mapped or not */
WHERE BUTT          gbut[G_NBUTTS];
WHERE XPoint        ghand[NUMHANDS];







/* function declarations for externally-callable functions */

#ifdef __STDC__ 
/****************************** XV.C ****************************/
void DrawWindow(int, int, int, int);
void WCrop(int, int);
void WUnCrop(void);
void WResize(int, int);
void WRotate(void);
void InvCropRect(void);
void MakeRootPic(void);

/*************************** XVMISC.C ***************************/
Window CreateWindow(char *, char *, unsigned int, unsigned int, 
		    unsigned long, unsigned long);
void Resize(int, int);
void Rotate(int);
void SortColormap(void);
void AllocColors(void);
void AllocRWColors(void);
void DoMonoAndRV(void);
void DoCrop(void);
void UnCrop(void);
void AutoCrop(void);
void FSDither(byte *, int, int, byte *);
void CreateXImage(void);
void CenterString(Window, char *, int, int);
void ULineString(Window, char *, int, int);
int  StringWidth(char *);
void FakeButtonPress(BUTT *);
void SetCropString(void);
void Warning(void);
void FatalError(char *);
void LoadFishCursors(void);
void SetCursors(int);
void WaitCursor(void);
void Quit(int);
void Timer(int);

/*************************** XV24TO8.C **************************/
int  Conv24to8(byte *, int, int, int);
void InitFSDTables(void);

/**************************** XVCTRL.C **************************/
void CreateCtrl(char *);
void CtrlBox(int);
void RedrawCtrl(int, int, int, int);
int  ClickCtrl(int, int);
void DrawCtrlStr(void);
void ScrollToCurrent(void);

void LSCreate(LIST *, Window, int, int, int, int, int, char **, int, 
	      unsigned long, unsigned long, void (*)(void), int, int);
void LSRedraw(LIST *);
int  LSClick (LIST *, XButtonEvent *);
void LSNewData(LIST *, char **, int);


/*************************** XVINFO.C ***************************/
void  CreateInfo(char *);
void  InfoBox(int);
void  RedrawInfo(int, int, int, int);
void  SetInfoMode(int);
void  SetISTR(int, ...);
char *GetISTR(int);

/**************************** XVDIR.C ***************************/
void CreateDirW(char *);
void DirBox(int);
void RedrawDirW(int,int,int,int);
int  ClickDirW(int, int);
void LoadCurrentDirectory(void);
void RedrawDDirW(void);
void RedrawDNamW(void);
void SelectDir(int);
void DirOpenActive(void);
void TrackDDirW(int,int);
int  DirKey(int);
int  DoSave(void);
void SetDirFName(char *);


/**************************** XVGAM.C **************************/
void CreateGam(char *);
void GamBox(int);
void RedrawGam(int, int, int, int);
void RedrawGraph(int, int, int, int);
void ClickGam(int, int);
void TrackGraph(int, int);
void GenerateGamma(void);
void GenerateFSGamma(void);
void GammifyColors(void);
void SetGPreset(int, int, int, int, int, int, int);

/*************************** XVSCRL.C ***************************/
void SCCreate  (SCRL *, Window, int, int, int, int, int, int, int, int, 
                      unsigned long, unsigned long, void (*)(void));
void SCSetRange(SCRL *, int, int, int, int);
void SCSetVal  (SCRL *, int);
void SCRedraw  (SCRL *);
void SCTrack   (SCRL *, int, int);


/**************************** XVBUTT.C ***************************/

void BTCreate(BUTT *, Window, int, int, int, int, char *, 
	      unsigned long, unsigned long);
void BTSetActive(BUTT *, int);
void BTRedraw(BUTT *);
int  BTTrack (BUTT *);


RBUTT *RBCreate(RBUTT *, Window, int, int, char*, 
		unsigned long, unsigned long);
void   RBRedraw(RBUTT *, int);
void   RBSelect(RBUTT *, int);
int    RBWhich(RBUTT *);
int    RBCount(RBUTT *);
void   RBSetActive(RBUTT *, int, int);
int    RBClick(RBUTT *, int, int);
void   RBTrack(RBUTT *, int);


/**************************** XVGIF.C ***************************/
int LoadGIF(char *, int);

/*************************** XVGIFWR.C **************************/
int WriteGIF(FILE *, byte *, int, int, byte *, byte *, byte *, int, int);

/**************************** XVPM.C ****************************/
int LoadPM(char *, int);
int WritePM(FILE *, byte *, int, int, byte *, byte *, byte *, int, int);

/**************************** XVPBM.C ***************************/
int LoadPBM(char *, int);
int WritePBM(FILE *, byte *, int, int, byte *, byte *, byte *, int, int, int);

/**************************** XVXBM.C ***************************/
int LoadXBM(char *, int);
int WriteXBM(FILE *, byte *, int, int, char *);





#else     /* using non-ANSI cc.  Function defs, but no params */




/****************************** XV.C ****************************/
void DrawWindow(), WCrop(), WUnCrop(), WResize(), WRotate(), InvCropRect();
void MakeRootPic();

/*************************** XVMISC.C ***************************/
Window CreateWindow();
void   Resize(), Rotate(), SortColormap(), AllocColors(), DoCrop(), UnCrop();
void   AutoCrop(), DoMonoAndRV();
void   AllocRWColors(), FSDither(), CenterString(), ULineString();
int    StringWidth();
void   FakeButtonPress(), SetCropString(), Warning(), FatalError(), Quit();
void   Timer(), CreateXImage(), LoadFishCursors(), SetCursors(), WaitCursor();

/*************************** XV24TO8.C **************************/
int  Conv24to8();
void InitFSDTables();

/**************************** XVCTRL.C **************************/
void CreateCtrl(), CtrlBox(), RedrawCtrl(), DrawCtrlStr(), ScrollToCurrent();
int  ClickCtrl();

void LSCreate(), LSRedraw(), LSNewData();
int  LSClick();

/*************************** XVINFO.C ***************************/
void  CreateInfo(), InfoBox(), RedrawInfo(), SetInfoMode(), SetISTR();
char *GetISTR();

/**************************** XVDIR.C ***************************/
void CreateDirW(), DirBox(), RedrawDirW(), LoadCurrentDirectory();
int  ClickDirW(), DoSave(), DirKey();
void RedrawDDirW(), RedrawDNamW(), SelectDir(), DirOpenActive(), TrackDDirW();
void SetDirFName();

/**************************** XVGAM.C **************************/
void CreateGam(), GamBox(), RedrawGam(), RedrawGraph(), ClickGam();
void TrackGraph(), GenerateGamma(), GenerateFSGamma(), GammifyColors();
void SetGPreset();

/*************************** XVSCRL.C ***************************/
void SCCreate(), SCSetRange(), SCSetVal(), SCRedraw(), SCTrack();

/**************************** XVBUTT.C ***************************/
void BTCreate(), BTSetActive(), BTRedraw();
int  BTTrack();

RBUTT *RBCreate();
void   RBRedraw(), RBSelect(), RBSetActive(), RBTrack();
int    RBWhich(), RBCount(), RBClick();

/**************************** XVGIF.C ***************************/
int LoadGIF();

/*************************** XVGIFWR.C **************************/
int WriteGIF();

/**************************** XVPM.C ****************************/
int LoadPM(), WritePM();

/**************************** XVPBM.C ***************************/
int LoadPBM(), WritePBM();

/**************************** XVXBM.C ***************************/
int LoadXBM(), WriteXBM();


#endif
