/* morph.c  --  morph main program */

/* contains: main() */

/* dependencies: GetArgs(), ReadRasterFile(), MorphSub(), WriteRasterFile() */
/* ExtractLuminance()

/* morph version 4.0  10 May 1993                  */    
/* image morphology program                        */
/*                                                 */
/* by Richard Alan Peters II                       */
/* Department of Electrical Engineering            */
/* Vanderbilt University School of Engineering     */
/* Nashville, TN 37235                             */
/* rap2@vuse.vanderbilt.edu                        */
/*                                                 */
/* This software is freely redistributable if      */
/* the author's name and affiliation are included. */

/* See changes.doc for an explanation of the changes in v4.0. */

#include "morph.h"
#include "morph_sub.h"
#include "rasterio.h"


/* input "file" is expected on stdin. output "file" is to stdout. */

main( argc, argv ) 
   unsigned int argc;  /* count of arguments parsed by operating system    */
   char *argv[];       /* pointers to arguments parsed by operating system */
   {

   struct rasterfile RasHd;  /* raster file header */
   unsigned char *cmap;      /* colormap */

   int MorphOp;   /* operation to perform */

   byte *Img;     /* image as list in row-major order */
   int X,Y;       /* image horizontal, vertical dimensions */
   int ImgType;   /* gray-level or binary */
   int NZpad ;    /* flag.  F => zeropadding of input */
   int NoScale;   /* flag.  T => do not scale output of IntMorph */
   int Dsp;       /* flag.  T => display some info */

   char *SEname;  /* structuring element (SE) path name */
   int sX,sY;     /* SE horizontal, vertical dimensions */
   int sZ;        /* largest gray level in SE */
   int autoSE;    /* T => create a disk-shaped SE locally */
   int SEType;    /* binary or gray-level SE */
   int SorF;      /* Set operation or Function operation */

   int LThresh;   /* lower binary threshold value */
   int UThresh;   /* upper binary threshold value */
   int Rank;      /* rank for rank filter */


   /* begin */

   if (argc < 5) /* display usage */
      {
      fprintf(stderr,
         "usage: morph <In >Out -m e|d|o|c|r|t|b|l|m|n|p|q [-i g|b] [-s g|b] [-o s|f] \n       [-t nnn [mmm]] [-r med|nnn] [-l kkk lll] [-z] [-n] [-v] \n       -k SEFile | 3x3 | 5x5 | plus | auto xxx yyy [zzz]\n");
      exit(0);
      }

   /* get arguments */
   GetArgs(argc,argv,&SEname,&autoSE,&sX,&sY,&sZ,&MorphOp,&SorF,&SEType,
           &ImgType,&Rank,&LThresh,&UThresh,&NZpad,&NoScale,&Dsp);

   /* read the input image into memory */
   if ( ReadRasterFile( stdin, &RasHd, &cmap, &Img, 0, 0, 0, 0, ALLOC ) ) 
      exit(0);

   /* extract the luminance */
   ExtractLuminance( &RasHd, cmap, Img, 0, 0, 0, 0 );

   /* get image dimensions */
   X = RasHd.ras_width;
   Y = RasHd.ras_height;

   /* do the morph op */
   MorphSub( MorphOp, Img, Img, X, Y, ImgType, NZpad, LThresh, UThresh,
              SEname, autoSE, sX, sY, sZ, SEType, SorF, Rank, NoScale, Dsp);

   /* write the result */
   if ( WriteRasterFile( stdout, &RasHd, cmap, Img, 0, 0, 0, 0 ) ) 
      exit(0);

   free( Img );
   if ( cmap ) free( cmap );
   }



