/*******************************************************************************
+
+  LEDA  3.0
+
+
+  _win_basic.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#include <LEDA/window.h>
#include "x_draw.h"


static void window_error_handler(int i, char* s)
{ string mesg("LEDA Error(%d): %s",i,s);
  if (i>0) // error
  { x_draw_acknowledge(~mesg);
    x_draw_end();
    abort();
   }
  else default_error_handler(i,s);
 }

window::window(float width, float height, float xpos, float ypos)
{ state = 1;
  x_draw_init_window(int(width),int(height),int(xpos),int(ypos),
                                                        LEDA::version_string);
  x_draw_init(0.0,100.0,0.0,0);
  set_error_handler(window_error_handler);
  set_flush(true); 
}

window::window(float width, float height)
{ state = 1;
  x_draw_init_window(int(width),int(height),x_draw_screen_width()-int(width),0,
                                                        LEDA::version_string);
  x_draw_init(0.0,100.0,0.0,0);
  set_error_handler(window_error_handler);
  set_flush(true); 
}

window::window()
{ int width  =  x_draw_screen_height()-20;
  int height =  x_draw_screen_height();
  state = 1;
  x_draw_init_window(width,height,x_draw_screen_width()-width,0,
                                                        LEDA::version_string);
  x_draw_init(0.0,100.0,0.0,0);
  set_error_handler(window_error_handler);
  set_flush(true); 
}



void window::init(double x0,double x1,double y0,int gmode)
{ state = 1;
  x_draw_init(x0,x1,y0,gmode); 
 }

window::~window() 
{ set_error_handler(default_error_handler);
  x_draw_end(); 
 }

void window::set_show_coordinates(bool b) 
{ x_draw_set_show_coord(b); }

void window::set_redraw(redraw_func_ptr f) 
{ x_draw_set_redraw(f); }

bool window::set_font(char* s)             
{ return x_draw_set_font(s); }

void window::set_grid_mode(int i)     
{ x_draw_init(x_draw_xmin,x_draw_xmax,x_draw_ymin,i); }


line_style window::set_line_style(line_style s) 
{ return (line_style)x_draw_set_line_style(s); }

int window::set_line_width(int w)    
{ return x_draw_set_line_width(w); }

drawing_mode window::set_mode(drawing_mode m) 
{ return (drawing_mode)x_draw_set_mode(m); }


int window::set_node_width(int w)    
{ return x_draw_set_node_width(w); }

text_mode window::set_text_mode(text_mode m) 
{ return (text_mode)x_draw_set_text_mode(m); }

void  window::set_frame_label(string s) { x_draw_set_frame_label(~s); }
void  window::reset_frame_label()       { x_draw_reset_frame_label(); }

void  window::set_flush(bool b)       { x_draw_screen_flush = b; }

// getting parameters

int          window::get_line_width() { return x_draw_line_width;   }
int          window::get_node_width() { return x_draw_node_width;   }
line_style   window::get_line_style() { return x_draw_line_style;   }
text_mode    window::get_text_mode()  { return x_draw_text_mode;    }
drawing_mode window::get_mode()       { return x_draw_drawing_mode; }

int          window::mono()           { return (x_draw_depth==1);   }

double window::xmin() { return x_draw_xmin; }
double window::xmax() { return x_draw_xmax; }
double window::ymin() { return x_draw_ymin; }
double window::ymax() { return x_draw_ymax; }
double window::scale(){ return x_draw_scale; }

int window::xpix(double x) { return x_draw_xpix(x); }
int window::ypix(double x) { return x_draw_ypix(x); }

double window::pixnum(int p){ return p/x_draw_scale; }

void window::flush() { x_draw_flush(); }

