/*******************************************************************************
+
+  LEDA  3.0
+
+
+  _int_set.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#include <LEDA/int_set.h>

int_set::int_set(int n)
{ size = n; 
  low = 0;
  register int i = 1+size/8;
  if ((V=new char[i]) == 0) error_handler(1,"int_set: out of memory"); 
  while (i--) V[i]=0;
 } 

int_set::int_set(int a, int b)
{ size = b-a+1; 
  low = a;
  register int i = 1+size/8;
  if ((V=new char[i]) == 0) error_handler(1,"int_set: out of memory"); 
  while (i--) V[i]=0;

  mask[0] = 1;
  for(i=1;i<8;i++) mask[i] = (mask[i-1] << 1);

 } 

int_set::int_set(const int_set& b)
{ size = b.size;
  low  = b.low;
  register int n = 1+size/8;
  V = new char[n];
  while (n--) V[n] = b.V[n];
}

int_set& int_set::operator=(const int_set& b)
{ if (this == &b) return *this;
  delete V;
  size = b.size;
  low  = b.low;
  register int n = 1+size/8;
  V = new char[n];
  while (n--) V[n] = b.V[n];
  return *this;
}

void int_set::clear()
{ register int i = 1+size/8;
  while (i--) V[i]=0;
 }
  

int  int_set::member(int x)  const
{ int i = x-low; 
  return (V[i/8] & mask[i%8]); 
 }

void int_set::insert(int x) 
{ int i  =  x-low; 
  V[i/8] |= mask[i%8]; 
 }

void int_set::del(int x)    
{ int i   = x-low; 
  V[i/8] &= ~mask[i%8]; 
 }

int_set& int_set::join(const int_set& b) 
{ register int n = 1+size/8;
  while (n--) V[n] |= b.V[n]; 
  return *this;
 }

int_set& int_set::intersect(const int_set& b) 
{ register int n = 1+size/8;
  while (n--) V[n] &= b.V[n]; 
  return *this;
 }

int_set& int_set::complement() 
{ register int n = 1+size/8;
  while (n--) V[n] = ~V[n]; 
  return *this;
 }

int_set  int_set::operator|(const int_set& b) 
{ int_set res(*this); 
  return res.join(b); 
 }

int_set  int_set::operator&(const int_set& b) 
{ int_set res(*this); 
  return res.intersect(b); 
 }

int_set  int_set::operator~()   
{ int_set res(*this); 
  return res.complement(); 
 }

