/* SCCS @(#)auxgoprot.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                       auxgoprot.layout.c                             */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   auxgoprot.layout.c                                  */
/*                                                                      */
/* DESCRIPTION  :   Geometric operations parameter (rotation)           */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "widgetstructure.h"
#include "auxgoprot.layout.h"
#define MAX_ARGS 100

extern XmFontList gFontlist, gSmall_fontlist;

/********************************************************
/   Creation Function for AUX_geom_rot 
/*******************************************************/

xs_struc_paramprepro
* build_AUX_geom_rot(auxgoprot)
	Widget auxgoprot;
{
	Widget AUX_geom_rot;
	Widget Angle_text;
	Widget max_label;
	Widget min_label;
	Widget Label_2;
	xs_struc_paramprepro *Paramprepro;
	Arg args[MAX_ARGS];
	int n;

	Paramprepro = 
	  (xs_struc_paramprepro *) malloc (sizeof (xs_struc_paramprepro));

	/* Creating AUX_geom_rot Widget */ 

	n = 0;
	XtSetArg(args[n],XmNheight,184); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNwidth,151); n++;
	XtSetArg(args[n],XmNx,16); n++;
	XtSetArg(args[n],XmNy,6); n++;

	AUX_geom_rot = XmCreateForm(auxgoprot,"AUX_geom_rot",args,n);
	XtManageChild(AUX_geom_rot);

	Paramprepro->parent = AUX_geom_rot;

	/* Creating Angle_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,30); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,68); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,45); n++;
	XtSetArg(args[n],XmNvalue, "90"); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	Angle_text = XmCreateText(AUX_geom_rot,"Angle_text",args,n);
	XtManageChild(Angle_text);

	Paramprepro->alpha = Angle_text;

	/* Creating max_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("< 360",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,70); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,45); n++;

	max_label = XmCreateLabel(AUX_geom_rot,"max_label",args,n);
	XtManageChild(max_label);

	/* Creating min_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_END); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("0 <",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,28); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,45); n++;

	min_label = XmCreateLabel(AUX_geom_rot,"min_label",args,n);
	XtManageChild(min_label);

	/* Creating Label_2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[196],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,30); n++;

	Label_2 = XmCreateLabel(AUX_geom_rot,"Label_2",args,n);
	XtManageChild(Label_2);

	return(Paramprepro);
}
