/* SCCS @(#)desctool4.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      desctool4.c                                     */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   desctool4.c                                         */
/*                                                                      */
/* DESCRIPTION  :   .desc File IO operations                            */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "type.h"
#include "structure.h"


int read_desc(fp, desc_to_init)
FILE *fp;
struct description *desc_to_init;
{
    char carlu1[26], carlu2[26], line[80];

    short typ;
    int i, j, nbval, nombre, index;
    int row_initialized, column_initialized, type_initialized;

    struct description *buf1; 

    buf1 = (struct description *) calloc(1,sizeof (struct description));    
    j=fscanf(fp,"%s",carlu1);
    i=0;
    row_initialized = column_initialized = type_initialized = FALSE;
    while (j != EOF){

       if (strcmp(carlu1, "Type:")==0){
          j=fscanf(fp,"%s",carlu1 );

          if (strcmp(carlu1,"binary")== 0) buf1->type = -1;
          else if (strcmp(carlu1,"byte")==0) buf1->type = 0;
          else if (strcmp(carlu1,"int")==0) buf1->type = 2;
          else if (strcmp(carlu1,"short")==0) buf1->type = 1;
          else if (strcmp(carlu1,"float")==0) buf1->type = 3;
          else if (strcmp(carlu1,"cartesian-complex")==0) buf1->type = 4;
          else if (strcmp(carlu1,"cartesian-polar")==0) buf1->type = 5;
          else  buf1->type = 6;
	  type_initialized = TRUE;
       } 
       else if (strcmp(carlu1,"Row-Count:")==0){
              j=fscanf(fp,"%hd",&(buf1->nligne) ); 
		row_initialized = TRUE;
       }
       else if (strcmp(carlu1,"Column-Count:")==0){
              j=fscanf(fp,"%hd",&(buf1->ncolonne) ); 
		column_initialized = TRUE;
       }
       else if (strcmp(carlu1,"Date:")==0){
              if (strcmp(fgets(buf1->date, 26, fp ), "\n"))
		  strcpy(buf1->date, "\0"); 
       }
       else if (strcmp(carlu1,"Comments:")==0){
              j=fscanf(fp,"%s",carlu2 );
              while (j != EOF){
                   strcat(buf1->comment , " ");  
                   strcat(buf1->comment , carlu2);  
                   j=fscanf(fp,"%s",carlu2 );
	      }
       }
       else if (strcmp(carlu1,"Std-Deviation[0]:")==0){
              j=fscanf(fp,"%f\n", &(buf1->ecart[0]) );
       }
       else if (strcmp(carlu1,"Std-Deviation[1]:")==0){
              j=fscanf(fp,"%f", &(buf1->ecart[1]) );
       }
       else if (strcmp(carlu1,"Std-Deviation[2]:")==0){
              j=fscanf(fp,"%f", &(buf1->ecart[2]) );
       }
       else if (strcmp(carlu1,"Std-Deviation[3]:")==0){
              j=fscanf(fp,"%f", &(buf1->ecart[3]) );
       }
       else if (strcmp(carlu1,"Std-Deviation[4]:")==0){
              j=fscanf(fp,"%f", &(buf1->ecart[4]) );
       }
       else if (strcmp(carlu1,"Std-Deviation[5]:")==0){
              j=fscanf(fp,"%f", &(buf1->ecart[5]) );
       }
       else if (strcmp(carlu1,"Avg-Value[0]:")==0){
              j=fscanf(fp, "%f", &(buf1->mu[0]) );
       }
       else if (strcmp(carlu1,"Avg-Value[1]:")==0){
              j=fscanf(fp,"%f", &(buf1->mu[1]) );
       }
       else if (strcmp(carlu1,"Avg-Value[2]:")==0){
              j=fscanf(fp,"%f", &(buf1->mu[2]) );
       }
       else if (strcmp(carlu1,"Avg-Value[3]:")==0){
              j=fscanf(fp,"%f", &(buf1->mu[3]) );
       }
       else if (strcmp(carlu1,"Avg-Value[4]:")==0){
              j=fscanf(fp,"%f", &(buf1->mu[4]) );
       }
       else if (strcmp(carlu1,"Avg-Value[5]:")==0){
              j=fscanf(fp,"%f", &(buf1->mu[5]) );
       }
       else if (strcmp(carlu1,"Avg-Value[6]:")==0){
              j=fscanf(fp,"%f", &(buf1->mu[6]) );
       }
       else if (strcmp(carlu1,"Maximum[0]:")==0){
              j=fscanf(fp,"%f", &(buf1->maxi[0]) );
       }
       else if (strcmp(carlu1,"Maximum[1]:")==0){
              j=fscanf(fp,"%f", &(buf1->maxi[1]) );
       }
       else if (strcmp(carlu1,"Maximum[2]:")==0){
              j=fscanf(fp,"%f", &(buf1->maxi[2]) );
       }
       else if (strcmp(carlu1,"Maximum[3]:")==0){
              j=fscanf(fp,"%f", &(buf1->maxi[3]) );
       }
       else if (strcmp(carlu1,"Maximum[4]:")==0){
              j=fscanf(fp,"%f", &(buf1->maxi[4]) );
       }
       else if (strcmp(carlu1,"Maximum[5]:")==0){
              j=fscanf(fp,"%f", &(buf1->maxi[5]) );
       }
       else if (strcmp(carlu1,"Minimum[0]:")==0){
              j=fscanf(fp,"%f", &(buf1->mini[0]) );
       }
       else if (strcmp(carlu1,"Minimum[1]:")==0){
              j=fscanf(fp,"%f", &(buf1->mini[1]) );
       }
       else if (strcmp(carlu1, "Minimum[2]:")==0){
              j=fscanf(fp,"%f", &(buf1->mini[2]) );
       }
       else if (strcmp(carlu1,"Minimum[3]:")==0){
              j=fscanf(fp,"%f", &(buf1->mini[3]) );
       }
       else if (strcmp(carlu1,"Minimum[4]:")==0){
              j=fscanf(fp,"%f", &(buf1->mini[4]) );
       }
       else if (strcmp(carlu1,"Minimum[5]:")==0){
              j=fscanf(fp,"%f", &(buf1->mini[5]) );
       }
       else return(0);

       j=fscanf(fp,"%s",carlu1);

    }
    if ((!row_initialized) || (!column_initialized) || (!type_initialized))
    return(-1);
   *desc_to_init = *buf1;
   cfree(buf1);
   return(1);
}


int read_desc_gel(fp, desc_to_init)
FILE *fp;
struct description *desc_to_init;
{

    char carlu1[30];

    short typ;
    int i, j, nbval, nombre, index;
    int row_initialized, column_initialized, type_initialized;

    struct description *buf1; 

    buf1 = (struct description *) calloc(1,sizeof (struct description));    
    j=fscanf(fp,"%s",carlu1);
    i=0;
    row_initialized = column_initialized = type_initialized = FALSE;
    while (j != EOF){

       if (strcmp(carlu1,"Row-Count:")==0){
           j=fscanf(fp,"%hd",&(buf1->nligne) ); 
	   row_initialized = TRUE;
       }
       else if (strcmp(carlu1,"Column-Count:")==0){
           j=fscanf(fp,"%hd",&(buf1->ncolonne) ); 
	   column_initialized = TRUE;
       }
       else if (strcmp(carlu1,"Minimum-Gray-Level-Filed:")==0){
           j=fscanf(fp,"%f", &(buf1->mini[0]) );
       }
       else if (strcmp(carlu1,"Maximum-Gray-Level-Filed:")==0){
           j=fscanf(fp,"%f", &(buf1->maxi[0]) );
       }
       else if (strcmp(carlu1, "Type:")==0){
          j=fscanf(fp,"%s",carlu1 );

          if (strcmp(carlu1,"binary")== 0) buf1->type = -1;
          else if (strcmp(carlu1,"byte")==0) buf1->type = 0;
          else if (strcmp(carlu1,"int")==0) buf1->type = 2;
          else if (strcmp(carlu1,"short")==0) buf1->type = 1;
          else if (strcmp(carlu1,"float")==0) buf1->type = 3;
          else if (strcmp(carlu1,"cartesian-complex")==0) buf1->type = 4;
          else if (strcmp(carlu1,"cartesian-polar")==0) buf1->type = 5;
          else  buf1->type = 6;
          j=fscanf(fp,"%d", &(buf1->type) );
          type_initialized = TRUE;
       }
       j=fscanf(fp,"%s",carlu1);

    }
    if (!type_initialized) buf1->type = 1; 
    if ((!row_initialized) || (!column_initialized)) return(-1);
   *desc_to_init = *buf1;
   cfree(buf1);
   return(1);
}


/* 
Routine which writes on to the descriptor file, the descriptor info is contained in buf and the file pointer of the file is 'fp'
*/


int write_desc(fp, buf)
FILE *fp;
struct description buf;
{
  char nomf1[25];
  short typ;

  typ=(int)(buf).type;
  switch (typ){
      case -1: fprintf(fp,"Type: binary\n");
               fprintf(fp,"Row-Count: %d\n",(int)(buf).nligne);
               fprintf(fp,"Column-Count: %d\n",(int)(buf).ncolonne);
               fprintf(fp,"Maximum[0]: %8f\n",(float)(buf).maxi[0]);
               fprintf(fp,"Minimum[0]: %8f\n",(float)(buf).mini[0]);
               fprintf(fp,"Avg-Value[0]: %8f\n",(float)(buf).mu[0]);
               fprintf(fp,"Std-Deviation[0]: %8f\n",(float)(buf).ecart[0]);
               fprintf(fp,"Date: %s\n",(buf).date);
               fprintf(fp, "Comments: %s\n",(buf).comment); 
               break;
       case 0: fprintf(fp,"Type: byte\n");
               fprintf(fp,"Row-Count: %d\n",(int)(buf).nligne);
               fprintf(fp,"Column-Count: %d\n",(int)(buf).ncolonne);
               fprintf(fp,"Maximum[0]: %8f\n",(float)(buf).maxi[0]);
               fprintf(fp,"Minimum[0]: %8f\n",(float)(buf).mini[0]);
               fprintf(fp,"Avg-Value[0]: %8f\n",(float)(buf).mu[0]);
               fprintf(fp,"Std-Deviation[0]: %8f\n",(float)(buf).ecart[0]);
               fprintf(fp,"Date: %s\n",(buf).date);

               fprintf(fp, "Comments: %s\n",(buf).comment);
               break;
       case 1: fprintf(fp,"Type: short\n"); 
               fprintf(fp,"Row-Count: %d\n",(int)(buf).nligne);
               fprintf(fp,"Column-Count: %d\n",(int)(buf).ncolonne);
               fprintf(fp,"Maximum[0]: %8f\n",(float)(buf).maxi[0]);
               fprintf(fp,"Minimum[0]: %8f\n",(float)(buf).mini[0]);
               fprintf(fp,"Avg-Value[0]: %8f\n",(float)(buf).mu[0]);
               fprintf(fp,"Std-Deviation[0]: %8f\n",(float)(buf).ecart[0]);
               fprintf(fp,"Date: %s\n",(buf).date);
               fprintf(fp, "Comments: %s\n",(buf).comment); 
               break;
       case 2: fprintf(fp,"Type: int\n");
               fprintf(fp,"Row-Count: %d\n",(int)(buf).nligne);
               fprintf(fp,"Column-Count: %d\n",(int)(buf).ncolonne); 
               fprintf(fp,"Maximum[0]: %8f\n",(float)(buf).maxi[0]);
               fprintf(fp,"Minimum[0]: %8f\n",(float)(buf).mini[0]);
               fprintf(fp,"Avg-Value[0]: %8f\n",(float)(buf).mu[0]);
               fprintf(fp,"Std-Deviation[0]: %8f\n",(float)(buf).ecart[0]);
               fprintf(fp,"Date: %s\n",(buf).date);
               fprintf(fp, "Comments: %s\n",(buf).comment);
               break;
       case 3: fprintf(fp,"Type: float\n");
               fprintf(fp,"Row-Count: %d\n",(int)(buf).nligne);
               fprintf(fp,"Column-Count: %d\n",(int)(buf).ncolonne);
               fprintf(fp,"Maximum[0]: %8f\n",(float)(buf).maxi[0]);
               fprintf(fp,"Minimum[0]: %8f\n",(float)(buf).mini[0]);
               fprintf(fp,"Avg-Value[0]: %8f\n",(float)(buf).mu[0]);
               fprintf(fp,"Std-Deviation[0]: %8f\n",(float)(buf).ecart[0]);
               fprintf(fp,"Date: %s\n",(buf).date);
               fprintf(fp, "Comments: %s\n",(buf).comment);
               break;
       case 4: fprintf(fp,"Type: cartesian-complex\n");
               fprintf(fp,"Row-Count: %d\n",(int)(buf).nligne);
               fprintf(fp,"Column-Count: %d\n",(int)(buf).ncolonne);
               fprintf(fp,"Minimum[0]: %8f\n",(float)(buf).mini[0]);
               fprintf(fp,"Minimum[1]: %8f\n",(float)(buf).mini[1]);
               fprintf(fp,"Maximum[0]: %8f\n",(float)(buf).maxi[0]);
               fprintf(fp,"Maximum[1]: %8f\n",(float)(buf).maxi[1]);
               fprintf(fp,"Avg-Value[0]: %8f\n",(float)(buf).mu[0]);
               fprintf(fp,"Avg-Value[1]: %8f\n",(float)(buf).mu[1]);
               fprintf(fp,"Std-Deviation[0]: %8f\n",(float)(buf).ecart[0]);
               fprintf(fp,"Std-Deviation[1]: %8f\n",(float)(buf).ecart[1]);
               fprintf(fp,"Date: %s\n",(buf).date);
               fprintf(fp, "Comments: %s\n",(buf).comment);
               break;
       case 5: fprintf(fp,"Type: polar-complex\n");
               fprintf(fp,"Row-Count: %d\n",(int)(buf).nligne);
               fprintf(fp,"Column-Count: %d\n",(int)(buf).ncolonne);
               fprintf(fp,"Minimum[0]: %8f\n",(float)(buf).mini[0]);
               fprintf(fp,"Minimum[1]: %8f\n",(float)(buf).mini[1]);
               fprintf(fp,"Maximum[0]: %8f\n",(float)(buf).maxi[0]);
               fprintf(fp,"Maximum[1]: %8f\n",(float)(buf).maxi[1]);
               fprintf(fp,"Avg-Value[0]: %8f\n",(float)(buf).mu[0]);
               fprintf(fp,"Avg-Value[1]: %8f\n",(float)(buf).mu[1]);
               fprintf(fp,"Std-Deviation[0]: %8f\n",(float)(buf).ecart[0]);
               fprintf(fp,"Std-Deviation[1]: %8f\n",(float)(buf).ecart[1]);  
               fprintf(fp,"Date: %s\n",(buf).date);
               fprintf(fp, "Comments: %s\n",(buf).comment);
               break;
       case 6: fprintf(fp,"Type: rgb\n");
               fprintf(fp,"Row-Count: %d\n",(int)(buf).nligne);
               fprintf(fp,"Column-Count: %d\n",(int)(buf).ncolonne);
               fprintf(fp,"Minimum[0]: %8f\n",(float)(buf).mini[0]);
               fprintf(fp,"Minimum[1]: %8f\n",(float)(buf).mini[1]);
               fprintf(fp,"Minimum[2]: %8f\n",(float)(buf).mini[2]);
               fprintf(fp,"Minimum[3]: %8f\n",(float)(buf).mini[3]);
               fprintf(fp,"Minimum[4]: %8f\n",(float)(buf).mini[4]);
               fprintf(fp,"Minimum[5]: %8f\n",(float)(buf).mini[5]);
               fprintf(fp,"Maximum[0]: %8f\n",(float)(buf).maxi[0]);
               fprintf(fp,"Maximum[1]: %8f\n",(float)(buf).maxi[1]);
               fprintf(fp,"Maximum[2]: %8f\n",(float)(buf).maxi[2]);
               fprintf(fp,"Maximum[3]: %8f\n",(float)(buf).maxi[3]);
               fprintf(fp,"Maximum[4]: %8f\n",(float)(buf).maxi[4]);
               fprintf(fp,"Maximum[5]: %8f\n",(float)(buf).maxi[5]);
               fprintf(fp,"Avg-Value[0]: %8f\n",(float)(buf).mu[0]);
               fprintf(fp,"Avg-Value[1]: %8f\n",(float)(buf).mu[1]);
               fprintf(fp,"Avg-Value[2]: %8f\n",(float)(buf).mu[2]);
               fprintf(fp,"Avg-Value[3]: %8f\n",(float)(buf).mu[3]);
               fprintf(fp,"Avg-Value[4]: %8f\n",(float)(buf).mu[4]);
               fprintf(fp,"Avg-Value[5]: %8f\n",(float)(buf).mu[5]);
               fprintf(fp,"Std-Deviation[0]: %8f\n",(float)(buf).ecart[0]);
               fprintf(fp,"Std-Deviation[1]: %8f\n",(float)(buf).ecart[1]);
               fprintf(fp,"Std-Deviation[2]: %8f\n",(float)(buf).ecart[2]);
               fprintf(fp,"Std-Deviation[3]: %8f\n",(float)(buf).ecart[3]);
               fprintf(fp,"Std-Deviation[4]: %8f\n",(float)(buf).ecart[4]);
               fprintf(fp,"Std-Deviation[5]: %8f\n",(float)(buf).ecart[5]);  
               fprintf(fp,"Date: %s\n",(buf).date);
               fprintf(fp, "Comments: %s\n",(buf).comment);  
               break;
    }
 return(1);
}



/* 
Routine which writes on to the descriptor file, the descriptor info is conatined in buf and the file pointer of the file is 'fp'
*/


int write_desc_gel(fp, buf)
FILE *fp;
struct description buf;
{
  char nomf1[25];
  short typ;
  
  typ=(int)(buf).type;
  switch (typ){
    case -1: fprintf(fp,"Type: binary\n"); break;
    case 0: fprintf(fp,"Type: byte\n"); break;
    case 1: fprintf(fp,"Type: short\n"); break;
    case 2: fprintf(fp,"Type: int\n"); break;
    case 3: fprintf(fp,"Type: float\n"); break;
    default: break;
    }
  fprintf(fp,"Row-Count: %d\n",(int)(buf).nligne);
  fprintf(fp,"Column-Count: %d\n",(int)(buf).ncolonne);
  fprintf(fp,"Maximum-Gray-Level-Filed: %8f\n",(float)(buf).maxi[0]);
  fprintf(fp,"Minimum-Gray-Level-Filed: %8f\n",(float)(buf).mini[0]);

  return(1);
}
