/*****************************************************************************/
/* module macro.c							     */
/*									     */
/* Author: Alain Jacot-Descombes					     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1989							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/
#include <suntool/sunview.h>
#include <suntool/textsw.h>
#include <suntool/panel.h>
#include <suntool/canvas.h>
#include <suntool/menu.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "type.h"
#include "define.h"
#include "structure.h"
#include "global.h"

struct pertile /* liste des parametres pour high pass filter  */
{
    float   ptiledata;    
    int	    n_block;	  
    float   alpha;	  
};
struct rayon_puissan { /* liste des parametres pour puissance  */
    float   p_energy;	  
    int	    r_frequency;  
    int	    n_point;	  
};
struct gaussian_p { /* liste des parametres pour filtre gauss  */
    float   en_mint;	  
    int	    mint;	  
};
/* a mettre dans structure.h et oter de urgent.c */

struct reg_grow		     /* liste des criteres pour region growing */
    {
	int choix;	       /* 0 = esp, 1 = esp-2, 2 = var, 3 = err */
	float toler;			   /* tolerance sur le critere */
	struct reg_grow *next_rg;
    };
/* a mettre dans structure.h et oter de segment.c */

#define	    LIBRE   0
#define	    LIRE    1
#define	    ECRIRE  2
#define	    MAX_FROMTO	4

extern int Confirm();

Frame       frame_macro;
Textsw      texte_macro;
Panel       panel_macro;
Panel_item  bouton_creer, bouton_exec, bouton_lire, bouton_sauver, bouton_quit;
Panel_item  bouton_afficher, no_macro, nom;
Menu	    mexec, framemacromenu;
int	    no = 0, flag_file = LIBRE; 
char	    filename[40];
char	    *bufsuite;
int         flag_macro_win_open = FALSE;
int         flag_in_macro = FALSE;

/*****************************************************************************/

struct commande *reserve ()
{
    struct commande *temp;
    int	i;

    temp = (struct commande *) malloc (sizeof(*temp));
    for (i=0; i<MAX_FROMTO; i++){
	temp->from[i] = temp->to[i] = -1;
    }
    temp->param = NULL;
    temp->next = NULL;
    return(temp);
}

/*****************************************************************************/

struct commande *new_commande (macro_cour)
    struct  commande	**macro_cour;
{
    struct  commande	*temp, *com;

    if (*macro_cour == NULL) {
	*macro_cour = reserve ();
	return (*macro_cour);
    }
    else {
	temp = *macro_cour;
        while (temp->next != NULL) temp = temp->next;
	com = reserve ();
	temp->next = com;
	return (com);	
    }
}

/*****************************************************************************/

int write_macro (buf)
    char * buf;
{
    if (buf == NULL) {
        window_bell (frame);
    }
    else {
        textsw_insert (texte_macro, buf, strlen (buf));
    }
    return;
}

/*****************************************************************************/

int which_code (unite)
    char *unite;
{
    if (*unite == 'P' && *(unite+1) == 'R'){
	/* morphologie binaire */
	if (strcmp(unite, "PROBMO")==0) return(600);
	if (strcmp(unite, "PROBMODIS")==0) return(601);
	if (strcmp(unite, "PROBMOLTRCOM")==0) return(620);
	if (strcmp(unite, "PROBMOLTRINT")==0) return(621);
	if (strcmp(unite, "PROBMOLTRUNI")==0) return(622);
	if (strcmp(unite, "PROBMOLTRSDI")==0) return(623);
	if (strcmp(unite, "PROBMOLTRDIF")==0) return(624);
	if (strcmp(unite, "PROBMOSTRERO")==0) return(630);
	if (strcmp(unite, "PROBMOSTRCER")==0) return(631);
	if (strcmp(unite, "PROBMOSTRLER")==0) return(632);
	if (strcmp(unite, "PROBMOSTRDIL")==0) return(633);
	if (strcmp(unite, "PROBMOSTRCDI")==0) return(634);
	if (strcmp(unite, "PROBMOSTRLDI")==0) return(635);
	if (strcmp(unite, "PROBMOSTROPE")==0) return(636);
	if (strcmp(unite, "PROBMOSTRCLO")==0) return(637);
	if (strcmp(unite, "PROBMOTHIHOL")==0) return(640);
	if (strcmp(unite, "PROBMOTHIHOD")==0) return(641);
	if (strcmp(unite, "PROBMOTHIPRU")==0) return(642);
	if (strcmp(unite, "PROBMOTHIBOU")==0) return(643);
	if (strcmp(unite, "PROBMOTHCIPM")==0) return(650);
	if (strcmp(unite, "PROBMOTHCHOL")==0) return(651);
	if (strcmp(unite, "PROBMOTHCHOD")==0) return(652);
	if (strcmp(unite, "PROBMOTHCTCE")==0) return(653);
	if (strcmp(unite, "PROBMOTHCTCC")==0) return(654);
	if (strcmp(unite, "PROBMOHMTEPS")==0) return(661);
	if (strcmp(unite, "PROBMOHMTIPI")==0) return(662);
	if (strcmp(unite, "PROBMOHMTTPS")==0) return(663);
	if (strcmp(unite, "PROBMOHLTBOU")==0) return(670);
	if (strcmp(unite, "PROBMOHLTEBO")==0) return(671);
	if (strcmp(unite, "PROBMOHLTFHO")==0) return(672);
	if (strcmp(unite, "PROBMOHLTHSK")==0) return(673);
	if (strcmp(unite, "PROBMOHLTHMA")==0) return(674);
	if (strcmp(unite, "PROBMOHLTPCH")==0) return(675);
	if (strcmp(unite, "PROBMOHLTSCH")==0) return(676);
	if (strcmp(unite, "PROBMOHLTSZI")==0) return(677);
	if (strcmp(unite, "PROBMOCTHHOL")==0) return(680);
	if (strcmp(unite, "PROBMOCTHHOD")==0) return(681);
	if (strcmp(unite, "PROBMOCTHPRU")==0) return(682);
	if (strcmp(unite, "PROBMOCTCIPM")==0) return(690);
	if (strcmp(unite, "PROBMOCTCHOL")==0) return(691);
	if (strcmp(unite, "PROBMOCTCHOD")==0) return(692);
	if (strcmp(unite, "PROBMOCTCTCE")==0) return(693);
	if (strcmp(unite, "PROBMOCTCTCC")==0) return(694);
	if (strcmp(unite, "PROBMOQUI")==0) return(699);
    }
    if (strcmp(unite, "I_OLIMPST")==0) return(-1);
    if (strcmp(unite, "I_OLIMSTA")==0) return(1);
    if (strcmp(unite, "I_OLIMM8B")==0) return(2);
    if (strcmp(unite, "I_OLIMM12B")==0) return(3);
    if (strcmp(unite, "I_OLIMLTS")==0) return(4);
    if (strcmp(unite, "I_OLIMRGB")==0) return(5);
    if (strcmp(unite, "I_OLIMSRA")==0) return(6);

    if (strcmp(unite, "I_OSIMSPL")==0) return(130);
    if (strcmp(unite, "I_OSIMCCA")==0) return(131);
    if (strcmp(unite, "I_OSIMCPO")==0) return(132);
    if (strcmp(unite, "I_OSIMRGB")==0) return(133);
    if (strcmp(unite, "I_OSIMSRA")==0) return(136);

    if (strcmp(unite, "I_OPOSNOR")==0) return(134);
    if (strcmp(unite, "I_OPOSMAX")==0) return(135);


    if (strcmp(unite, "DISSIMGLI")==0) return(10);
    if (strcmp(unite, "DISSIMGLO")==0) return(11);
    if (strcmp(unite, "DISSIMRDI")==0) return(12);
    if (strcmp(unite, "DISSIMRFS")==0) return(13);
    if (strcmp(unite, "DISSIMTHR")==0) return(14);
    if (strcmp(unite, "DISSIMFST")==0) return(15);

    if (strcmp(unite, "AUXCONBIN")==0) return(20);
    if (strcmp(unite, "AUXCONBYT")==0) return(21);
    if (strcmp(unite, "AUXCONSHO")==0) return(22);
    if (strcmp(unite, "AUXCONINT")==0) return(23);
    if (strcmp(unite, "AUXCONFLO")==0) return(24);
    if (strcmp(unite, "AUXCONCOM")==0) return(25);
    if (strcmp(unite, "AUXCONCPO")==0) return(26);
    if (strcmp(unite, "AUXCONPCA")==0) return(27);
    if (strcmp(unite, "AUXCONRGR")==0) return(123);

    if (strcmp(unite, "MEAHISCAL")==0) return(30);
    if (strcmp(unite, "MEAHISSHO")==0) return(31);
    if (strcmp(unite, "MEAHISPRI")==0) return(32);
    if (strcmp(unite, "MEAPOWCPO")==0) return(33);
    if (strcmp(unite, "MEAPOWCPO")==0) return(34);

    if (strcmp(unite, "AUXAOP2PLADD")==0) return(40);
    if (strcmp(unite, "AUXAOP2PLSUBP")==0) return(41);
    if (strcmp(unite, "AUXAOP2PLMUL")==0) return(42);
    if (strcmp(unite, "AUXAOP2PLDIV")==0) return(43);
    if (strcmp(unite, "AUXAOP1PCADD")==0) return(44);
    if (strcmp(unite, "AUXAOP1PCSUB")==0) return(45);
    if (strcmp(unite, "AUXAOP1PCMUL")==0) return(46);
    if (strcmp(unite, "AUXAOP1PCDIV")==0) return(47);
    if (strcmp(unite, "AUXAOP4PLMUL")==0) return(48);
    if (strcmp(unite, "AUXAOP2PCMUL")==0) return(49);

    if (strcmp(unite, "PROTRAFT2")==0) return(50);
    if (strcmp(unite, "PROTRAIF2")==0) return(51);
    if (strcmp(unite, "PROTRAOF2")==0) return(52);
    if (strcmp(unite, "PROTRAOIF")==0) return(53);
    if (strcmp(unite, "PROTRARF2")==0) return(54);
    if (strcmp(unite, "PROTRAROF")==0) return(55);
    if (strcmp(unite, "PROATHLPH")==0) return(56);
    if (strcmp(unite, "PROATHDTH")==0) return(57);

    if (strcmp(unite, "PROCONCONWMA")==0) return(60);
    if (strcmp(unite, "PROCONCONWIM")==0) return(61);
    if (strcmp(unite, "PROCONCORWMA")==0) return(62);
    if (strcmp(unite, "PROCONCORWIM")==0) return(63);
    if (strcmp(unite, "PROCONCMA")==0) return(64);

    if (strcmp(unite, "PROTHR")==0) return(99);
    if (strcmp(unite, "PROEDGSOB")==0) return(100);
    if (strcmp(unite, "PROEDGLAP")==0) return(101);
    if (strcmp(unite, "PROEDGROB")==0) return(102);
    if (strcmp(unite, "PROEDGFCH")==0) return(103);
    if (strcmp(unite, "PROEDGMVA")==0) return(104);
    if (strcmp(unite, "PROEDGZCR")==0) return(105);
    if (strcmp(unite, "PROEDGRRI")==0) return(106);

    if (strcmp(unite, "PROREGGRAGCO")==0) return(140);
/* PROREGRGR n'existe plus */
    if (strcmp(unite, "PROREGRGR")==0) return(141);
    if (strcmp(unite, "PROREGOPRGRA")==0) return(142);
    if (strcmp(unite, "PROREGGRAGIM")==0) return(143);
    if (strcmp(unite, "PROREGGRAREX")==0) return(144);
    if (strcmp(unite, "PROREGGRAESR")==0) return(145);

    if (strcmp(unite, "AUXGOPROT")==0) return(110);
    if (strcmp(unite, "AUXGOPTRA")==0) return(111);
    if (strcmp(unite, "AUXGOPSCS")==0) return(112);
    if (strcmp(unite, "AUXGOPSCF")==0) return(113);
    if (strcmp(unite, "AUXGOPTRP")==0) return(114);
    if (strcmp(unite, "AUXGOPSYX")==0) return(115);
    if (strcmp(unite, "AUXGOPSYY")==0) return(116);
    if (strcmp(unite, "AUXMODCAP")==0) return(117);

    if (strcmp(unite, "MEAIST")==0) return(120);
    if (strcmp(unite, "AUXFMEAPL")==0) return(1210);
    if (strcmp(unite, "AUXFMESPL")==0) return(1211);
    if (strcmp(unite, "AUXFMEAVE")==0) return(1212);
    if (strcmp(unite, "AUXFMESVE")==0) return(1213);
    if (strcmp(unite, "AUXCOP")==0) return(122);

    if (strcmp(unite, "AUXMODPADCON")==0) return(1240);
    if (strcmp(unite, "AUXMODPADPRO")==0) return(1241);
    if (strcmp(unite, "AUXMODPADPER")==0) return(1242);
    if (strcmp(unite, "AUXMODNOIUNI")==0) return(1250);
    if (strcmp(unite, "AUXMODNOIGAU")==0) return(1251);
    if (strcmp(unite, "AUXMODENL1OI")==0) return(1252);

    if (strcmp(unite, "PROGSMERO")==0) return(160);
    if (strcmp(unite, "PROGSMDIL")==0) return(161);
    if (strcmp(unite, "PROGSMOPE")==0) return(162);
    if (strcmp(unite, "PROGSMCLO")==0) return(163);

    if (strcmp(unite, "PREHEQ")==0) return(180);
    if (strcmp(unite, "PREENHMFI")==0) return(181);
    if (strcmp(unite, "PREENHHPF")==0) return(182);
    if (strcmp(unite, "PREENHFFDHAM")==0) return(183);
    if (strcmp(unite, "PREENHFFDHAN")==0) return(184);
    if (strcmp(unite, "PRECBA")==0) return(185);
    if (strcmp(unite, "PREENHFFDGAU")==0) return(186);


    if (strcmp(unite, "AUXLOPAND")==0) return(550);
    if (strcmp(unite, "AUXLOPAWM")==0) return(551);
    if (strcmp(unite, "AUXLOPOR")==0) return(552);
    if (strcmp(unite, "AUXLOPXOR")==0) return(553);
    if (strcmp(unite, "AUXLOPNOT")==0) return(554);

    if (strcmp(unite, "GEL1D")==0) return(950);
    if (strcmp(unite, "GEL1CFP")==0) return(960);
    if (strcmp(unite, "GEL1AFP")==0) return(961);
    if (strcmp(unite, "GEL1CFE")==0) return(970);
    if (strcmp(unite, "GEL1AFE")==0) return(971);
    if (strcmp(unite, "GEL1CPR")==0) return(980);
    if (strcmp(unite, "GEL1AFID")==0) return(981);
    if (strcmp(unite, "GEL1THRE")==0) return(985);
    if (strcmp(unite, "GEL1PIC")==0) return(986);
    if (strcmp(unite, "GEL1MAT")==0) return(987);
    if (strcmp(unite, "GEL1SPIC")==0) return(988);
/*    if (strcmp(unite, "GEL1AFPR")==0) return(982); */
    if (strcmp(unite, "GEL1PLAN")==0) return(990);
    if (strcmp(unite, "GEL1AFFI")==0) return(991);
    if (strcmp(unite, "GEL1DSAV")==0) return(992);
    if (strcmp(unite, "GEL1DGET")==0) return(993);
    if (strcmp(unite, "GEL1DLIS")==0) return(994);
    if (strcmp(unite, "GEL1DEXT")==0) return(999);
    if (strcmp(unite, "MEACREFREBC8")==0) return(3001);
    if (strcmp(unite, "MEACREFRECC8")==0) return(3002);
    if (strcmp(unite, "MEACREFREBC4")==0) return(3003);
    if (strcmp(unite, "MEACREFRECC4")==0) return(3004);
    if (strcmp(unite, "MEACRESCO")==0) return(3010);
    if (strcmp(unite, "PIXEDIT")==0) return(3020);
}

/*****************************************************************************/

faire_com(buf)
    char *buf;
{
    char *line, *unite;
    int	flag, index;
    struct commande *com;

    line = (char *)malloc(strlen(buf)+1);
    strcpy (line, buf);
    unite = strtok (line, " ");
    com = new_commande(&macro_cour);
    flag = 0;
    while (unite != NULL){
	write_macro (unite);
        switch (flag){
	    case 0: /* nom de la commande */	    
	        strcpy (com->nom, unite);  
	        com->code = which_code (unite);
		flag++;  break;
	    case 1: /* WITH, FROM, TO */
		if (strcmp(unite,"FROM") == 0) flag = 2;
		else if (strcmp(unite, "TO") == 0) flag = 3;
		else if (strcmp(unite, "WITH") == 0) flag = 4;
		index = 0;
		break;
	    case 2: /* argument de FROM */
		if (strcmp(unite, "TO") == 0) {flag = 3; index = 0;}
		else if (strcmp(unite, "WITH") == 0) {flag = 4; index = 0;}
		else {
		    com->from[index] = atoi(unite);  
		    index++;
		}
		break;
	    case 3: /* argument de TO */
		if (strcmp(unite, "WITH") == 0) {flag = 4; index = 0;}
		else {
		    com->to[index] = atoi(unite);  
		    index++;
		}
		break;
	    case 4: /* argument de WITH */
		switch (com->code){
		    case -1: case 1: case 2: case 3: case 6:
		    case 130: case 131: case 132: case 133: case 134: case 135:
		    case 988: case 993: {
			struct fname *p;
			p = (struct fname *)malloc(sizeof(*p));
			com->param = (char *)p;
			strcpy(p->filename,unite);
			break;
		    }
		    case 4: case 5:{
			struct lecture_lts *p;
			if (index==0){
			    p = (struct lecture_lts *)malloc(sizeof(*p));
			    com->param = (char *)p;
			}
			else p = (struct lecture_lts *)com->param;
			switch (index){
			    case 0: strcpy (p->filename,unite);  break;
			    case 1: p->header = atoi (unite);  break;
			    case 2: p->nlignes = atoi (unite);  break;
			    case 3: p->nbytes = atoi (unite);  break;
			    case 4: p->nvaleur = atoi (unite);  break;
			    case 5: p->bytes_sautes = atoi (unite);  break;
			}
			index++;
			break;
		    }
		    case 181:{
			struct filmed *p;
			if (index == 0){
			    p = (struct filmed *) malloc(sizeof(*p));
			    com->param = (char *)p;
			}
			else p = (struct filmed *)com->param;
			switch (index){
			    case 0: p->ncol = atoi (unite); break;
			    case 1: p->nlin = atoi (unite); break;
			}
			index++;
			break;
		    }
		    case 182:{
			struct pertile *p;
			if (index == 0){
			    p = (struct pertile *) malloc(sizeof(*p));
			    com->param = (char *)p;
			}
			else p = (struct pertile *)com->param;
			switch (index){
			    case 0: p->alpha = (float)atof (unite); break;
			}
			index++;
			break;
		    }
		    case 183: case 184: case 34:{
			struct rayon_puissan *p;
			if (index == 0){
			    p = (struct rayon_puissan *) malloc(sizeof(*p));
			    com->param = (char *)p;
			}
			else p = (struct rayon_puissan *)com->param;
			switch (index){
			    case 0: p->r_frequency = atoi (unite); break;
			}
			index++;
			break;
		    }
		    case 186: {
			struct gaussian_p *p;
			if (index == 0){
			    p = (struct gaussian_p *) malloc(sizeof(*p));
			    com->param = (char *)p;
			}
			else p = (struct gaussian_p *)com->param;
			switch (index){
			    case 0: p->mint = atoi (unite); break;
			    case 1: p->en_mint = (float) atof (unite); break;
			}
			index++;
			break;
		    }
		    case 1252: {
			struct rayon_puissan *p;
			if (index == 0){
			    p = (struct rayon_puissan *) malloc(sizeof(*p));
			    com->param = (char *)p;
			}
			else p = (struct rayon_puissan *)com->param;
			switch (index){
			    case 0: p->n_point = atoi (unite); break;
			}
			index++;
			break;
		    }
		    case 185:{
			struct convol *p;
			if (index == 0){
			    p = (struct convol *) malloc(sizeof(*p));
			    com->param = (char *)p;
			}
			else p = (struct convol *)com->param;
			switch (index){
			    case 0: p->colonne = atoi (unite); break;
			    case 1: p->ligne = atoi (unite); break;
			}
			index++;
			break;
		    }
		    case 56:{
			struct pertile *p;
			if (index == 0){
			    p = (struct pertile *) malloc(sizeof(*p));
			    com->param = (char *)p;
			}
			else p = (struct pertile *)com->param;
			switch (index){
			    case 0: p->ptiledata = (float) atof (unite); break;
			}
			index++;
			break;
		    }
		    case 57:{
			struct pertile *p;
			if (index == 0){
			    p = (struct pertile *) malloc(sizeof(*p));
			    com->param = (char *)p;
			}
			else p = (struct pertile *)com->param;
			switch (index){
			    case 0: p->n_block = atoi (unite); break;
			}
			index++;
			break;
		    }
		    case 33:{
			struct rayon_puissan  *p;
			if (index == 0){
			    p = (struct rayon_puissan *) malloc(sizeof(*p));
			    com->param = (char *)p;
			}
			else p = (struct rayon_puissan *)com->param;
			switch (index){
			    case 0: p->p_energy = (float) atof (unite); break;
			}
			index++;
			break;
		    }
		    case 20: case 100: case 101: case 102: case 142: case 145:{
			int *p;
			p = (int *)malloc(sizeof(*p));
			com->param = (char *)p;
			*p = atoi (unite);
			break;
		    }
		    case 21: case 22: case 23: case 24: case 25: {
			struct convert *p;
			if (index==0){
			    p = (struct convert *)malloc(sizeof(*p));
			    com->param = (char *)p;
			}
			else p = (struct convert *)com->param;
			switch (index){
			    case 0: 
				if (strcmp(unite, "MIN") == 0){
				    p->mind = 0;
				    p->flag_mind = TRUE;
				}
				else{
				    p->mind = (float)atof (unite);
				    p->flag_mind = FALSE;
				}
				break;
			    case 1: 
				if (strcmp(unite, "MAX") == 0){
				    p->maxd = 0;
				    p->flag_maxd = TRUE;
				}
				else{
				    p->maxd = (float)atof (unite);
				    p->flag_maxd = FALSE;
				}
				break;
			    case 2: 
				if (strcmp(unite, "MIN") == 0){
				    p->mina = 0;
				    p->flag_mina = TRUE;
				}
				else{
				    p->mina = (float)atof (unite);
				    p->flag_mina = FALSE;
				}
				break;
			    case 3:
				if (strcmp(unite, "MAX") == 0){
				    p->maxa = 0;
				    p->flag_maxa = TRUE;
				}
				else{
				    p->maxa = (float)atof (unite);
				    p->flag_maxa = FALSE;
				}
				break;
			}
			index++;
			break;
		    }
		    case 30:{
			struct description_vecteur *p;
			struct histogr *q;
			if (index==0){
			    p=(struct description_vecteur *)malloc(sizeof(*p));
			    q=(struct histogr *)malloc(sizeof(*q));
			    p->prive = (char *)q;
			    com->param = (char *)p;
			}
			else p = (struct description_vecteur *)com->param;
			switch (index){
			    case 0: p->b_min = atoi (unite);  break;
			    case 1: p->b_max = atoi (unite);  break;
			    case 2: p->ncase = atoi (unite);  break;
			}
			index++;
			break;
		    }
		    case 31:{
			struct description_vecteur *p;
			struct histogr *q;
			if (index==0){
			    p=(struct description_vecteur *)malloc(sizeof(*p));
			    q=(struct histogr *)malloc(sizeof(*q));
			    p->prive = (char *)q;
			    com->param = (char *)p;
			}
			else q = (struct histogr *)
			    ((struct description_vecteur *)com->param)->prive;
			switch (index){
			    case 0: q->haut_barre = atoi (unite);  break;
			    case 1: q->larg_barre = atoi (unite);  break;
			}
			index++;
			break;
		    }
		    case 32:{
			struct description_vecteur  *p;
			struct histogr	*q;
			struct fname	*f;
			if (index==0){
			    p=(struct description_vecteur *)malloc(sizeof(*p));
			    q=(struct histogr *)malloc(sizeof(*q));
			    f=(struct fname *)malloc(sizeof(*f));
			    q->fileps = f;
			    p->prive = (char *)q;
			    com->param = (char *)p;
			}
			else q = (struct histogr *)
			    ((struct description_vecteur *)com->param)->prive;
			switch (index){
			    case 0: q->haut_barre = atoi (unite);  break;
			    case 1: q->larg_barre = atoi (unite);  break;
			    case 2: strcpy(q->fileps->filename,unite); break;
			}
			index++;
			break;
		    }
		    case 44:  case 45:  case 46:  case 47: case 49: 
		    case 985 :{
			struct cte_cmplx *p;
			if (index==0){
			    p = (struct cte_cmplx *)malloc(sizeof(*p));
			    com->param = (char *)p;
			}
			else p = (struct cte_cmplx *)com->param;
			switch (index){
			    case 0: p->reel = (float)atof (unite);  break;
			    case 1: p->im = (float)atof (unite);  break;
			}
			index++;
			break;
		    }
		    case 60:  case 62:  case 64:{
			struct convol *p;
			float *m;
			if (index==0){
			    p=(struct convol *)malloc(sizeof(*p));
			    com->param = (char *)p;
			}
			else p = (struct convol *)com->param;
			switch (index){
			    case 0: p->ligne = atoi (unite);  break;
			    case 1: p->colonne = atoi (unite);  break;
			    case 2: 
				p->factmult = (float)atof(unite);
				m = (float *)malloc
				    (p->ligne * p->colonne * sizeof(*m));
				p->masque = m;
				break;
			    default :
				*m = (float)atof(unite);
				m++;
				break;		
			}
			index++;
			break;
		    }
		    case 110: case 111: case 112: case 113: {
			struct affin *p;
			if (index==0){
			    p = (struct affin *)malloc(sizeof(*p));
			    com->param = (char *)p;
			}
			else p = (struct affin *)com->param;
			switch (index){
			    case 0: p->c1 = (float)atof (unite);  break;
			    case 1: p->c2 = (float)atof (unite);  break;
			}
			index++;
			break;
		    }
		    case 117: {
			struct cut_s *p;
			if (index==0){
			    p = (struct cut_s *)malloc(sizeof(*p));
			    com->param = (char *)p;
			}
			else p = (struct cut_s *)com->param;
			switch (index){
			    case 0: p->XMin = atoi (unite);  break;
			    case 1: p->YMin = atoi (unite);  break;
			    case 2: p->XMax = atoi (unite);  break;
			    case 3: p->YMax = atoi (unite);  break;
			}
			index++;
			break;
		    }
		    case 141: case 144: {
			struct reg_grow *p;
			if (index == 0) {
			    p = (struct reg_grow *)malloc(sizeof(*p));
			    p->next_rg = NULL;
			    com->param = (char *)p;
			}
			else {
			    p = (struct reg_grow *)com->param;
			    while (p->next_rg != NULL) p = p->next_rg;
			    if ((index % 2)==0){
				p->next_rg = (struct reg_grow *)
				             malloc(sizeof(*p));
				p = p->next_rg;
				p->next_rg = NULL;
				p->choix = (int)atoi (unite);
			    }
			    else
				p->toler = (float) atof (unite);
			}
			index++;
			break;
		    }
		    case 160: case 161: case 162: case 163: {
			struct element *p;
			if (index==0){
			    p = (struct element *)malloc(sizeof(*p));
			    com->param = (char *)p;
			}
			else p = (struct element *)com->param;
			switch (index){
			    case 0: 
				if (strcmp(unite, "SP")==0) p->type = 0;
				else if (strcmp(unite, "CO")==0) p->type = 1;
				else if (strcmp(unite, "CY")==0) p->type = 2;
				else if (strcmp(unite, "GA")==0) p->type = 3;
				else p->type = 10;  /* "IM" */
				break;
			    case 1: 
				if (p->type == 3) p->param3 = atof (unite);
				else p->param1 = atoi (unite);
				break;
			    case 2:
				if (p->type == 3) p->param4 = atof (unite);
				else p->param2 = atoi (unite);
				break;
			    case 3: p->param5 = atof (unite);  break;
			}
			index++;
			break;
		    }
		    case 1240: case 1241: case 1242:{
			struct paddi *p;
			if (index==0){
			    p = (struct paddi *)malloc(sizeof(*p));
			    com->param = (char *)p;
			}
			else p = (struct paddi *)com->param;
			switch (index){
			    case 0: p->ligne = (int)atoi (unite);  break;
			    case 1: p->colonne = (int)atoi (unite);  break;
			    case 2: 
				if (strcmp(unite, "MOY") == 0){
				    p->valeur = 0;
				    p->flag_moy = TRUE;
				}
				else{
				    p->valeur = (float)atof (unite);  
				    p->flag_moy = FALSE;
				}
				break;
			}
			index++;
			break;
		    }
		    case 1250: case 1251: {
			struct noise *p;
			if (index==0){
			    p = (struct noise *)malloc(sizeof(*p));
			    com->param = (char *)p;
			}
			else p = (struct noise *)com->param;
			switch (index){
			    case 0: p->esp = (double)atof (unite);  break;
			    case 1: p->var = (double)atof (unite);  break;
			}
			index++;
			break;
		    }
		    case 632: case 635: /* deux arguments */
		    case 630: case 631: case 633: case 634:
		    case 636: case 637: case 640: case 641: case 642:
		    case 650: case 651: case 652: case 653: case 654:
		    case 680: case 681: case 682: case 690: case 691: 
		    case 692: case 693: case 694:{
			struct morphobin *p;
			if (index==0){
			    p = (struct morphobin *)malloc(sizeof(*p));
			    com->param = (char *)p;
			}
			else p = (struct morphobin *)com->param;
			switch (index){
			    case 0: p->taille = (int)atoi (unite);  break;
			    case 1: p->angle = (int)atoi (unite);  break;
			}
			index++;
			break;
		    }
		    case 987: {
			struct mati_s *p;
			if (index==0){
			    p = (struct mati_s *)malloc(sizeof(*p));
			    com->param = (char *)p;
			}
			else p = (struct mati_s *)com->param;
			p->Mat[index] = atof (unite);
			index++;
			break;
		    }
		    case 990: case 994: {
			int *p;
			if (index==0){
			    p = (int *)malloc(sizeof(*p));
			    com->param = (char *)p;
			}
			else p = (int *)com->param;
			*p = atoi (unite);
			index++;
			break;
		    }
		    case 3010: {
			struct count_s *p;
			if (index==0){
			    p = (struct count_s *)malloc(sizeof(*p));
			    com->param = (char *)p;
			}
			else p = (struct count_s *)com->param;
			switch (index){
			    case 0: p->SMin = atoi (unite);  break;
			    case 1: p->XEt = atoi (unite);  break;
			    case 2: p->YEt = atoi (unite);  break;
			    case 3: p->SEt = atoi (unite);  break;
			    case 4: strcpy(p->FN_Res,unite);  break;
			}
			index++;
			break;
		    }
		    default : ;			
		}
		break;		
	}
	write_macro (" ");
	unite = strtok (NULL, " ");
    }
    write_macro ("\n");
}

/*****************************************************************************/

faire_ligne(com)
    struct commande *com;
{
    char *line;
    int i;

    line = (char *)malloc(80);
    sprintf (buf, "%s ", com->nom);
    if (com->from[0] != -1) {
	strcat (buf, sprintf (line, "FROM ")); 
	i = 0;
	do {
	    strcat (buf, sprintf (line, "%d ", com->from[i])); 
	    i++;
	} while ((com->from[i] != -1) && (i < MAX_FROMTO));
    }
    if (com->to[0] != -1) {
	strcat (buf, sprintf (line, "TO ")); 
	i = 0;
	do {
	    strcat (buf, sprintf (line, "%d ", com->to[i])); 
	    i++;
	} while ((com->to[i] != -1) && (i < MAX_FROMTO));
    }
    switch (com->code){
	case -1: case 1: case 2: case 3: case 6:
	case 130: case 131: case 132: case 133: case 134: case 135:
	case 988: case 993: {
	    struct fname *p;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (struct fname *)com->param;
	    strcat (buf, sprintf (line, "%s\n", p->filename));
	    break;
	}
	case 4: case 5:{
	    struct lecture_lts *p;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (struct lecture_lts *)com->param;
	    strcat (buf, sprintf (line, "%s %d %d %d %d %d\n", p->filename,
		   p->header,p->nlignes,p->nbytes,p->nvaleur,p->bytes_sautes));
	    break;
	}
	case 20: case 100: case 101: case 102: case 142: case 145:{
	    int *p;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (int *)com->param;
	    strcat (buf, sprintf (line, "%d\n", *p));
	    break;
	}
	case 21: case 22: case 23: case 24: case 25:{
    	    struct convert *p;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (struct convert *)com->param;
	    if (p->flag_mind) strcat (buf, sprintf (line, "MIN "));
	    else strcat (buf, sprintf (line, "%f ", p->mind));
	    if (p->flag_maxd) strcat (buf, sprintf (line, "MAX "));
	    else strcat (buf, sprintf (line, "%f ", p->maxd));
	    if (p->flag_mina) strcat (buf, sprintf (line, "MIN "));
	    else strcat (buf, sprintf (line, "%f ", p->mina));
	    if (p->flag_maxa) strcat (buf, sprintf (line, "MAX\n"));
	    else strcat (buf, sprintf (line, "%f\n", p->maxa));
	    break;
	}
	case 181:{
	    struct filmed *p;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (struct filmed *)com->param;
	    strcat (buf, sprintf (line, "%d %d\n", p->ncol,
		   p->nlin));
	    break;
	}
	case 182:{
	    struct pertile *p;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (struct pertile *)com->param;
	    strcat (buf, sprintf (line, "%f\n", p->alpha));
	    break;
	}
	case 183: case 184: case 34:{ 
	    struct rayon_puissan *p;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (struct rayon_puissan *)com->param;
	    strcat (buf, sprintf (line, "%f\n", p->r_frequency));
	    break;
	}
	case 186: { 
	    struct gaussian_p *p;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (struct gaussian_p *)com->param;
	    strcat (buf, sprintf (line, " %d %f\n", p->mint, p->en_mint));
	    break;
	}
	case 1252: { 
	    struct rayon_puissan *p;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (struct rayon_puissan *)com->param;
	    strcat (buf, sprintf (line, " %d\n", p->n_point));
	    break;
	}
	case 56:{
	    struct pertile *p;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (struct pertile *)com->param;
	    strcat (buf, sprintf (line, "%f\n", p->ptiledata));
	    break;
	}
	case 57:{
	    struct pertile *p;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (struct pertile *)com->param;
	    strcat (buf, sprintf (line, "%d\n", p->n_block));
	    break;
	}
	case 185:{
	    struct convol *p;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (struct convol *)com->param;
	    strcat (buf, sprintf (line, "%d %d\n", p->colonne, p->ligne));
	    break;
	}
	case 30:{
	    struct description_vecteur *p;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (struct description_vecteur *)com->param;
	    strcat (buf, sprintf (line, "%d %d %d\n", 
		    p->b_min, p->b_max, p->ncase));
	    break;
	}
	case 31:{
	    struct histogr *p;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (struct histogr *)
		((struct description_vecteur *)com->param)->prive;
	    strcat (buf, sprintf (line, "%d %d\n", 
		    p->haut_barre, p->larg_barre));
	    break;
	}
	case 32:{
	    struct histogr *p;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (struct histogr *)
		((struct description_vecteur *)com->param)->prive;
	    strcat (buf, sprintf (line, "%d %d %s\n", 
		    p->haut_barre, p->larg_barre, p->fileps->filename));
	    break;
	}
	case 33:{
	    struct rayon_puissan *p;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (struct rayon_puissan *)com->param;
	    strcat (buf, sprintf (line, "%f\n", p->p_energy));
	    break;
	}
	case 44: case 45: case 46: case 47: case 49: case 985: {
	    struct cte_cmplx *p;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (struct cte_cmplx *)com->param;
	    if ((com->code == 49) || (com->code == 985))
		strcat (buf, sprintf (line, "%f %f\n", p->reel, p->im));
	    else
		strcat (buf, sprintf (line, "%f\n", p->reel));
	    break;
	}
	case 60:  case 62:  case 64:{
	    struct convol *p;
	    float *m;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (struct convol *)com->param;
	    strcat (buf, sprintf (line, "%d %d %f",
		    p->ligne, p->colonne, p->factmult));
	    m = p->masque;
	    bufsuite = (char *)malloc(p->ligne * p->colonne * 10);
	    strcpy (bufsuite, "");
	    for (i=0; i<p->ligne*p->colonne; i++){
		strcat (bufsuite, sprintf (line, " %f", *m)); 	    
		m++;
	    }
	    strcat (bufsuite, "\n");
	    break;
	}
	case 110: case 111: case 112: case 113:{
	    struct affin *p;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (struct affin *)com->param;
	    switch (com->code){
	    case 110:
		strcat (buf, sprintf (line, "%f\n", p->c1)); break;
	    case 111: case 112:
		strcat (buf, sprintf (line, "%d %d\n",
			(int)p->c1, (int)p->c2));
		break;
	    case 113:
		strcat (buf, sprintf (line, "%f %f\n", p->c1, p->c2)); break;
	    } 
	    break;
	}
	case 117: {
	    struct cut_s *p;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (struct cut_s *)com->param;
	    strcat (buf, sprintf (line, "%d %d %d %d\n",
			(int)p->XMin, (int)p->YMin,
			(int)p->XMax, (int)p->YMax));
	    break;
	}
	case 141: case 144:{
	    struct reg_grow *p;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (struct reg_grow *)com->param;
	    while (p != NULL){
		strcat (buf, sprintf (line, " %d %f", p->choix, p->toler));
		p = p->next_rg;
	    }
	    strcat (buf, sprintf (line, "\n"));
	    break;
	}
	case 160: case 161: case 162: case 163: {
	    struct element *p;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (struct element *)com->param;
	    switch (p->type){
		case 0: strcat(buf, sprintf(line,"SP %d\n", p->param1));
			break;
		case 1: strcat(buf, sprintf(line,"CO %d %d\n",
				p->param1, p->param2)); 
			break;
		case 2: strcat(buf, sprintf(line,"CY %d %d\n",
				p->param1, p->param2)); 
			break;
		case 3: strcat(buf, sprintf(line,"GA %f %f %f\n",
				p->param3, p->param4, p->param5)); 
			break;
		case 10:strcat(buf, sprintf(line,"IM %d\n", p->param1)); 
			break;
	    }
	    break;
	}
	case 987: {
	    struct mati_s *p;
	    int N;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (struct mati_s *)com->param;
	    for (N = 0 ; N < 50 ; N++)
	    {
		if (p->Mat[N] == -1.0)
		    break;
		strcat (buf, sprintf (line, "%f ", p->Mat[N]));
	    }
	    strcat(buf,"\n");
	    break;
	}
	case 990: case 994: {
	    int *p;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (int *)com->param;
	    strcat (buf, sprintf (line, "%d\n", *p));
	    break;
	}
	case 1240: case 1241: case 1242:{
	    struct paddi *p;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (struct paddi *)com->param;
	    if (com->code == 1240)
		if (p->flag_moy)
		    strcat (buf, sprintf (line, "%d %d MOY\n",
			    p->ligne, p->colonne));
		else
		    strcat (buf, sprintf (line, "%d %d %f\n",
			    p->ligne, p->colonne, p->valeur));
	    else
		strcat (buf, sprintf (line, "%d %d\n",
			p->ligne, p->colonne));
	    break;
	}
	case 1250: case 1251:{
	    struct noise *p;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (struct noise *)com->param;
	    strcat (buf, sprintf (line, "%f %f\n", p->esp, p->var));
	    break;
	}
	case 632: case 635: /* deux arguments */
	case 630: case 631: case 633: case 634:
	case 636: case 637: case 640: case 641: case 642:
	case 650: case 651: case 652: case 653: case 654:
	case 680: case 681: case 682: case 690: case 691: 
	case 692: case 693: case 694:{
	    struct morphobin *p;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (struct morphobin *)com->param;
	    if (com->code == 632 || com->code == 635)
		strcat (buf, sprintf (line, "%d %d\n", p->taille, p->angle));
	    else
		strcat (buf, sprintf (line, "%d\n", p->taille));
	    break;
	}
	case 3010: {
	    struct count_s *p;
	    strcat (buf, sprintf (line, "WITH "));
	    p = (struct count_s *)com->param;
	    strcat (buf, sprintf (line, "%d %d %d %d %s\n",
			(int)p->SMin, (int)p->XEt, (int)p->YEt,
			(int)p->SEt, (int)p->FN_Res));
	    break;
	}
	default: strcat (buf, sprintf (line, "\n"));
    }
    free(line);
}

/*****************************************************************************/

static Panel_setting lire_filemacro (item, event)
    Panel_item item;
    Event *event;

{   
    FILE *fmacro;
    struct commande *com;
    char *buf2;
    int longu;

    if (event_id(event) == CTRLC) {
        /* demande d'interruption de l'interaction par l'utilisateur */
	panel_set (item, PANEL_SHOW_ITEM, FALSE, 0);
	window_set (panel_macro, PANEL_CARET_ITEM, no_macro, 0);
	if (flag_file == LIRE)
	    panel_accept_preview (bouton_lire, event);
	else if (flag_file == ECRIRE) 
	    panel_accept_preview (bouton_sauver, event);
	flag_file = LIBRE;
        return;
    }
    strcpy (filename, (char *) panel_get (item, PANEL_VALUE));
    if (flag_file == LIRE){
	sprintf (buf, mastertabs[170], no, filename);
	write_master(buf);
	macro_cour = NULL;
	flag_file = LIBRE;
	panel_set (item, PANEL_SHOW_ITEM, FALSE, 0);
	window_set (panel_macro, PANEL_CARET_ITEM, no_macro, 0);
	if ((fmacro = fopen (filename, "r")) != NULL){
	    longu = 80;
	    buf2 = (char *)malloc(80);
	    strcpy(buf2, "");
	    textsw_reset (texte_macro, 0, 0);
	    while (fgets (buf, 80, fmacro) != NULL){
		while (*(buf+strlen(buf)-1) != '\n'){
		    longu+=80;
		    buf = (char *)realloc(buf,longu);
		    fgets (buf2, 80, fmacro);
		    strcat (buf, buf2);
		}
		*(buf+strlen(buf)-1) = '\0';
		faire_com(buf);
	    }
	    free(buf2);
	    dir_desc_macro[no].debut = macro_cour;
	}
	fclose (fmacro);
	panel_accept_preview (bouton_lire, event);
	return;
    }
    if (flag_file == ECRIRE){
	sprintf (buf, mastertabs[171], no, filename);
	write_master(buf);
	flag_file = LIBRE;
	panel_set (item, PANEL_SHOW_ITEM, FALSE, 0);
	window_set (panel_macro, PANEL_CARET_ITEM, no_macro, 0);
	com = dir_desc_macro[no].debut;
	fmacro = fopen (filename, "w");
	while (com != NULL){
	    faire_ligne(com);
	    fwrite (buf, strlen(buf), 1, fmacro);
	    if (bufsuite!=NULL){
		fwrite (bufsuite, strlen(bufsuite), 1, fmacro);
		free (bufsuite);
		bufsuite = NULL;		
	    }
	    com = com->next;
	}
	fclose (fmacro);
	panel_accept_preview (bouton_sauver, event);
	return;
    }
}

/*****************************************************************************/

bouton_menu (item,event)
    Panel_item item;
    Event *event;
{
    extern  Menu    maff, mconvert, moparithm, mtransf, mhisto;
    extern  Menu    mentree, mconvol, mgeom, mcorrel, mconvcorrel;
    extern  Menu    mbases, mpadding, mbruit, mseg, mgraph, mopr;
    extern  Menu    mlibere, mlaser;
    extern  Menu    mmorphniv, mmorphbin, mraster, mfreq_fltr, mtraite;
    extern  Menu    mmb1, mmb2, mmb3, mmb4, mmb5, mmb6, mmb7, mmb8, mmb9;
    extern  Menu    mgel1dtool, mgel1_1, mgel1_2, mgel1_3, mgel1_4;

    int mode;
    struct commande *com;
    
    if (flag_file == LIBRE){
    no = atoi((char *) panel_get (no_macro, PANEL_VALUE));
    if(item==bouton_creer && event_id(event)==MS_LEFT && event_is_down(event)){
	if (flag_creer == FALSE){
	    panel_set (bouton_exec, PANEL_SHOW_ITEM, FALSE, 0);
	    panel_set (bouton_lire, PANEL_SHOW_ITEM, FALSE, 0);
	    panel_set (bouton_sauver, PANEL_SHOW_ITEM, FALSE, 0);
	    panel_set (bouton_quit, PANEL_SHOW_ITEM, FALSE, 0);
	    panel_set (bouton_afficher, PANEL_SHOW_ITEM, FALSE, 0);
	    panel_set (item, PANEL_LABEL_IMAGE,
		       panel_button_image (panel_macro,paneltabs[280],10,0),0);
	    flag_creer = TRUE;
	    sprintf (buf,mastertabs[180] );
	    write_master(buf);
	    textsw_reset (texte_macro, 0, 0);
	}
	else{
	    panel_set (bouton_exec, PANEL_SHOW_ITEM, TRUE, 0);
	    panel_set (bouton_lire, PANEL_SHOW_ITEM, TRUE, 0);
	    panel_set (bouton_sauver, PANEL_SHOW_ITEM, TRUE, 0);
	    panel_set (bouton_quit, PANEL_SHOW_ITEM, TRUE, 0);
	    panel_set (bouton_afficher, PANEL_SHOW_ITEM, TRUE, 0);
	    panel_set (item, PANEL_LABEL_IMAGE, 
		       panel_button_image (panel_macro, paneltabs[281],10,0),0);
	    flag_creer = FALSE;
	    sprintf (buf, mastertabs[172],  no);
	    write_master(buf);
	    if (dir_desc_macro[no].debut==NULL) free(dir_desc_macro[no].debut);
	    dir_desc_macro[no].debut = macro_cour;
	    macro_cour = NULL; 
	}
    }
    else if (item == bouton_exec){
	if (event_id(event) == MS_RIGHT && event_is_down(event)){
	    panel_begin_preview (item, event);
	    mode = (int)menu_show(mexec, panel_macro, event, 0);
	    switch (mode){
	    case 0: 
		flag_exec = OFF;
		break;
	    case 1:
		sprintf (buf,mastertabs[173], no);
		write_master(buf);
		flag_exec = AUTO;
		break;	
	    case 2:
		sprintf (buf, mastertabs[174], no);
		write_master(buf);
		flag_exec = PARAM_AUTO;
		break;	
	    case 3:
		sprintf(buf,mastertabs[175],no);
		write_master(buf);
		flag_exec = FROMTO_AUTO;
		break;	
	    case 4:
		sprintf (buf, mastertabs[176], no);
		write_master(buf);
		flag_exec = MANUEL;
		break;	
	    }
	    if (mode != 0){
		macro_cour = dir_desc_macro[no].debut;
		while (macro_cour != NULL){
		    switch (macro_cour->code){
                    case -1:/* I_OLIMPST */
			proc_lecture_standard (mentree,
				    menu_get(mentree,MENU_NTH_ITEM,3));
			break;
		    case 1  : /* I_OLIMSTA */
			proc_lecture_standard (mentree,
				    menu_get(mentree,MENU_NTH_ITEM,2));
			break;
		    case 2  : /* I_OLIMM8B */
			proc_mel8();
			break;
		    case 3  : /* I_OLIMM12B */
			proc_mel12();
			break;
		    case 4  : /* I_OLIMLTS */
			proc_lts();
			break;
		    case 5  : /* I_OLIMRGB */
			proc_rgb();
			break;
		    case 6  : /* I_OLIMSRA */
			proc_read_rasterfile();
			break;
		    case 10 : /* DISSIMGLI */
			proc_gris_lin();
			break;
		    case 11 : /* DISSIMGLO */
			proc_gris_log();
			break;
		    case 12 : /* DISSIMRGB */
			proc_couleur_rgb(maff,menu_get(maff,MENU_NTH_ITEM,6));
			break;
		    case 13 : /* DISSIMRFS */
			proc_couleur_rgb(maff,menu_get(maff,MENU_NTH_ITEM,7));
			break;
		    case 14 : /* DISSIMTHR */
			proc_seuil();
			break;
		    case 15 : /* DISSIMRFS */
			proc_report_erreur();
			break;
		    case 20 : /* AUXCONBIN */
			proc_seuillage();
			break;
		    case 21 : /* AUXCONBYT */
			proc_convert (mconvert,
			    menu_get(mconvert,MENU_NTH_ITEM,3));
			break;
		    case 22 : /* AUXCONSHO */
			proc_convert (mconvert,
			    menu_get(mconvert,MENU_NTH_ITEM,4));
			break;
		    case 23 : /* AUXCONINT */
			proc_convert (mconvert,
			    menu_get(mconvert,MENU_NTH_ITEM,5));
			break;
		    case 24 : /* AUXCONFLO */
			proc_convert (mconvert,
			    menu_get(mconvert,MENU_NTH_ITEM,6));
			break;
		    case 25 : /* AUXCONCOM */
			proc_convert (mconvert,
			    menu_get(mconvert,MENU_NTH_ITEM,7));
			break;
		    case 26 : /* AUXCONCPO */
			proc_convert (mconvert,
			    menu_get(mconvert,MENU_NTH_ITEM,9));
			break;
		    case 27 : /* AUXCONPCA */
			proc_convert (mconvert,
			    menu_get(mconvert,MENU_NTH_ITEM,10));
			break;
		    case 30 : /* MEAHISCAL */
			proc_histo (mhisto,
			    menu_get(mhisto,MENU_NTH_ITEM,2));
			break;
		    case 31 : /* MEAHISSHO */
			proc_histo(mhisto,
			    menu_get(mhisto,MENU_NTH_ITEM,3));
			break;
		    case 32 : /* MEAHISPRI */
			proc_histo(mhisto,
			    menu_get(mhisto,MENU_NTH_ITEM,4));
			break;
		    case 33 : /* MEAPOWCPO */
			proc_puissance();
			break;
		    case 34 : /* MEAPOWCFR */
			proc_cut_frequncy();
			break;
		    case 40 : /* AUXAOP2PLADD */
			proc_op_arithm (moparithm,
			    menu_get(moparithm,MENU_NTH_ITEM,2));
			break;
		    case 41 : /* AUXAOP2PLSUBP */
			proc_op_arithm (moparithm,
			    menu_get(moparithm,MENU_NTH_ITEM,3));
			break;
		    case 42 : /* AUXAOP2PLMUL */
			proc_op_arithm (moparithm,
			    menu_get(moparithm,MENU_NTH_ITEM,4));
			break;
		    case 43 : /* AUXAOP2PLDIV */
			proc_op_arithm (moparithm,
			    menu_get(moparithm,MENU_NTH_ITEM,5));
			break;
		    case 44 : /* AUXAOP1PCADD  */
			proc_op_arithm (moparithm,
			    menu_get(moparithm,MENU_NTH_ITEM,7));
			break;
		    case 45 : /* AUXAOP1PCSUB */
			proc_op_arithm (moparithm,
			    menu_get(moparithm,MENU_NTH_ITEM,8));
			break;
		    case 46 : /* AUXAOP1PCMUL */
			proc_op_arithm (moparithm,
			    menu_get(moparithm,MENU_NTH_ITEM,9));
			break;
		    case 47 : /* AUXAOP1PCDIV */
			proc_op_arithm (moparithm,
			    menu_get(moparithm,MENU_NTH_ITEM,10));
			break;
		    case 48 : /* AUXAOP4PLMUL */
			proc_op_arithm (moparithm,
			    menu_get(moparithm,MENU_NTH_ITEM,12));
			break;
		    case 49 : /* AUXAOP2PCMUL */
			proc_op_arithm (moparithm,
			    menu_get(moparithm,MENU_NTH_ITEM,14));
			break;
		    case 50 : /* PROTRAF2D */
			proc_fourier (mtransf,
			    menu_get(mtransf,MENU_NTH_ITEM,2));
			break;
		    case 51 : /* PROTRAIF2 */
			proc_fourier(mtransf,
			    menu_get(mtransf,MENU_NTH_ITEM,3));
			break;
		    case 52 : /* PROTRAOF2 */
			proc_fourier(mtransf,
			    menu_get(mtransf,MENU_NTH_ITEM,4));
			break;
		    case 53 : /* PROTRAOIF */
			proc_fourier(mtransf,
			    menu_get(mtransf,MENU_NTH_ITEM,5));
			break;
		    case 54 : /* PROTRARF2 */
			proc_fourier(mtransf,
			    menu_get(mtransf,MENU_NTH_ITEM,7));
			break;
		    case 55 : /* PROTRAROF */
			proc_fourier(mtransf,
			    menu_get(mtransf,MENU_NTH_ITEM,8));
			break;
		    case 56 : /* PROATHLPH */
			proc_ptile_seuil();
			break;
		    case 57 : /* PROATHDTH */
			proc_dyna_seuil();
			break;
		    case 60 : /* PROCONCONWMA */
			proc_convol(mconvol,
			    menu_get(mconvol,MENU_NTH_ITEM,2));
			break;
		    case 61 : /* PROCONCONWIM */
			proc_convol(mconvol,
			    menu_get(mconvol,MENU_NTH_ITEM,3));
			break;
		    case 62 : /* PROCONCORWMA */
			proc_convol(mcorrel,
			    menu_get(mcorrel,MENU_NTH_ITEM,2));
			break;
		    case 63 : /* PROCONCORWIM */
			proc_convol(mcorrel,
			    menu_get(mcorrel,MENU_NTH_ITEM,3));
			break;
		    case 64 : /* PROCONCMA */
			proc_convol(mconvcorrel,
			    menu_get(mconvol,MENU_NTH_ITEM,2));
			break;
		    case 99 : /* PROTHR */
			proc_threshold(mtraite, 
			    menu_get(mtraite,MENU_NTH_ITEM,2));
			break;
		    case 100 : /* PROEDGSOB */
			proc_sobel();
			break;
		    case 101 : /* PROEDGLAP */
			proc_laplace();
			break;
		    case 102 : /* PROEDGROB */
			proc_roberts();
			break;
		    case 103 : /* PROEDGFCH */
			proc_frei_chen();
			break;
		    case 104 : /* PROEDGMVA */
			proc_mero_vassy();
			break;
		    case 105 : /* PROEDGZCR */
			proc_zero_cross();
			break;
		    case 106 : /* PROEDGRRI */
			proc_ridge_ride();
			break;
		    case 140 : /* PROREGGRAGCO */
			proc_graph(mgraph, menu_get(mgraph,MENU_NTH_ITEM,1));
			break;
		    case 141 : /* PROREGRGR */
/* PROREGRGR n'existe plus... 
			proc_seg(mseg, menu_get(mseg,MENU_NTH_ITEM,1));
*/
			break;
		    case 142 : /* PROREGOPRGRA */
			proc_opr(mopr, menu_get(mopr,MENU_NTH_ITEM,1));
			break;
		    case 143 : /* PROREGGRAGIM */
			proc_graph(mgraph, menu_get(mgraph,MENU_NTH_ITEM,2));
			break;
		    case 144 : /* PROREGGRAREX */
			proc_graph(mgraph, menu_get(mgraph,MENU_NTH_ITEM,3));
			break;
		    case 145 : /* PROREGGRAESR */
			proc_graph(mgraph, menu_get(mgraph,MENU_NTH_ITEM,4));
			break;
		    case 110 : /* AUXGOPROT */
			proc_affin(mgeom, menu_get(mgeom,MENU_NTH_ITEM,2));
			break;
		    case 111 : /* AUXGOPTRA */
			proc_affin(mgeom, menu_get(mgeom,MENU_NTH_ITEM,3));
			break;
		    case 112 : /* AUXGOPSCS */
			proc_affin(mgeom, menu_get(mgeom,MENU_NTH_ITEM,4));
			break;
		    case 113 : /* AUXGOPSCF */
			proc_affin(mgeom, menu_get(mgeom,MENU_NTH_ITEM,5));
			break;
		    case 114 : /* AUXGOPTRP */
			proc_transpose();
			break;
		    case 115 : /* AUXGOPSYX */
			proc_sym_x();
			break;
		    case 116 : /* AUXGOPSYY */
			proc_sym_y();
			break;
		    case 117 : /* AUXMODCAP */
			proc_cut();
			break;
		    case 120 : /* MEAIST */
			proc_calc_stat();
			break;
		    case 1210 : /* AUXFMEAPL */
			proc_libere(mlibere,menu_get(mlibere,MENU_NTH_ITEM,2));
			break;
		    case 1211 : /* AUXFMESPL */
			proc_libere(mlibere,menu_get(mlibere,MENU_NTH_ITEM,3));
			break;
		    case 1212 : /* AUXFMEAVE */
			proc_libere(mlibere,menu_get(mlibere,MENU_NTH_ITEM,4));
			break;
		    case 1213 : /* AUXFMESVE */
			proc_libere(mlibere,menu_get(mlibere,MENU_NTH_ITEM,5));
			break;
		    case 122 : /* AUXCOP */
			proc_copie();
			break;
		    case 123 : /* AUXCONRGR */
			proc_rgb_nivgris();
			break;
		    case 1240 : /* AUXMODPADCON */
			proc_padding (mpadding,
					   menu_get(mpadding,MENU_NTH_ITEM,2));
			break;
		    case 1241 : /* AUXMODPADPRO */
			proc_padding (mpadding,
					   menu_get(mpadding,MENU_NTH_ITEM,3));
			break;
		    case 1242 : /* AUXMODPADPER */
			proc_padding (mpadding,
					   menu_get(mpadding,MENU_NTH_ITEM,4));
			break;
		    case 1250 : /* AUXMODNOIUNI */
			proc_bruit (mbruit,
					   menu_get(mbruit,MENU_NTH_ITEM,2));
			break;
		    case 1251 : /* AUXMODNOIGAU */
			proc_bruit (mbruit,
					   menu_get(mbruit,MENU_NTH_ITEM,3));
			break;
		    case 130 : /* I_OSIMSPL */
			proc_sauve1();
			break;
		    case 131 : /* I_OSIMCCA */
			proc_sauve2_cart();
			break;
		    case 132 : /* I_OSIMCPO */
			proc_sauve2_pol();
			break;
		    case 133 : /* I_OSIMRGB */
			proc_sauve3();
			break;
		    case 134 : /* I_OPOSNOR */
			proc_laser(mlaser,
				    menu_get(mlaser,MENU_NTH_ITEM,2));
			break;
		    case 135 : /* I_OPOSMAX */
			proc_laser(mlaser,
				    menu_get(mlaser,MENU_NTH_ITEM,3));
			break;
		    case 136 : /* I_OSIMSRA */
			proc_write_rasterfile();
			break;
		    case 160 : /* PROGSMERO */
			proc_choix_elem(mmorphniv,
				    menu_get(mmorphniv,MENU_NTH_ITEM,1));
			break;
		    case 161 : /* PROGSMDIL */
			proc_choix_elem(mmorphniv,
				    menu_get(mmorphniv,MENU_NTH_ITEM,2));
			break;
		    case 162 : /* PROGSMOPE */
			proc_choix_elem(mmorphniv,
				    menu_get(mmorphniv,MENU_NTH_ITEM,3));
			break;
		    case 163 : /* PROGSMCLO */
			proc_choix_elem(mmorphniv,
				    menu_get(mmorphniv,MENU_NTH_ITEM,4));
			break;
		    case 180 :/* PREHEQ */
			proc_egal_histo();
			break;
		    case 181 :/* PREENHMFI */
			proc_median();
			break;
		    case 182 :/* PREENHHPF */
			proc_high_pass();
			break;
		    case 183 :/* PREENHFFDHAM */
			proc_hamming(mfreq_fltr,menu_get(mfreq_fltr,MENU_NTH_ITEM,2));
			break;
		    case 184 :/* PREENHFFDHAN */
			proc_hamming(mfreq_fltr,menu_get(mfreq_fltr,MENU_NTH_ITEM,3));
			break;
		    case 185 :/* PRECBA */
			proc_linear_filter();
			break;
		    case 186 :/* PREENHFFDGAU */
			proc_gaussian();
			break;
		    case 1252 :/* AUXMOD1OI */
			proc_ordr1_interp();
			break;
		    case 550: /* AUXLOPAND */
			proc_gen(mraster,menu_get(mraster,MENU_NTH_ITEM,1));
			break;
		    case 551: /* AUXLOPAWM */
			proc_gen(mraster,menu_get(mraster,MENU_NTH_ITEM,2));
			break;
		    case 552: /* AUXLOPOR */
			proc_gen(mraster,menu_get(mraster,MENU_NTH_ITEM,3));
			break;
		    case 553: /* AUXLOPXOR */
			proc_gen(mraster,menu_get(mraster,MENU_NTH_ITEM,4));
			break;
		    case 554: /* AUXLOPNOT */
			proc_gen(mraster,menu_get(mraster,MENU_NTH_ITEM,5));
			break;
		    case 600: /* PROBMO */
			proc_entree_morphbin();
			break;
		    case 601: /* PROBMODIS */
			proc_morphbin(mmorphbin,
				    menu_get(mmorphbin,MENU_NTH_ITEM,1));
			break;
		    case 620: /* PROBMOLTRCOM */
			proc_morphbin(mmb2,menu_get(mmb2,MENU_NTH_ITEM,1));
			break;
		    case 621: /* PROBMOLTRINT */
			proc_morphbin(mmb2,menu_get(mmb2,MENU_NTH_ITEM,2));
			break;
		    case 622: /* PROBMOLTRUNI */
			proc_morphbin(mmb2,menu_get(mmb2,MENU_NTH_ITEM,3));
			break;
		    case 623: /* PROBMOLTRSDI */
			proc_morphbin(mmb2,menu_get(mmb2,MENU_NTH_ITEM,4));
			break;
		    case 624: /* PROBMOLTRDIF */
			proc_morphbin(mmb2,menu_get(mmb2,MENU_NTH_ITEM,5));
			break;
		    case 630: /* PROBMOSTRERO */
			proc_morphbin(mmb3,menu_get(mmb3,MENU_NTH_ITEM,1));
			break;
		    case 631: /* PROBMOSTRCER */
			proc_morphbin(mmb3,menu_get(mmb3,MENU_NTH_ITEM,2));
			break;
		    case 632: /* PROBMOSTRLER */
			proc_morphbin(mmb3,menu_get(mmb3,MENU_NTH_ITEM,3));
			break;
		    case 633: /* PROBMOSTRDIL */
			proc_morphbin(mmb3,menu_get(mmb3,MENU_NTH_ITEM,4));
			break;
		    case 634: /* PROBMOSTRCDI */
			proc_morphbin(mmb3,menu_get(mmb3,MENU_NTH_ITEM,5));
			break;
		    case 635: /* PROBMOSTRLDI */
			proc_morphbin(mmb3,menu_get(mmb3,MENU_NTH_ITEM,6));
			break;
		    case 636: /* PROBMOSTROPE */
			proc_morphbin(mmb3,menu_get(mmb3,MENU_NTH_ITEM,7));
			break;
		    case 637: /* PROBMOSTRCLO */
			proc_morphbin(mmb3,menu_get(mmb3,MENU_NTH_ITEM,8));
			break;
		    case 640: /* PROBMOTHIHOL */
			proc_morphbin(mmb4,menu_get(mmb4,MENU_NTH_ITEM,1));
			break;
		    case 641: /* PROBMOTHIHOD */
			proc_morphbin(mmb4,menu_get(mmb4,MENU_NTH_ITEM,2));
			break;
		    case 642: /* PROBMOTHIPRU */
			proc_morphbin(mmb4,menu_get(mmb4,MENU_NTH_ITEM,3));
			break;
		    case 643: /* PROBMOTHIPRU */
			proc_morphbin(mmb4,menu_get(mmb4,MENU_NTH_ITEM,4));
			break;
		    case 650: /* PROBMOTHCIPM */
			proc_morphbin(mmb5,menu_get(mmb5,MENU_NTH_ITEM,1));
			break;
		    case 651: /* PROBMOTHCHOL */
			proc_morphbin(mmb5,menu_get(mmb5,MENU_NTH_ITEM,2));
			break;
		    case 652: /* PROBMOTHCHOD */
			proc_morphbin(mmb5,menu_get(mmb5,MENU_NTH_ITEM,3));
			break;
		    case 653: /* PROBMOTHCTCE */
			proc_morphbin(mmb5,menu_get(mmb5,MENU_NTH_ITEM,4));
			break;
		    case 654: /* PROBMOTHCTCC */
			proc_morphbin(mmb5,menu_get(mmb5,MENU_NTH_ITEM,5));
			break;
		    case 661: /* PROBMOHMTEPS */
			proc_morphbin(mmb6,menu_get(mmb6,MENU_NTH_ITEM,1));
			break;
		    case 662: /* PROBMOHMTIPI */
			proc_morphbin(mmb6,menu_get(mmb6,MENU_NTH_ITEM,2));
			break;
		    case 663: /* PROBMOHMTTPS */
			proc_morphbin(mmb6,menu_get(mmb6,MENU_NTH_ITEM,3));
			break;
		    case 670: /* PROBMOHLTBOU */
			proc_morphbin(mmb7,menu_get(mmb7,MENU_NTH_ITEM,1));
			break;
		    case 671: /* PROBMOHLTEBO */
			proc_morphbin(mmb7,menu_get(mmb7,MENU_NTH_ITEM,2));
			break;
		    case 672: /* PROBMOHLTFHO */
			proc_morphbin(mmb7,menu_get(mmb7,MENU_NTH_ITEM,3));
			break;
		    case 673: /* PROBMOHLTHSK */
			proc_morphbin(mmb7,menu_get(mmb7,MENU_NTH_ITEM,4));
			break;
		    case 674: /* PROBMOHLTHMA */
			proc_morphbin(mmb7,menu_get(mmb7,MENU_NTH_ITEM,5));
			break;
		    case 675: /* PROBMOHLTPCH */
			proc_morphbin(mmb7,menu_get(mmb7,MENU_NTH_ITEM,6));
			break;
		    case 676: /* PROBMOHLTSCH */
			proc_morphbin(mmb7,menu_get(mmb7,MENU_NTH_ITEM,7));
			break;
		    case 677: /* PROBMOHLTSZI */
			proc_morphbin(mmb7,menu_get(mmb7,MENU_NTH_ITEM,8));
			break;
		    case 680: /* PROBMOCTHHOL */
			proc_morphbin(mmb8,menu_get(mmb8,MENU_NTH_ITEM,1));
			break;
		    case 681: /* PROBMOCTHHOD */
			proc_morphbin(mmb8,menu_get(mmb8,MENU_NTH_ITEM,2));
			break;
		    case 682: /* PROBMOCTHPRU */
			proc_morphbin(mmb8,menu_get(mmb8,MENU_NTH_ITEM,3));
			break;
		    case 690: /* PROBMOCTCIPM */
			proc_morphbin(mmb9,menu_get(mmb9,MENU_NTH_ITEM,1));
			break;
		    case 691: /* PROBMOCTCHOL */
			proc_morphbin(mmb9,menu_get(mmb9,MENU_NTH_ITEM,2));
			break;
		    case 692: /* PROBMOCTCHOD */
			proc_morphbin(mmb9,menu_get(mmb9,MENU_NTH_ITEM,3));
			break;
		    case 693: /* PROBMOCTCTCE */
			proc_morphbin(mmb9,menu_get(mmb9,MENU_NTH_ITEM,4));
			break;
		    case 694: /* PROBMOCTCTCC */
			proc_morphbin(mmb9,menu_get(mmb9,MENU_NTH_ITEM,5));
			break;
		    case 699: /* PROBMOQUI */
			proc_sortie_morphbin();
			break;
		    case 950: /* GEL1D */
			proc_entree_gel1d();
			break;
		    case 960: /* GEL1CFP */
			proc_gel1d (mgel1_1,
			    menu_get(mgel1_1,MENU_NTH_ITEM,1));
			break;
		    case 961: /* GEL1AFP */
			proc_gel1d (mgel1_1,
			    menu_get(mgel1_1,MENU_NTH_ITEM,2));
			break;
		    case 970: /* GEL1CFE */
			proc_gel1d (mgel1_2,
			    menu_get(mgel1_2,MENU_NTH_ITEM,1));
			break;
		    case 971: /* GEL1AFE */
			proc_gel1d (mgel1_2,
			    menu_get(mgel1_2,MENU_NTH_ITEM,2));
			break;
		    case 980: /* GEL1CPR */
			proc_gel1d (mgel1_3,
			    menu_get(mgel1_3,MENU_NTH_ITEM,1));
			break;
		    case 981: /* GEL1AFID */
			proc_gel1d (mgel1_3,
			    menu_get(mgel1_3,MENU_NTH_ITEM,2));
			break;
/*		    case 982:*/ /* GEL1AFPR */
/*			proc_gel1d (mgel1_3,
			    menu_get(mgel1_3,MENU_NTH_ITEM,3));
			break; */
		    case 985: /* GEL1THRE */
			proc_find_max_gel (mgel1_4,
			    menu_get(mgel1_4,MENU_NTH_ITEM,6));
			break;
		    case 986: /* GEL1PIC */
			proc_find_max_gel (mgel1_4,
			    menu_get(mgel1_4,MENU_NTH_ITEM,1));
			break;
		    case 987: /* GEL1MAT */
			proc_find_max_gel (mgel1_4,
			    menu_get(mgel1_4,MENU_NTH_ITEM,5));
			break;
		    case 988: /* GEL1SPIC */
			proc_find_max_gel (mgel1_4,
			    menu_get(mgel1_4,MENU_NTH_ITEM,7));
			break;
		    case 990: /* GEL1PLAN */
			proc_gel1d (mgel1dtool,
			    menu_get(mgel1dtool,MENU_NTH_ITEM,1));
			break;
		    case 991: /* GEL1AFFI */
			proc_gel1d (mgel1dtool,
			    menu_get(mgel1dtool,MENU_NTH_ITEM,2));
			break;
		    case 992 : /* GEL1DSAV */
			write_gel1d_proc();
			break;
		    case 993 : /* GEL1DGET */
			read_gel1d_proc();
			break;
		    case 994: /* GEL1DLIS */
			proc_gel1d (mgel1dtool,
			    menu_get(mgel1dtool,MENU_NTH_ITEM,6));
			break;
		    case 999: /* GEL1DEXT */
			proc_sortie_gel1d();
			break;
		    case 3001: /* MEACREFREBC8 */
			proc_rc_f_8();
			break;
		    case 3002: /* MEACREFRECC8 */
			proc_rc_c_8();
			break;
		    case 3003: /* MEACREFREBC4 */
			proc_rc_f_4();
			break;
		    case 3004: /* MEACREFRECC4 */
			proc_rc_c_4();
			break;
		    case 3010: /* MEACRESCO */
			proc_write_N();
			break;
		    case 3020: /* PIXEDIT */
			proc_pixedit();
			break;
		    }
		    macro_cour = macro_cour->next;
		}
		sprintf (buf, mastertabs[177],no);
		write_master(buf);
		flag_exec = OFF;
	    }
	    panel_accept_preview (item, event);
	}
    }
    else if (item == bouton_lire){
	if (event_id(event) == MS_LEFT && event_is_down(event)){
	    panel_begin_preview (item, event);
	    panel_set (nom, PANEL_SHOW_ITEM, TRUE, 0);
	    flag_file = LIRE;
	}
    }
    else if (item == bouton_sauver){
	if (event_id(event) == MS_LEFT && event_is_down(event)){
	    panel_begin_preview (item, event);
	    panel_set (nom, PANEL_SHOW_ITEM, TRUE, 0);
	    flag_file = ECRIRE;
	}
    }
    else if (item == bouton_afficher){
	if (event_id(event) == MS_LEFT && event_is_down(event)){
	    panel_begin_preview (item, event);
	    textsw_reset (texte_macro, 0, 0);
	    sprintf (buf, mastertabs[178],
	    no);
	    write_master (buf);
	    com = dir_desc_macro[no].debut;
	    while (com != NULL) {
		faire_ligne(com);
		textsw_insert (texte_macro, buf, strlen(buf));
		if (bufsuite!=NULL){
		    textsw_insert (texte_macro, bufsuite, strlen(bufsuite));
		    free (bufsuite);
		    bufsuite = NULL;
		}		
		com = com->next;
	    }
	    panel_accept_preview (item, event);
	}	    	    
    }
    else if (item == bouton_quit){
	if (event_id(event) == MS_LEFT && event_is_down(event)){
	    panel_begin_preview (item, event);
	    if (Confirm("quit macro?") == 1){
		textsw_reset (texte_macro, 0, 0);
		flag_macro_win_open = FALSE;
		flag_in_macro = FALSE;
		window_destroy (frame_macro);
	    }
	    panel_accept_preview (item, event);
	}
    }
    }
}



void proc_sortie_macro(m , mop)
  Menu            m;
  Menu_generate   mop;
{
   if (Confirm("quit macro?") == 1){ 
	flag_macro_win_open = FALSE;
	flag_in_macro = FALSE;
	textsw_reset (texte_macro, 0, 0);
	window_destroy (frame_macro);
   }
}


init_macro_panel()
{
    extern	    Menu wait_curseur_proc();

    flag_creer = FALSE;
    macro_cour = NULL;
    flag_macro_win_open = TRUE;

    mexec = menu_create 
            (MENU_GEN_PROC, wait_curseur_proc,
	     MENU_STRINGS, "Automatique", "Parametres auto",
	     "Destination auto", "Manuel", 0, 0);
    frame_macro = window_create(NULL, FRAME, WIN_X, 0, WIN_Y, 0,
		       WIN_SHOW, TRUE, FRAME_NO_CONFIRM, TRUE,
                       FRAME_EMBOLDEN_LABEL, TRUE, 
                       FRAME_LABEL, "MacroTool",
                       WIN_X, 0, WIN_Y, 344, 0);

    panel_macro = window_create(frame_macro, PANEL, WIN_COLUMNS, 79, 
                       PANEL_LABEL_BOLD, TRUE, 0);
    no_macro = panel_create_item (panel_macro, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
                       PANEL_VALUE_DISPLAY_LENGTH, 40,
                       PANEL_VALUE_STORED_LENGTH, 40,
                       PANEL_LABEL_STRING, paneltabs[282],
		       PANEL_VALUE, "0",
                       PANEL_NOTIFY_LEVEL, PANEL_NONE,
                       0);
    bouton_creer = panel_create_item (panel_macro, PANEL_BUTTON,
	    PANEL_ITEM_X, 5, PANEL_ITEM_Y, 30,
	    PANEL_EVENT_PROC, bouton_menu,
	    PANEL_LABEL_IMAGE, 
	    panel_button_image (panel_macro,paneltabs[283], 
	    10,0),
	    0);
    bouton_exec = panel_create_item (panel_macro, PANEL_BUTTON,
	    PANEL_EVENT_PROC, bouton_menu,
	    PANEL_LABEL_IMAGE,
	    panel_button_image (panel_macro,paneltabs[284],
	    10,0),
	    0);
    bouton_lire = panel_create_item (panel_macro, PANEL_BUTTON,
	    PANEL_EVENT_PROC, bouton_menu,
	    PANEL_LABEL_IMAGE, 
	    panel_button_image (panel_macro,paneltabs[285],
	    10,0),
	    0);
    bouton_sauver = panel_create_item (panel_macro, PANEL_BUTTON,
	    PANEL_EVENT_PROC, bouton_menu,
	    PANEL_LABEL_IMAGE, 
	    panel_button_image (panel_macro,paneltabs[286],
	    10,0),
	    0);
    bouton_afficher = panel_create_item (panel_macro, PANEL_BUTTON,
	    PANEL_EVENT_PROC, bouton_menu,
	    PANEL_LABEL_IMAGE, 
	    panel_button_image(panel_macro,paneltabs[287],
	    10,0),
	    0);
    bouton_quit = panel_create_item (panel_macro, PANEL_BUTTON,
	    PANEL_EVENT_PROC, bouton_menu,
	    PANEL_LABEL_IMAGE, 
	    panel_button_image (panel_macro,"Quit",
	    10,0),
	    0);
    window_fit (bouton_creer);
    window_fit (bouton_exec);
    window_fit (bouton_lire);
    window_fit (bouton_sauver);
    window_fit (bouton_quit);
    nom = panel_create_item (panel_macro, PANEL_TEXT,
		       PANEL_ITEM_X, 5, PANEL_ITEM_Y, 60,
                       PANEL_SHOW_ITEM, FALSE,
                       PANEL_VALUE_DISPLAY_LENGTH, 40,
                       PANEL_VALUE_STORED_LENGTH, 40,
                       PANEL_LABEL_STRING, paneltabs[288],
		       PANEL_VALUE, "",
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_filemacro,
                       0);
    window_fit (nom);
    window_fit_height (panel_macro);

    texte_macro = window_create(frame_macro, TEXTSW,
	    TEXTSW_LINE_BREAK_ACTION, TEXTSW_WRAP_AT_CHAR,
	    TEXTSW_IGNORE_LIMIT, TEXTSW_INFINITY,
            WIN_BELOW, panel_macro,
	    TEXTSW_MENU, NULL,
	    WIN_X, 0,
            WIN_ROWS, 15,
	    0);

    window_fit_width (texte_macro);
    window_fit (frame_macro);

    framemacromenu = (Menu) window_get(frame_macro, WIN_MENU, 0);
    menu_set(framemacromenu, MENU_REMOVE, 8,
                             MENU_ACTION_ITEM, "quit*", proc_sortie_macro,
             0);
    window_set(frame_macro, WIN_MENU, framemacromenu,0);

    window_loop (frame_macro);
}

 void proc_entree_macro (mitem, mevent)
    Panel_item mitem;
    Event *mevent;


{
    if (flag_bother){
	hproc_macrotool();
	flag_in_macro = FALSE;
	return;
    }
    if (flag_help) hproc_macrotool();
    bufsuite = NULL;
    if (flag_in_macro) return;
    flag_in_macro = TRUE;
    init_macro_panel();
}
