/*
** File: NewGraph.c
** Purpose: Allocate memory for a new graph.
** Author: James Painter, David Meyers
** Last Modified: 8 November 1989
*/

#include <stdio.h>
#include <TypeDefinitions.h>
#include "TorGraph.h"
extern char *malloc();
extern void free();

GraphType *NewGraph( NRows, NColumns )
 {
  int i, row;
  GraphType *G;
 
  if (! (G = (GraphType *) malloc( sizeof(GraphType))))
   {
    (void) fprintf( stderr, "NewGraph.  No memory.\n" );
    return (GraphType *) NULL;
   }
  G->Rows = NRows;
  G->Columns = NColumns;
  G->N = NULL;
  G->PSN = NULL;

  if (! (G->N = (NodeType **) malloc((unsigned) G->Rows*sizeof(NodeType *))) )
   {
    (void) fprintf( stderr, "NewGraph.  No memory..\n" );
    DisposeGraph( G );
    return (GraphType *) NULL;
   }
  for (i=0; i<G->Rows; i++) G->N[i] = (NodeType *) NULL;

  if (! (G->PSN = (PSNodeType **) 
                  malloc((unsigned)(G->Rows+1)*sizeof(PSNodeType *)))
     )
   {
    (void) fprintf( stderr, "NewGraph.  No memory...\n" );
    DisposeGraph( G );
    return (GraphType *) NULL;
   }
  for (i=0; i<=G->Rows; i++) G->PSN[i] = (PSNodeType *) NULL;


  for (row=0; row<G->Rows; row++ )
   {
    if (! (G->N[row] = (NodeType *)
                  malloc((unsigned)(G->Columns)*sizeof(NodeType)))
       )
     {
      (void) fprintf( stderr, "NewGraph.  No memory....\n" );
      DisposeGraph( G );
      return (GraphType *) NULL;
     }

    if (! (G->PSN[row] = (PSNodeType *)
                  malloc((unsigned)(G->Columns+1)*sizeof(PSNodeType)))
       )
     {
      (void) fprintf( stderr, "NewGraph.  No memory.....\n" );
      DisposeGraph( G );
      return (GraphType *) NULL;
     }
   }
  if (! (G->PSN[G->Rows] = (PSNodeType *)
                malloc((unsigned)(G->Columns+1)*sizeof(PSNodeType)))
     )
   {
    (void) fprintf( stderr, "NewGraph.  No memory......\n" );
    DisposeGraph( G );
    return (GraphType *) NULL;
   }

  return G;
 }


DisposeGraph(G)
GraphType *G;
 {
  int row;

  if (G == NULL) return;

  if (G->PSN != NULL)
   {
    for (row=0; row<=G->Rows; row++)
     {
      if (G->PSN[row] != NULL) free( (char *) G->PSN[row] );
     }
    free ( (char *) G->PSN );
   }


  if (G->N != NULL)
   {
    for (row=0; row<G->Rows; row++)
     {
      if (G->N[row] != NULL) free ( (char *) G->N[row] );
     }
    free ( (char *) G->N );
   }
  free ( (char *)G );
 }

