/***********************************************************************\
* 								        *
* File: BtlnckAllPath.c						        *
* Purpose: Search a toroidal graph for the minimal cost path among all  *
*          possible paths.  Each search constrains future searches by   *
*          narrowing the portion of the graph to be searched.  This     *
*          algorithm is an improvment on the method of Fuchs et. al.    *
*          The improvement is to look for the narrowest bottleneck in   *
*          and subdivide					        *
* Author:  James Painter, David Meyers                  	        *
* Last Modified: 27 November 1989                                        *
* 								        *
\***********************************************************************/

#include <TypeDefinitions.h>
#include <TorGraph.h>
#include <stdio.h>

extern void exit();
extern PathType *BestPath;
extern REAL BiasAdjustment, BiasIncrement;
extern void CopyPath();
extern void SubDivide();

static void PathsBetween ( RightPath, LeftPath, G, BestCost )
 PathType *RightPath, *LeftPath;
 GraphType *G;
 REAL   *BestCost;
 {
  PathType *Path;
  static REAL Cost;
  static int Size, Row, Col;
  static WhichWayType WhichWay;
  static int RightSize, LeftSize;
  int Debug = FALSE;

  if (! (Path = NewPath( G->Rows, G->Columns )) ) exit(1);

  if(Debug)
   {
    (void) fprintf(stderr,"Calling Subdivide\n");
    (void) fprintf(stderr,
		   "\tLeftStartR=%d, RightStartR=%d\n", LeftPath->StartR,
		   RightPath->StartR);
   }
  SubDivide ( LeftPath, RightPath, &Row, &Col, &Size, &WhichWay );
  if(Debug)
   (void) fprintf(stderr,"Back from Subdivide, Row=%d, Col=%d Size=%d\n",
	   Row, Col, Size);

  if (Size >0)
   {
    if(Debug)
     (void) fprintf(stderr,"Calling OnePathFence\n");
    Cost = OnePathFence ( Row, Col, LeftPath, RightPath, G, Path );
    if(Debug)
     (void) fprintf(stderr,
		    "Back from OnePathFence, Cost = %f, BestCost = %f\n",
	     Cost, *BestCost);
    if (Cost < *BestCost)
     {
      *BestCost = Cost;
      CopyPath( Path, BestPath );
     }
    if (Size >1)
     {
      /*
      **  Check the sizes of the two subgraphs and see if the bias
      **  went the right way.  Use this information to update the
      **  bias adjustment.
      */
      RightSize = MeasureGraph( RightPath, Path );
      LeftSize = MeasureGraph( Path, LeftPath );

      if ( ( (RightSize < LeftSize) && WhichWay == TowardsLeft) ||
           ( (LeftSize < RightSize) && WhichWay == TowardsRight)
         )
       {
/*
        BiasAdjustment -= BiasIncrement;
*/
       }
      else if (WhichWay != DontKnow)
       {
        BiasAdjustment += BiasIncrement;
        if (BiasAdjustment > .5) 
          BiasAdjustment = .5;
       }      

      if(Debug)
       (void) fprintf(stderr,"Calling PathsBetween Recursively, first time\n");
      PathsBetween ( RightPath, Path, G, BestCost );
      if(Debug)
       (void) fprintf(stderr,
		      "Back from PathsBetween1, BestCost = %f\n", *BestCost);
      if(Debug)
       (void) fprintf(stderr,
		      "Calling PathsBetween Recursively, second time\n");
      PathsBetween ( Path,  LeftPath, G, BestCost );
      if(Debug)
       (void) fprintf(stderr,
		      "Back from PathsBetween2, BestCost = %f\n", *BestCost);
     }
   }
  DisposePath( Path );
 }


/* ------------------------------------------------------------------------ */


REAL BtlnckAllPaths( G, P, StartRow, StartCol )
 GraphType *G;
 PathType  **P;
 int StartRow;
 int StartCol;
 {
  PathType *RightPath, *LeftPath;
  REAL BestCost;

  BiasAdjustment = 0;

  RightPath = NewPath( G->Rows, G->Columns );

  LeftPath = NewPath( G->Rows, G->Columns );
  if (RightPath == NULL || LeftPath == NULL) return 0;

  BestCost = OnePath ( StartRow, StartCol, G, RightPath );

  FillPath( G, StartRow + G->Rows, StartCol, LeftPath );
  BestPath = DuplPath( RightPath );

  PathsBetween( RightPath, LeftPath, G, &BestCost );

  DisposePath( RightPath );
  DisposePath( LeftPath );
  *P = BestPath;
  return BestCost;
 }  
