;
; QPEG video driver
; for VESA compatible graphics cards
;

        .286
Code    Segment Para 'Code'
        Assume  cs:Code
        Org 100h

Procs   dw      Bank,Init,Exit,0

Bank:   pusha
        mul     cs:VesaGranularity
        mov     dx,ax
        push    dx
        xor     bx,bx           ; window A
        call    cs:[VesaBankSwitch]
        pop     dx
        mov     bx,1            ; window B
        call    cs:[VesaBankSwitch]
        popa
        retf

VesaBankSwitch  dd 0
VesaGranularity db 0

Init:   push    cx
        mov     dx,cs
        mov     es,dx
        xor     di,di           ; es:di - VESA info table
        mov     cx,bx           ; mode number
        mov     ax,4f01h        ; get VESA mode info
        int     10h

        mov     ax,cs:[0ch]
        mov     Word Ptr cs:VesaBankSwitch,ax
        mov     ax,cs:[0eh]
        mov     Word Ptr cs:VesaBankSwitch+2,ax

        mov     cx,cs:[04h]     ; VESA page granularity (in Kb)
        mov     al,1
        test    cx,cx
        je      Gran64
        mov     ax,64
        div     cl
Gran64: mov     cs:VesaGranularity,al

        pop     ax
        mov     cx,cs:[10h]     ; bytes per line
        cmp     cx,ax
        jae     Ready
        add     cx,cx
Ready:  retf

Exit:   retf

Code    Ends
        End Procs

; End of source.
