Unit GetCom;

INTERFACE

Procedure GetCommand(x:real; var y:word;
                     Xmax:Integer; Var Command:String;
                     Var Abort:Boolean; var Repeating:Boolean);

IMPLEMENTATION

Uses Graph,Crt,Tools,Scrolling,Queue,Uservars;

var s:string;

Procedure BlackBar(Tpos,Y:Integer);
Begin
SetFillstyle(SolidFill,Black);
Bar(Tpos,y+8,Tpos+6,y+9);
end;



Procedure TidyCommand(Var Command:String);

Var                    {This Routine removes all unwanted Spaces in the }
   Tidy:Boolean;       {command which was entered.                      }
   Za,L:Byte;

Begin
Repeat
 Tidy:=True;
 L:=length(Command);

 for Za:=1 to L-1 do
          if Copy(Command,Za,2)='  ' then begin
                                     Delete(Command,Za,1);
                                     Tidy:=False;
                                     end;

 if Copy(Command,L,1)=' ' then begin
                          Delete(Command,Length(Command),1);
                          Tidy:=False;
                          end;
 L:=length(Command);
 if Copy(Command,1,1)=' ' then begin
                          Delete(Command,1,1);
                          Tidy:=False;
                          end;
Until Tidy;
end;





Procedure GetCommand(x:real; var y:word;
                     Xmax:Integer; Var Command:String;
                     Var Abort:Boolean; var Repeating:Boolean);

Var Tpos,Xpos,Timer:Word;     {Will Read in a command from the Keyboard, }
    Finish,Com:Boolean;       {display it on screen at the specified     }
    Ch:Char;                  {location, and return the command in a     }
    Tcommand:string;          {tidied form, to the calling routine.      }
    x1,y1:integer;

Begin
Timer:=0;
Finish:=False;
Abort:=False;
x1:=round(x);
y1:=round(y);
Tpos:=x1+10;
Command:='';
Xpos:=0;
SetColor(Cyan);
OutTextXY(x1,y1,'>');
Tcommand:='`';
Repeat
 If Tcommand<>Command then begin           {If Command has been altered    }
           SetFillStyle(Solidfill,Black);  {ie, another character has been }
           SetWritemode(Normalput);        {pressed on the keyboard, then  }
           Bar(x1+10,y1,Xmax,y1+7);           {the new Command is re-drawn on }
           Command:=Copy(Command,1,32);    {the screen, and also, it is    }
           OuttextXY(x1+10,y1,Command);      {truncated.                     }
           end;

 SetWritemode(Xorput);                                {                  }
  Repeat                                              {Blinks the cursor }
   if Timer<301 then SetFillstyle(Solidfill,Cyan);    {until a key is    }
   if Timer>300 then SetFillstyle(Solidfill,Black);   {pressed.          }
  Timer:=Timer+1; if Timer>600 then Timer:=0;         {                  }
  Bar(Tpos,y1+8,Tpos+6,y1+9);                           {                  }
 Until Keypressed;

  SetWritemode(Normalput);      {Removes the Cursor.    }
  BlackBar(Tpos,y1);             {                       }

Ch:=Readkey;                    {Reads in the Character Pressed. }
if ch=';' then SlowMo:=Not Slowmo; {}
Com:=False;
Tcommand:=Command;

if (Ch>chr(31)) and (Ch<Chr(91)) then Com:=True;  {Checks Character is   }
if (Ch>chr(96)) and (Ch<Chr(123)) then Com:=True; {within a given ASCII  }
if Ch='\' then Com:=True;                         {range.                }

if Ch=Chr(0) then begin         {Chr(0) signifies a special character has}
                                {been pressed, in this case, two chr     }
                                {Values are returned                     }
                  Ch:=Readkey;

                     if (Ch=Chr(75)) and (Xpos>0) then begin
                               Tpos:=Tpos-8;
                               Xpos:=Xpos-1;     {Cursor Left Pressed  }
                               end;
                     if (Ch=Chr(77)) and ((Tpos+16)<Xmax) then begin
                               Tpos:=Tpos+8;
                               Xpos:=Xpos+1;     {Cursor Right Pressed }
                               end;
                     if (Ch=Chr(72)) and (Repeating=True)
                                     and (y1>5) then begin
                                         Finish:=True;
                                         Repeating:=False;
                                         end;

                  end;

if (Com=True) and ((Tpos+16)<Xmax) then Begin
                 Xpos:=Xpos+1;                   {Insert the character    }
                 Insert(Ch,Command,Xpos);        {pressed into the string }
                 Tpos:=Tpos+8;                   {Command, and advance    }
                                                 {cursor.                 }

                 If Xpos>Length(Command) then begin
                                         Xpos:=Length(Command);
                                         Tpos:=X1+10+(Length(Command)*8);
                                         end;
                 end;                        {If Cursor is further to the }
                                             {right than the end of the   }
                                             {Command, then it is set back}
                                             {to the end of the command   }
                                             {when a key is pressed.      }

If Ch=chr(8) then Begin    {The Backspace key has been pressed so a char }
                           {will be deleted from the string "Command".   }
                           {(assuming there are already chars in Command)}

                  if Length(Command)>0 then Delete(Command,Xpos,1);
                  if Xpos>0 then begin
                                 Tpos:=Tpos-8;
                                 Xpos:=Xpos-1;
                                 end;
                  end;


if Ch=chr(13) then Finish:=True;  {Return has been pressed, and so the  }
      if Ch=chr(27) then Begin    {full command has been entered.       }
                   Command:='';
                   Finish:=True;
                   Abort:=True;
                   end;

Until Finish=True;
SetWritemode(Normalput);
TidyCommand(Command);          {Gets rid of unwanted spaces in Command }
Hicase(Command);               {Sets all chars in Command to uppercase }
end;

End. {Of Unit}