/************************************************************
   Copyright (C) 1993 by The Trustees of Columbia University in the City 
   of New York

   OBJECT-ORIENTED Protein Data Bank Project
   Biochemistry and Molecular Biophysics, Computer Science depts.
 **************************************************************

   File: sorter.h
   Responsable: Weider Chang, Ph.D

 **************************************************************/

#include <stddef.h>
#include <stdlib.h>

struct HistogramValues;

typedef struct List {
  double value;
  void * content;
  List * next;
};

typedef struct B_tree{
  B_tree * right, * left;
  double value;
  void * content;
};

typedef struct Head_tail {
  List * head;
  List * tail;
};



class IntrSorter {
  
 protected:
  B_tree * b_head_p;
  B_tree * b_tail_p;
  Head_tail * sort(B_tree*);
  
 public:
  IntrSorter() {b_head_p=NULL;}
  ~IntrSorter() {delete b_head_p;};
  void insert(SubEntity*, double);
  HistogramValues * sorted_contents(HistogramValues*);
};

class Sorter : public IntrSorter {
};












