/************************************************************
   Copyright (C) 1993 by The Trustees of Columbia University in the City 
   of New York

   OBJECT-ORIENTED Protein Data Bank Project
   Biochemistry and Molecular Biophysics, Computer Science depts.
 **************************************************************

   File: i_connectivity.h
   Responsable: Weider Chang, Ph.D

 **************************************************************/

#ifndef _H_CORECONNECTIVITYINFO
#define _H_CORECONNECTIVITYINFO

#include <stddef.h>
#include <stdlib.h>
#include "oopdb_setup.h"
#include "structure.h"
#include "linebuffer.h"

class ConnectionInfo;
class SubEntityConnectivity;
class ConnectivitySet;

class Bound_atom {
 public:
  int sequence_no;
  Bound_atom *next;
  Bound_atom();
  Bound_atom(Bound_atom&);
  void add_next(Bound_atom * ba_p) {next=ba_p;}
};


class IntrConnectionInfo {
  friend IntrSubEntityConnectivity;
 protected:
  char d_name[5];
  Bound_atom *atom_list;
  IntrConnectionInfo();
  virtual Bound_atom * new_bound_atom(Bound_atom*);
 public:
  virtual void deep_copy(const ConnectionInfo&);
  virtual ~IntrConnectionInfo();
};

#endif

#ifdef _H_CONNECTIONINFO
#define _H_CORESUBENTITYCONNECTIVITY

class IntrSubEntityConnectivity {

  friend class IntrConnectivityMap;
  friend class IntrSubEntity;

 protected:
  char name[83];
  char formula[83];
  int to_previous;
  int to_next;
  SubEntityConnectivity * alternative;
  SubEntityConnectivity * next;
  ConnectionInfo *atoms;
  char d_name[5];
  int num_atoms;
  SubEntityType type;
  IntrSubEntityConnectivity();
  IntrSubEntityConnectivity(LineBuffer*);
  void add_next(SubEntityConnectivity* sp){next=sp;}
  void add_alternative(SubEntityConnectivity* sp){alternative=sp;}
  virtual ConnectionInfo * new_connection_info(int);

 public:
  Bound_atom * bound_atoms(const Atom*) const;
  void show_connectivity() const;
  int atom_to_previous_subentity() const {return to_previous;}
  int atom_to_next_subentity() const {return to_next;}
  char *name_of_atom(int i) const {return atoms[i].d_name;}
  int atom_seq(char*);
  int operator==(IntrSubEntityConnectivity*);
  virtual void deep_copy(const SubEntityConnectivity&);
  virtual ~IntrSubEntityConnectivity();
};



class IntrConnectivityMap {

  friend class IntrSubEntity;
  
 protected:
  IntrConnectivityMap(){r_connectivities=NULL;}
  IntrConnectivityMap(char*);
  SubEntityConnectivity * r_connectivities;
  
 public:
  void check();
  void import(char*);
  SubEntityConnectivity * connectivity_of(SubEntity*);
  int is_bio_subentity(char*);
  int is_het_subentity(char*);
  SubEntityConnectivity **find_rc_site(LineBuffer*);
  SubEntityType subentity_type_of(char*);
  virtual void deep_copy(const ConnectivitySet&);
  virtual SubEntityConnectivity * new_subentity_connectivity();
  virtual ~IntrConnectivityMap();
};

#endif
















