/************************************************************
   Copyright (C) 1993 by The Trustees of Columbia University in the City 
   of New York

   OBJECT-ORIENTED Protein Data Bank Project
   Biochemistry and Molecular Biophysics, Computer Science depts.
 **************************************************************

   File: bonds.h
   Responsable: Weider Chang, Ph.D

 **************************************************************/
#ifndef _H_BONDS
#define _H_BONDS

#include "oopdb_setup.h"
#include "i_bonds.h"

class Bond : public IntrBond {
 public:
  Bond(){}
  Bond(Atom *b, Atom *e) : IntrBond(b, e){}
  Bond(int i, int j) : IntrBond(i, j){}
};

#define _BOND
#include "i_bonds.h"

class CovalBond : public IntrCovalBond {
 public:
  CovalBond(){}
  CovalBond(Atom *b, Atom *e) : IntrCovalBond(b, e){}
};

class HydroBond : public IntrHydroBond {
 public:
  HydroBond(){}
  HydroBond(Atom *d, Atom *a) : IntrHydroBond(d, a) {}
};

class SaltBridg : public IntrSaltBridg {
 public:
  SaltBridg(){}
  SaltBridg(Atom *n, Atom *p) : IntrSaltBridg(n, p) {}
};

class SSBond : public IntrSSBond {
 public:
  SSBond() {}
  SSBond(Atom *b, Atom *e) : IntrSSBond(b, e) {}
};
#endif










