###############################################################################
#  The BYTE UNIX Benchmarks - Release 2
#          Module: mem.awk   SID: 2.1 8/6/89 22:24:32
#          
###############################################################################
# Bug reports, patches, comments, suggestions should be sent to:
#
#	Ben Smith or Rick Grehan at BYTE Magazine
#	ben@bytepb.UUCP    rick_g@bytepb.UUCP
#
###############################################################################
#  Modification Log:
#
###############################################################################
BEGIN   { r_product = 0.0000; c_product = 0.0000; }
/real/	{ next }  # don't use these times
/user/	{ next }
/sys/	{ next }
/^$/	{ next } 
/^[0-9][ .0-9-]*$/ && NF==3 { 
	r=$2;
	if (r < 0) {
	    print "** Iteration ",iter+1," real loop < ohead: ",$0;
	    r=0;
	    }
	iter++;
	numacc=$1; 
	real+=r;
	r2+=r*r;
	if(r) { r_product += log(r);}
	cpu+=$3;
	c2+=$3*$3;
	if($3) { c_product += log($3);}
	next; 
        }
{ print "** Iteration ",iter+1," Failed: ",$0 }
END {
	if (iter > 0) { 
	    printf "                       Arithmetric        Geometric         Variance\n";
	    printf "                              Mean             Mean         (%d tests)\n",iter
	    printf "CPU Time (secs):         %9.2f        %9.2f         ",cpu/iter,exp(c_product/iter);
	    if (iter > 1) printf "%9.2f\n",(r2-cpu*cpu/iter)/(iter-1);
	    else printf "n/a\n"
	    rgm = exp(r_product/iter);	# geometric mean of real time
	    printf "Real Time (secs):        %9.2f        %9.2f         ",real/iter,rgm;
	    if (iter > 1) printf "%9.2f\n",(r2-real*real/iter)/(iter-1);
	    else printf "n/a\n"
	    printf "Rate (access/sec):       %9.0f \n", numacc/rgm; 
	    } 
	else { 
	    print "-- no measured results --"; 
	    }
    }
