C     ****************
      SUBROUTINE HYP3D(
C     ****************
     >                 NX,NY,NZ,NT,
     >                 NXYZH,NXYTH,NXZTH,NYZTH,
     >                 NXE,NXYE,NXYZE,
     >                 GX,GY,GZ,GT,
     >                 LX,LY,LZ,LT,
     >                 FX,FY,FZ,FT )
C
C
      INTEGER        GX(NYZTH,2,4),GY(NXZTH,2,4),
     >               GZ(NXYTH,2,4),GT(NXYZH,2,4)
C
      INTEGER        LX(2,4),LY(2,4),
     >               LZ(2,4),LT(2,4)
C
C
      INTEGER        FX(4),FY(4),FZ(4),FT(4)
C
C
C     3-D HYPERPLANES X=NX+1; X=2; X=1; X=NX+2
C     3-D HYPERPLANES Y=NY+1; Y=2; Y=1; Y=NY+2
C     3-D HYPERPLANES Z=NZ+1; Z=2; Z=1; Z=NZ+2
C     3-D HYPERPLANES T=NT+1; T=2; T=1; T=NT+2
C
C
      DO 10 L = 1,4
C
C
C     **********
      CALL HYPPL(
C     **********
     >           NXE,NXYE,NXYZE,
     >           GX(1,1,L),LX(1,L),NYZTH,
     >           FX(L),2,2,2,FX(L),NY+1,NZ+1,NT+1 )
C
C
C     **********
      CALL HYPPL(
C     **********
     >           NXE,NXYE,NXYZE,
     >           GY(1,1,L),LY(1,L),NXZTH,
     >           2,FY(L),2,2,NX+1,FY(L),NZ+1,NT+1 )
C
C
C     **********
      CALL HYPPL(
C     **********
     >           NXE,NXYE,NXYZE,
     >           GZ(1,1,L),LZ(1,L),NXYTH,
     >           2,2,FZ(L),2,NX+1,NY+1,FZ(L),NT+1 )
C
C
C     **********
      CALL HYPPL(
C     **********
     >           NXE,NXYE,NXYZE,
     >           GT(1,1,L),LT(1,L),NXYZH,
     >           2,2,2,FT(L),NX+1,NY+1,NZ+1,FT(L) )
C
C
   10 CONTINUE
C
C
      RETURN
      END
