.NH 1
MONITORING SECURITY
.PP
One of the most important tasks in keeping any computer system secure
is monitoring the security of the system.
This involves examining system log files for unauthorized accesses of the
system,
as well as monitoring the system itself for security holes.
This section describes the procedures for doing this.
An additional part of monitoring security involves keeping abreast of
security problems found by others;
this is described in Section 5.
.NH 2
ACCOUNT SECURITY
.PP
Account security should be monitored periodically in order to check for
two things: users logged in when they ``shouldn't'' be (e.g.,
late at night,
when they're on vacation,
etc.),
and users executing commands they wouldn't normally be expected to use.
The commands described in this section can be used to obtain this information
from the system.
.NH 3
The lastlog File
.PP
The file
.I /usr/adm/lastlog
[Sun88a, 1485]
records the most recent login time for each user of the system.
The message printed each time you log in,
e.g.,
.DS
.ft C
Last login: Sat Mar 10 10:50:48 from spam.itstd.sri.c
.ft R
.DE
uses the time stored in the
.I lastlog
file.
Additionally,
the last login time reported by the
.I finger
command uses this time.
Users should be told to carefully examine this time whenever they log in,
and to report unusual login times to the system administrator.
This is an easy way to detect account break-ins,
since each user should remember the last time she logged into the system.
.NH 3
The utmp and wtmp Files
.PP
The file
.I /etc/utmp
[Sun88a, 1485] is used to record who is currently logged into the system.
This file can be displayed using the
.I who
command [Sun88a, 597]:
.DS
.ft C
% \f(CBwho\fP
hendra   tty0c   Mar 13 12:31
heidari  tty14   Mar 13 13:54
welgem   tty36   Mar 13 12:15
reagin   ttyp0   Mar 13 08:54   (aaifs.itstd.sri.)
ghg      ttyp1   Mar  9 07:03   (hydra.riacs.edu)
compion  ttyp2   Mar  1 03:01   (ei.ecn.purdue.ed)
.ft R
.DE
For each user,
the login name,
terminal being used,
login time,
and remote host (if the user is logged in via the network) are displayed.
.PP
The file
.I /usr/adm/wtmp
[Sun88a, 1485] records each login and logout time for every user.
This file can also be displayed using the
.I who
command:
.DS
.ft C
% \f(CBwho /usr/adm/wtmp\fP
davy     ttyp4    Jan  7 12:42 (annex01.riacs.ed)
         ttyp4    Jan  7 15:33
davy     ttyp4    Jan  7 15:33 (annex01.riacs.ed)
         ttyp4    Jan  7 15:35
hyder    ttyp3    Jan  8 09:07 (triceratops.itst)
         ttyp3    Jan  8 11:43
.ft R
.DE
A line that contains a login name indicates the time the user logged in;
a line with no login name indicates the time that the terminal was logged
off.
Unfortunately,
the output from this command is rarely as simple as in the example above;
if several users log in at once,
the login and logout times are all mixed together
and must be matched up by hand using the terminal name.
.PP
The
.I wtmp
file may also be examined using the
.I last
command [Sun88a, 248].
This command sorts out the entries in the file,
matching up login and logout times.
With no arguments,
.I last
displays all information in the file.
By giving the name of a user or terminal,
the output can be restricted to the information about the user or terminal
in question.
Sample output from the
.I last
command is shown below.
.DS
.ft C
.ps -2
.vs -2
% \f(CBlast\fP
davy      ttyp3  intrepid.itstd.s Tue Mar 13 10:55 - 10:56 (00:00)
hyder     ttyp3  clyde.itstd.sri. Mon Mar 12 15:31 - 15:36 (00:04)
reboot    ~                       Mon Mar 12 15:16
shutdown  ~                       Mon Mar 12 15:16
arms      ttyp3  clyde0.itstd.sri Mon Mar 12 15:08 - 15:12 (00:04)
hyder     ttyp3  spam.itstd.sri.c Sun Mar 11 21:08 - 21:13 (00:04)
reboot    ~                       Sat Mar 10 20:05
davy      ftp    hydra.riacs.edu  Sat Mar 10 13:23 - 13:30 (00:07)
.ft R
.ps
.vs
.DE
For each login session,
the user name,
terminal used,
remote host (if the user logged in via the network),
login and logout times,
and session duration are shown.
Additionally,
the times of all system shutdowns and reboots (generated by the
.I shutdown
and
.I reboot
commands [Sun88a, 1727, 1765]) are recorded.
Unfortunately,
system crashes are not recorded.
In newer versions of the operating system,
pseudo logins such as those via the
.I ftp
command are also recorded;
an example of this is shown in the last line of the sample output,
above.
.NH 3
The acct File
.PP
The file
.I /usr/adm/acct
[Sun88a, 1344-1345] records each execution of a command on the system,
who executed it,
when,
and how long it took.
This information is logged each time a command completes,
but only if your kernel was compiled with the
.SM SYSACCT
option enabled (the option is enabled in some
.SM GENERIC
kernels,
but is usually disabled by default).
.PP
The
.I acct
file can be displayed using the
.I lastcomm
command [Sun88a, 249].
With no arguments,
all the information in the file is displayed.
However,
by giving a command name,
user name,
or terminal name as an argument,
the output can be restricted to information about the given command,
user,
or terminal.
Sample output from
.I lastcomm
is shown below.
.DS
.ft C
.ps -2
.vs -2
% \f(CBlastcomm\fP
sh         S     root     __         0.67 secs Tue Mar 13 12:45
atrun            root     __         0.23 secs Tue Mar 13 12:45
lpd         F    root     __         1.06 secs Tue Mar 13 12:44
lpr        S     burwell  tty09      1.23 secs Tue Mar 13 12:44
troff            burwell  tty09     12.83 secs Tue Mar 13 12:44
eqn              burwell  tty09      1.44 secs Tue Mar 13 12:44
df               kindred  ttyq7      0.78 secs Tue Mar 13 12:44
ls               kindred  ttyq7      0.28 secs Tue Mar 13 12:44
cat              kindred  ttyq7      0.05 secs Tue Mar 13 12:44
stty             kindred  ttyq7      0.05 secs Tue Mar 13 12:44
tbl              burwell  tty09      1.08 secs Tue Mar 13 12:44
rlogin     S     jones    ttyp3      5.66 secs Tue Mar 13 12:38
rlogin      F    jones    ttyp3      2.53 secs Tue Mar 13 12:41
stty             kindred  ttyq7      0.05 secs Tue Mar 13 12:44
.ft R
.ps
.vs
.DE
The first column indicates the name of the command.
The next column displays certain flags on the command:
an ``F'' means the process spawned a child process,
``S'' means the process ran with the set-user-id bit set,
``D'' means the process exited with a core dump,
and ``X'' means the process was killed abnormally.
The remaining columns show the name of the user who ran the program,
the terminal he ran it from (if applicable),
the amount of
.SM CPU
time used by the command (in seconds),
and the date and time the process started.
.NH 2
NETWORK SECURITY
.PP
Monitoring network security is more difficult,
because there are so many ways for a cracker to attempt to break in.
However,
there are some programs available to aid you in this task.
These are described in this section.
.NH 3
The syslog Facility
.PP
The
.I syslog
facility [Sun88a, 1773] is a mechanism that enables any command to log error
messages and informational messages to the system console,
as well as to a log file.
Typically,
error messages are logged in the file
.I /usr/adm/messages
along with the date,
time,
name of the program sending the message,
and (usually) the process id of the program.
A sample segment of the
.I messages
file is shown below.
.DS
.ft C
.ps -2
.vs -2
Mar 12 14:53:37 sparkyfs login: ROOT LOGIN ttyp3 FROM setekfs.itstd.sr
Mar 12 15:18:08 sparkyfs login: ROOT LOGIN ttyp3 FROM setekfs.itstd.sr
Mar 12 16:50:25 sparkyfs login: ROOT LOGIN ttyp4 FROM pongfs.itstd.sri
Mar 12 16:52:20 sparkyfs vmunix: sd2c:  read failed, no retries
Mar 13 06:01:18 sparkyfs vmunix: /: file system full
Mar 13 08:02:03 sparkyfs login: ROOT LOGIN ttyp4 FROM triceratops.itst
Mar 13 08:28:52 sparkyfs su: davy on /dev/ttyp3
Mar 13 08:38:03 sparkyfs login: ROOT LOGIN ttyp4 FROM triceratops.itst
Mar 13 10:56:54 sparkyfs automount[154]: host aaifs not responding
Mar 13 11:30:42 sparkyfs login: REPEATED LOGIN FAILURES ON ttyp3 FROM
                intrepid.itstd.s, daemon
.ft R
.ps
.vs
.DE
Of particular interest in this sample are the messages from the
.I login
and
.I su
programs.
Whenever someone logs in as ``root,''
.I login
logs this information.
Generally,
logging in as ``root'' directly,
rather than using the
.I su
command,
should be discouraged,
as it is hard to track which person is actually using the account.
Once this ability has been disabled,
as described in Section 2.2.2,
detecting a security violation becomes a simple matter of searching the
.I messages
file for lines of this type.
.PP
.I Login
also logs any case of someone repeatedly trying to log in to an account and
failing.
After three attempts,
.I login
will refuse to let the person try anymore.
Searching for these messages in the
.I messages
file can alert you to a cracker attempting to guess someone's password.
.PP
Finally,
when someone uses the
.I su
command,
either to become ``root'' or someone  else,
.I su
logs the success or failure of this operation.
These messages can be used to check for users sharing their passwords,
as well as for a cracker who has penetrated one account and is trying to
penetrate others.
.NH 3
The showmount Command
.PP
The
.I showmount
command [Sun88a, 1764] can be used on an
.SM NFS
file server to display the names of all hosts that currently have something
mounted from the server.
With no options,
the program simply displays a list of all the hosts.
With the
.I -a
and
.I -d
options,
the output is somewhat more useful.
The first option,
.I -a ,
causes
.I showmount
to list all the host and directory combinations.
For example,
.DS
.ft C
bronto.itstd.sri.com:/usr/share
bronto.itstd.sri.com:/usr/local.new
bronto.itstd.sri.com:/usr/share/lib
bronto.itstd.sri.com:/var/spool/mail
cascades.itstd.sri.com:/sparky/a
clyde.itstd.sri.com:/laser_dumps
cm1.itstd.sri.com:/sparky/a
coco0.itstd.sri.com:/sparky/a
.ft R
.DE
There will be one line of output for each directory mounted by a host.
With the
.I -d
option,
.I showmount
displays a list of all directories that are presently mounted by some
host.
.PP
The output from
.I showmount
should be checked for two things.
First,
only machines local to your organization should appear there.
If you have set up proper netgroups as described in Section 2.2.3,
this should not be a problem.
Second,
only ``normal'' directories should be mounted.
If you find unusual directories being mounted,
you should find out who is mounting them and why \-
although it is probably innocent,
it may indicate someone trying to get around your security mechanisms.
.NH 2
FILE SYSTEM SECURITY
.PP
Checking for security holes in the file system is another important part
of making your system secure.
Primarily,
you need to check for files that can be modified by unauthorized users,
files that can inadvertently grant users too many permissions,
and files that can inadvertently grant access to crackers.
It is also important to be able to detect unauthorized modifications
to the file system,
and to recover from these modifications when they are made.
.NH 3
The find Command
.PP
The
.I find
command [Sun88a, 183-185] is a general-purpose command for searching the file
system.
Using various arguments,
complex matching patterns based on a file's name,
type,
mode,
owner,
modification time,
and other characteristics,
can be constructed.
The names of files that are found using these patterns can then be printed
out,
or given as arguments to other
.SM UNIX
commands.
The general format of a
.I find
command is
.DS
.ft C
% \f(CBfind\fP \fIdirectories\fP \fIoptions\fP
.ft R
.DE
where
.I directories
is a list of directory names to search (e.g.,
.I /usr ),
and
.I options
contains the options to control what is being searched for.
In general,
for the examples in this section,
you will always want to search from the root of the file system (\fI/\fP),
in order to find all files matching the patterns presented.
.PP
This section describes how to use
.I find
to search for four possible security problems that were described in
Section 2.
.NH 4
Finding Setuid and Setgid Files
.PP
It is important to check the system often for unauthorized setuid and
setgid programs.
Because these programs grant special privileges to the user who is
executing them,
it is necessary to ensure that insecure programs are not installed.
Setuid ``root'' programs should be closely guarded \- a favorite trick
of many crackers is to break into ``root'' once,
and leave a setuid program hidden somewhere that will enable them to
regain super-user powers even if the original hole is plugged.
.PP
The command to search for setuid and setgid files is
.DS
.ft C
# \f(CBfind / -type f -a \e( -perm -4000 -o -perm -2000 \e) -print\fP
.ft R
.DE
The options to this command have the following meanings:
.RS
.IP "\fC/\fP"
The name of the directory to be searched.
In this case,
we want to search the entire file system,
so we specify
.I / .
You might instead restrict the search to
.I /usr
or
.I /home .
.IP "\fC-type f\fP"
Only examine files whose type is ``f,''
regular file.
Other options include ``d'' for directory,
``l'' for symbolic link,
``c'' for character-special devices,
and ``b'' for block-special devices.
.IP "\fC-a\fP"
This specifies ``and.''
Thus,
we want to know about files whose type is ``regular file,''
.I and
whose permissions bits match the other part of this expression.
.IP "\fC\e( -perm -4000 -o -perm -2000 \e)\fP"
The parentheses in this part of the command are used for grouping.
Thus,
everything in this part of the command matches a single pattern,
and is treated as the other half of the ``and'' clause described above.
.RS
.IP "\fC-perm -4000\fP"
This specifies a match if the ``4000'' bit (specified as an octal number)
is set in the file's permission modes.
This is the set-user-id bit.
.IP "\fC-o\fP"
This specifies ``or.''
Thus,
we want to match if the file has the set-user-id bit
.I or
the set-group-id bit set.
.IP "\fC-perm -2000\fP"
This specifies a match if the ``2000'' bit (specified as an octal number)
is set in the file's permission modes.
This is the set-group-id bit.
.RE
.IP "\fC-print\fP"
This indicates that for any file that matches the specified expression
(is a regular file
.I and
has the setuid
.I or
setgid bits set in its permissions),
print its name on the screen.
.RE
.PP
After executing this command (depending on how much disk space you have,
it can take anywhere from 15 minutes to a couple of hours to complete),
you will have a list of files that have setuid or setgid bits set on them.
You should then examine each of these programs,
and determine whether they should actually have these permissions.
You should be especially suspicious of programs that are
.I not
in one of the directories (or a subdirectory) shown below.
.DS
/bin
/etc
/usr/bin
/usr/ucb
/usr/etc
.DE
.PP
One file distributed with
.SM OS , Sun
.I /usr/etc/restore ,
is distributed with the setuid bit set on it,
and should not be,
because of a security hole.
You should be sure to remove the setuid bit from this program by executing
the command
.DS
.ft C
# \f(CBchmod u-s /usr/etc/restore\fP
.ft R
.DE
.NH 4
Finding World-Writable Files
.PP
World-writable files,
particularly system files,
can be a security hole if a cracker gains access to your system and
modifies them.
Additionally,
world-writable directories are dangerous,
since they allow a cracker to add or delete files as he wishes.
The
.I find
command to find all world-writable files is
.DS
.ft C
# \f(CBfind / -perm -2 -print\fP
.ft R
.DE
In this case,
we do not use the
.I \-type
option to restrict the search,
since we are interested in directories and devices as well as files.
The
.I \-2
specifies the world write bit (in octal).
.PP
This list of files will be fairly long,
and will include some files that
.I should
be world writable.
You should not be concerned if terminal devices in
.I /dev
are world writable.
You should also not be concerned about line printer error log files
being world writable.
Finally,
symbolic links may be world writable \- the permissions on a symbolic link,
although they exist,
have no meaning.
.NH 4
Finding Unowned Files
.PP
Finding files that are owned by nonexistent users can often be a clue that
a cracker has gained access to your system.
Even if this is not the case,
searching for these files gives you an opportunity to clean up files that
should have been deleted at the same time the user herself was deleted.
The command to find unowned files is
.DS
.ft C
# \f(CBfind / -nouser -print\fP
.ft R
.DE
The
.I \-nouser
option matches files that are owned by a user id not contained in the
.I /etc/passwd
database.
A similar option,
.I \-nogroup ,
matches files owned by nonexistent groups.
To find all files owned by nonexistent users
.I or
groups,
you would use the
.I \-o
option as follows:
.DS
.ft C
# \f(CBfind / -nouser -o -nogroup -print\fP
.ft R
.DE
.NH 4
Finding \&.rhosts Files
.PP
As mentioned in Section 2.2.1.2,
users should be prohibited from having
.I \&.rhosts
files in their accounts.
To search for this,
it is only necessary to search the parts of the file system that contain
home directories (i.e., you can skip
.I /
and
.I /usr ):
.DS
.ft C
# \f(CBfind /home -name .rhosts -print\fP
.ft R
.DE
The
.I \-name
option indicates that the complete name of any file whose name matches
.I \&.rhosts
should be printed on the screen.
.NH 3
Checklists
.PP
Checklists can be a useful tool for discovering unauthorized changes made to
system directories.
They aren't practical on file systems that contain users' home directories
since these change all the time.
A checklist is a listing of all the files contained in a group of directories:
their sizes,
owners,
modification dates,
and so on.
Periodically,
this information is collected and compared with the information in the
master checklist.
Files that do not match in all attributes can be suspected of having been
changed.
.PP
There are several utilities that implement checklists available from
public software sites (see Section 4).
However,
a simple utility can be constructed using only the standard
.SM UNIX
.I ls
and
.I diff
commands.
.PP
First,
use the
.I ls
command [Sun88a, 285] to generate a master list.
This is best done immediately after installing the operating system,
but can be done at any time provided you're confident about the correctness
of the files on the disk.
A sample command is shown below.
.DS
.ft C
# \f(CBls -aslgR /bin /etc /usr > MasterChecklist\fP
.ft R
.DE
The file
.I MasterChecklist
now contains a complete list of all the files in these directories.
You will probably want to edit it and delete the lines for files you know
will be changing often (e.g.,
.I /etc/utmp ,
.I /usr/adm/acct ).
The
.I MasterChecklist
file should be stored somewhere safe where a cracker is unlikely to find
it (since he could otherwise just change the data in it): either on a
different computer system,
or on magnetic tape.
.PP
To search for changes in the file system,
run the above
.I ls
command again,
saving the output in some other file,
say
.I CurrentList .
Now use the
.I diff
command [Sun88a, 150] to compare the two files:
.DS
.ft C
# \f(CBdiff MasterChecklist CurrentList\fP
.ft R
.DE
Lines that are only in the master checklist will be printed preceded by a
``<,''
and lines that are only in the current list will be preceded by a ``>.''
If there is one line for a file,
preceded by a ``<,''
this means that the file has been deleted since the master checklist was
created.
If there is one line for a file,
preceded by a ``>,''
this means that the file has been created since the master checklist was
created.
If there are two lines for a single file,
one preceded by ``<'' and the other by ``>,''
this indicates that some attribute of the file has changed since the
master checklist was created.
.PP
By carefully constructing the master checklist,
and by remembering to update it periodically (you can replace it with
a copy of
.I CurrentList ,
once you're sure the differences between the lists are harmless),
you can easily monitor your system for unauthorized changes.
The software packages available from the public software distribution sites
implement basically the same scheme as the one here,
but offer many more options for controlling what is examined and reported.
.NH 3
Backups
.PP
It is impossible to overemphasize the need for a good backup strategy.
File system backups not only protect you in the even of hardware failure
or accidental deletions,
but they also protect you against unauthorized file system changes made
by a cracker.
.PP
A good backup strategy will dump the entire system at level zero (a ``full''
dump) at least once a month.
Partial (or ``incremental'') dumps should be done at least twice a week,
and ideally they should be done daily.
The
.I dump
command [Sun88a, 1612-1614] is recommended over other programs such as
.I tar
and
.I cpio .
This is because only
.I dump
is capable of creating a backup that can be used to restore a disk to
the exact state it was in when it was dumped.
The other programs do not take into account files deleted or renamed
between dumps,
and do not handle some specialized database files properly.
.NH 2
KNOW YOUR SYSTEM
.PP
Aside from running large monitoring programs such as those described in
the previous sections,
simple everyday
.SM UNIX
commands can also be useful for spotting security violations.
By running these commands often,
whenever you have a free minute (for example,
while waiting for someone to answer the phone),
you will become used to seeing a specific pattern of output.
By being familiar with the processes normally running on your system,
the times different users typically log in,
and so on,
you can easily detect when something is out of the ordinary.
.NH 3
The ps Command
.PP
The
.I ps
command [Sun88a, 399-402] displays a list of the processes running on your
system.
.I Ps
has numerous options,
too many to list here.
Generally,
however,
for the purpose of monitoring,
the option string
.I \-alxww
is the most useful.*
.FS *
This is true for Berkeley-based systems.
On System V systems,
the option string
.I \-elf
should be used instead.
.FE
On a Sun system running
.SM OS "" Sun
4.0,
you should expect to see at least the following:
.RS
.IP "\fIswapper, pagedaemon\fP"
System programs that help the virtual memory system.
.IP "\fI/sbin/init\fP"
The
.I init
process,
which is responsible for numerous tasks,
including bringing up login processes on terminals.
.IP "\fIportmap, ypbind, ypserv\fP"
Parts of the Yellow Pages system.
.IP "\fIbiod, nfsd, rpc.mountd, rpc.quotad, rpc.lockd\fP"
Parts of the Network File System
.SM NFS ). (
If the system you are looking at is not a file server,
the
.I nfsd
processes probably won't exist.
.IP "\fIrarpd, rpc.bootparamd\fP"
Part of the system that allows diskless clients to boot.
.RE
.PP
Other commands you should expect to see are
.I update
(file system updater);
.I getty
(one per terminal and one for the console);
.I lpd
(line printer daemon);
.I inetd
(Internet daemon,
for starting other network servers);
.I sh
and
.I csh
(the Bourne shell and C shell,
one or more per logged in user).
In addition,
if there are users logged in,
you'll probably see invocations of various compilers,
text editors,
and word processing programs.
.NH 3
The who and w Commands
.PP
The
.I who
command,
as mentioned previously,
displays the list of users currently logged in on the system.
By running this periodically,
you can learn at what times during the day various users log in.
Then,
when you see someone logged in at a different time,
you can investigate and make sure that it's legitimate.
.PP
The
.I w
command [Sun88a, 588] is somewhat of a cross between
.I who
and
.I ps .
Not only does it show a list of who is presently logged in,
but it also displays how long they have been idle (gone without typing
anything),
and what command they are currently running.
.NH 3
The ls Command
.PP
Simple as its function is,
.I ls
is actually very useful for detecting file system problems.
Periodically,
you should use
.I ls
on the various system directories,
checking for files that shouldn't be there.
Most of the time,
these files will have just ``landed'' somewhere by accident.
However,
by keeping a close watch on things,
you will be able to detect a cracker long before you might have otherwise.
.PP
When using
.I ls
to check for oddities,
be sure to use the
.I \-a
option,
which lists files whose names begin with a period (.).
Be particularly alert for files or directories named ``...'',
or ``..(space)'',
which many crackers like to use.
(Of course,
remember that ``.'' and ``..'' are supposed to be there.)
.NH 2
KEEP YOUR EYES OPEN
.PP
Monitoring for security breaches is every bit as important as preventing
them in the first place.
Because it's virtually impossible to make a system totally secure,
there is always the chance,
no matter how small,
that a cracker will be able to gain access.
Only by monitoring can this be detected and remedied.
