/* 1620, Tue 16 Mar 93

   PRTCOM:  Communications intrinsics for Print Server

   Copyright (C) 1993 by Nevil Brownlee
   Computer Centre,  University of Auckland */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <alloc.h>
#include <dos.h>
#include <time.h>

#include <tcp.h>

#include "prtserv.h"

struct asy_addr {  /* Async port addresses */
   int
      int_port_addr,  /* 8259 port address */
      int_mask_addr,  /* 8259 control address */
      int_int_level,  /* 8259 interrupt level of 8250 */
      com_int_addr,   /* 8250 interrupt address */
      com_port_addr,  /* 8250 data port address */
      com_ctrl_addr;  /* 8250 control port address */
   };

struct asy_port *COMsetup(apa, rxbsz,txbsz, com_bad, xon_ctl,l_echo)
struct asy_addr *apa;  /* Hardware addresses for port */
int rxbsz,   /* Size of receive buffer */
   txbsz,    /* Size of transmit buffer */
   com_bad,  /* Char to return on receive error */
   xon_ctl,  /* Non-zero for XON/XOFF flow control */
   l_echo;   /* Non-zero for half duplex */
{
   char *cp;
   register struct asy_port *p;
   unsigned char b;

   cp =malloc((unsigned)(15 + sizeof(struct asy_port) + rxbsz + txbsz));
#if defined(__LARGE__) | defined(__HUGE__) | defined(__COMPACT__)
   p = (struct asy_port *)(
      MK_FP(FP_SEG(cp), (FP_OFF(cp)+15) & 0xFFF0) );
#else
   p = (struct asy_port *)(((unsigned int)(cp)+15) & 0xFFF0);
#endif
   if (p == NULL) {
      printf("No memory for asy_port\n");
      return NULL;
      }
   p->apbase = cp;  /* Address to free() later */
   p->rxbmsk = rxbsz-1;  p->rxbmax = rxbsz-2;  p->rxbemp = rxbsz-32;
   p->txbmsk = txbsz-1;  p->txbmax = txbsz-2;
   p->combase = apa->com_port_addr;
   p->comctrl = apa->com_ctrl_addr;  p->comiir = p->combase+2;
   p->commdm = p->combase+4;  p->comline = p->combase+5;
   p->comadr = apa->com_int_addr;  p->portseg = 0;
   p->intctrl = apa->int_port_addr;  p->intmask = apa->int_mask_addr;
   p->intlev = apa->int_int_level;  p->eoici = apa->int_int_level | 0x60;
   p->mskci = b = 1 << apa->int_int_level;  p->enaci = 0xFF ^ b;
   p->xonctl = xon_ctl ? 0xFF : 0;
   p->rxbad = com_bad;  p->lecho = l_echo;
   p->txbuf = sizeof(struct asy_port) + rxbsz;
#ifdef DBTRACE  /* Trace buffer for ntasy */
   p->trctail = 0;
#endif
   return p;
   }

struct asy_port *COMopen(int comport)
{
   struct asy_port *port;
   static unsigned int
      bps[11]  = { 110, 150, 300, 600, 1200, 2400,
			     4800, 9600, 14400, 19200, 38400},
      bdiv[11] = {1047, 768, 384, 192,   96,   48,
		       24,   12,     8,     6,     3};
   int j, control;
   struct printer_i_s *isp = &printer_info[comport-1];
   static struct asy_addr aa;
   aa.int_port_addr = 0x0020;
   aa.int_mask_addr = 0x0021;
   aa.int_int_level = isp->int_level;
   aa.com_int_addr = 0x0020 + 4*isp->int_level;
   aa.com_port_addr = isp->address;
   aa.com_ctrl_addr = isp->address+1;
   port = COMsetup(&aa, 64,isp->bufsz, 0xFF, 1, 0);
	  /* rxbsz,txbsz, bad char, xonxoff, local_echo */
   if (port == NULL) return NULL;
   cominit(port);  /* So we can use comreg() */
   for (j = 10; j >= 0; --j)
      if (isp->ln_speed == bps[j]) break;
   if (j < 0) {
      printf("COM%d: Bad SPEED\n", comport);
      return NULL;
      }
   comreg(port, 1, 1, 0);  /* Disable interrupts */
   comreg(port, 4, 1, 0x10);  /* Set loopback */
   comreg(port, 3, 1, 0x80);  /* Set Divisor Latch Access Bit */
   comreg(port, 1, 1, 0x55);  /* Write Divisor Latch MSB */
   if (comreg(port, 1, 0, 0) != 0x55) {  /* Read it back */
      printf("COM%d: Hardware fault\n", comport);
      comfin(port);
      return NULL;
      }
   comreg(port, 1, 1, bdiv[j]>>8);  /* Set Divisor Latch MSB */
   comreg(port, 0, 1, bdiv[j]);  /* Set Divisor Latch LSB */
   switch (toupper(isp->ln_parity)) {
case 'E': control = 0x18;  /* even */
          break;
case 'O': control = 0x08;  /* odd */
          break;
case 'N': control = 0x00;  /* none */
          break;
case 'S': control = 0x38;  /* space */
          break;
case 'M': control = 0x28;  /* mark */
          break;
 default:
      printf("COM%d: Bad PARITY\n", comport);
      return NULL;
      }
   control ^= 0x03;  /* 8 data bits, 1 stop bit */
   comreg(port, 3, 1, control);  /* Set Line Ctrl reg (clear DLAB) */
   comreg(port, 0, 0, control);  /* Clear receive buffer */
   j = 10000;  while (--j) ;  /* Wait a while */
   comreg(port, 0, 0, control);  /* Clear receive buffer again */
   cominit(port);  /* Reinitialise com interrupt handling */
   return port;
   }

static char *c_parity[] = {"?", "None", "Odd", "Even", "Mark", "Space"};

int parity_v(char p)
{
   int j;
   for (j = 1; j <= 5; ++j) {
      if (toupper(p) == toupper(*c_parity[j])) return j;
      }
   return 0;
   }

void print_config(tcp_Socket *t)
{
   int i,j;
   struct printer_i_s *isp;
   char buf[80];
   char *heading =
      "COM  TCP  Printer    Speed Parity Buffer  XOFF  XON   Addr Int";
   sprintf(buf,
      "- - - - - - - - - -  %s  - - - - - - - - - -", server_name);
   put_msg(t,buf);  put_msg(t,heading);
   for (i = 0; i != 4; ++i) {
      isp = &printer_info[i];
      if (isp->ln_speed == 0) continue;
      sprintf(buf,"%3d %4d  %-12s%5d %-6s %5d %5d %4d   %04x %2d",
	 i+1, isp->tcpport_nbr,isp->printer_name,
	 isp->ln_speed,c_parity[parity_v(isp->ln_parity)],
	 isp->bufsz,isp->maxchar,isp->minchar,
	 isp->address,isp->int_level );
      put_msg(t,buf);
      }
   }

#define is_it( x ) if (!strcmp(name,x))

extern void (*usr_init)(char *name,char *value);  /* In src\pcconfig.c */
char *_inet_atoeth(char *src, unsigned char *eth);

static cfg_port = 1;  /* COM port being configured */

void prt_set_values(char *name,char *value)
{
   struct printer_i_s *isp = &printer_info[cfg_port-1];
   unsigned char temp[6];
   is_it("SERVERNAME") strcpy(server_name,value);
   else is_it("PASSWORD") strcpy(server_password,value);
   else is_it("COMPORT") {
      cfg_port = atoi(value);
      isp = &printer_info[cfg_port-1];
      isp->ln_speed = ln_speed_v;  /* Set default values */
      isp->ln_parity = ln_parity_v;  isp->bufsz= bufsz_v;
      isp->maxchar = maxchar_v;  isp->minchar = minchar_v;
      }
   else is_it("PRINTER") strcpy(isp->printer_name,value);
   else is_it("TCPPORT") isp->tcpport_nbr = atoi(value);
   else is_it("BUFFER") isp->bufsz = atoi(value);
   else is_it("CHARMAX") isp->maxchar = atoi(value);
   else is_it("CHARMIN") isp->minchar = atoi(value);
   else is_it("SPEED") isp->ln_speed = atoi(value);
   else is_it("PARITY") isp->ln_parity = value[0];
   else is_it("ADDRESS") {
      _inet_atoeth(value,temp);
      isp->address = temp[0] << 8 | temp[1];
      }
   else is_it("INTERRUPT") isp->int_level = atoi(value);
   }

void get_prt_config(void)
{
   int i,j;
   struct printer_i_s *isp;
   usr_init = prt_set_values;
   tcp_config("PRTSERV.CFG");
   }
