#include "collect.h"
#include "arrayob.h"

#define THIS    Collection
#define BASE    Object
DEFINE_CLASS(Collection,Object);

Object* Collection::add(const Object& ob)
{
    derivedClassResponsibility("add");
    return (Object*)&ob;
}

const Collection& Collection::addAll(const Collection& c)
{
    c.addContentsTo(*this);
    return c;
}

Collection& Collection::addContentsTo(Collection& ob) const
{
    derivedClassResponsibility("addContentsTo");
    return ob;
}

Object* Collection::remove(const Object& ob)
{
    derivedClassResponsibility("remove");
    return (Object*)&ob;
}

const Collection& Collection::removeAll(const Collection& c)
{
    DO(c,Object*,o) remove(*o); DONE
    return c;
}

void Collection::deepenShallowCopy() {}

Object*& Collection::at(int /*index*/) const
{
    static Object* dummy;
    derivedClassResponsibility("at");
    return dummy;
}
    
bool Collection::includes(const Object& ob) const
{
    return occurrencesOf(ob) != 0;
}

bool Collection::isEmpty() const { return size() == 0; }

unsigned Collection::occurrencesOf(const Object&) const
{
    derivedClassResponsibility("occurrencesOf"); return 0;
}

ArrayOb Collection::asArrayOb() const
{
    ArrayOb a(size());
    register Object** q = &(a.elem(0));
    DO(*this,Object*,o) *q++ = o; DONE
    return a;
}


Object* Collection::doNext(Iterator& /*pos*/) const
{
    derivedClassResponsibility("doNext"); return 0;
}

void Collection::doReset(Iterator& pos) const
{
    pos.index = 0;
    pos.ptr = (Object*)NULL;
    pos.num = 0;
}

Object* Collection::shallowCopy() const
{
    shouldNotImplement("shallowCopy"); return 0;
}
    
unsigned Collection::size() const
{
    derivedClassResponsibility("size"); return 0;
}

