/* ------------------------------ VBTARGET.H -------------------------
 *	Include file
 * ---------------------------------------------------------------- */

// ---- Global Variable
HANDLE			hmodDLL;			// DLL's Handle


// ---- Macro
#define OFFSETIN(struc,field)	  ((USHORT)&(((struc *)0)->field))

// ---- Bitmaps
#define IDBMP_TARGET		8000
#define IDBMP_TARGETDOWN	8001
#define IDBMP_TARGETMONO	8003
#define IDBMP_TARGETEGA 	8006

// ---- Type
#define TYPE_CIRCLES		0
#define TYPE_PLAIN			1
#define TYPE_BITMAP			2
#define TYPE_MAX			2

// ---- Control Structure
typedef struct _TARGET
{
	LONG		XPos;				// X Pos
	LONG		YPos;				// Y Pos
	SHORT		Type;				// Type
	HPIC		hpicPix;			// Picture
}
				TARGET;

typedef TARGET FAR *PTARGET;

// ---- Properties indices
#define IPROP_TARGET_CTLNAME		0
#define IPROP_TARGET_INDEX			1
#define IPROP_TARGET_BACKCOLOR		2
#define IPROP_TARGET_LEFT			3
#define IPROP_TARGET_TOP			4
#define IPROP_TARGET_WIDTH			5
#define IPROP_TARGET_HEIGHT			6
#define IPROP_TARGET_VISIBLE		7
#define IPROP_TARGET_ENABLED		8
#define IPROP_TARGET_PARENT			9
#define IPROP_TARGET_DRAGMODE		10
#define IPROP_TARGET_DRAGICON		11
#define IPROP_TARGET_TAG			12
#define IPROP_TARGET_TABINDEX		13
#define IPROP_TARGET_TABSTOP		14
#define IPROP_TARGET_BORDERSTYLEON	15
#define IPROP_TARGET_XPOS			16
#define IPROP_TARGET_YPOS			17
#define IPROP_TARGET_TYPE			18
#define IPROP_TARGET_PICTURE		19

// ---- Events Indices
#define IEVENT_TARGET_CHANGE		0
#define IEVENT_TARGET_CLICK			1
#define IEVENT_TARGET_DBLCLICK		2
#define IEVENT_TARGET_DRAGDROP		3
#define IEVENT_TARGET_DRAGOVER		4
#define IEVENT_TARGET_GOTFOCUS		5
#define IEVENT_TARGET_LOSTFOCUS		6

// ---- Declarations
LRESULT CALLBACK _export TargetCtlProc (HCTL, HWND, WORD, WORD, LONG);
