/*

_MALLOC.C - Windows global memory allocation program

*/


#pragma hdrfile _malloc.sym
#define STRICT
#include <windows.h>
#include <winstyle.h>
#include <dos.h>
#include <stdio.h>
#pragma hdrstop


#include <wmalloc.h>


static HINSTANCE hInstance;
static char *sMallocClassName = "MallocClass",
	    *sRegMessage = MALLOC_MESSAGE;
static UINT uRegMessage;


LRESULT CALLBACK MallocProc (HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);


#pragma argsused
int PASCAL WinMain (HINSTANCE hInst, HINSTANCE hPrev, LPSTR lpCmdLine,
		    int nCmdShow)
  {WNDCLASS wc;
   MSG msg;
   HWND hWnd;

   if (hPrev != NULL) return NULL;
   hInstance = hInst;

   wc.style = CS_GLOBALCLASS;
   wc.lpfnWndProc = MallocProc;
   wc.cbClsExtra = 0;
   wc.cbWndExtra = 0;
   wc.hInstance = hInst;
   wc.hIcon = NULL;
   wc.hCursor = NULL;
   wc.hbrBackground = NULL;
   wc.lpszMenuName = NULL;
   wc.lpszClassName = sMallocClassName;

   if (!RegisterClass (&wc)) return NULL;
   uRegMessage = RegisterWindowMessage (sRegMessage);

   hWnd = CreateWindow (sMallocClassName, "", WS_OVERLAPPED,
      0, 0, 0, 0, NULL, NULL, hInstance, NULL);
   if (hWnd == NULL) return NULL;
   ShowWindow (hWnd, SW_HIDE);

   while (GetMessage (&msg, NULL, 0, 0))
     {TranslateMessage (&msg);
      DispatchMessage (&msg);
     } // end while

   return (int) msg.wParam;
  } // end WinMain


LRESULT CALLBACK MallocProc (HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
  {HANDLE handle;
   void far *lpPtr;
   LPREALLOCSTRUCT lpRa;

   if (msg == uRegMessage)
     {return SendMessage ((HWND) wParam, WM_COMMAND, HIWORD (lParam),
	 MAKELPARAM (hWnd, MAL_ACK));
     } // endif

   switch (msg)
     {case MAL_ALLOC:
	 handle = GlobalAlloc (GMEM_DDESHARE | GHND, (DWORD) lParam);
	 if (handle == NULL) return NULL;
	 lpPtr = GlobalLock (handle);
	 return (LRESULT) lpPtr;

      case MAL_REALLOC:
	 lpRa = (LPREALLOCSTRUCT) lParam;
	 handle = (HANDLE) LOWORD (GlobalHandle (SELECTOROF (lpRa->lpPtr)));
	 if (handle == NULL) return NULL;
	 if (GlobalUnlock (handle)) return NULL;
	 handle = GlobalReAlloc (handle, lpRa->dwSize, GMEM_ZEROINIT);
	 if (handle == NULL) return NULL;
	 lpPtr = GlobalLock (handle);
	 return (LRESULT) lpPtr;

      case MAL_FREE:
	 handle = (HANDLE) LOWORD (GlobalHandle (SELECTOROF ((void far *) lParam)));
	 if (handle == NULL) return 0;
	 GlobalUnlock (handle);
	 GlobalFree (handle);
	 return 0;

      case WM_CLOSE:
	 return 0;
     } // end switch

   return DefWindowProc (hWnd, msg, wParam, lParam);
  } // end MallocProc



