/*

MET3.C - Writes a metafile with an optional placeable header.
         (C) 1993, Dennis CHUAH

*/


#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <metafile.h>


HMETAFILE WINAPI CopyMetaFileBetter (HMETAFILE hmfSrc, LPCSTR lpszFile,
                                     METAFILEHEADER far *lpMh)
  {HMETAFILE hMetafile;
   METAHEADER far *lpHeader;
   HGLOBAL handle;
   long filesize;
   HFILE hFile;
   long wrote;

   if (hmfSrc == NULL) return NULL;

   /* If specifying a memory metafile destination copy to a
      non-placeable metafile -- as memory metafiles cannot have
      a placeable header.  If the pointer to the METAFILEHEADER
      or the METAFILEHEADER is incorrect -- don't copy to a
      placeable metafile */
   if (lpszFile == NULL ||
       IsBadHugeReadPtr (lpMh, sizeof (METAFILEHEADER) ||
       lpMh->key != 0x9AC6CDD7L))
     {return CopyMetaFile (hmfSrc, lpszFile);
     }

   /* Get the metafile data */
   hMetafile = CopyMetaFile (hmfSrc, NULL);
   if (hMetafile == NULL) return NULL;
   handle = GetMetaFileBits (hMetafile);
   if (handle == NULL) return NULL;
   lpHeader = GlobalLock (handle);

   /* Get the size of the metafile.  Multiply by two as mtSize is in
      words */
   filesize = lpHeader->mtSize * 2;

   /* Open a disk file to place the metafile into */
   hFile = _lcreat (lpszFile, 0);
   if (hFile == HFILE_ERROR)
     {GlobalUnlock (handle);
      GlobalFree (handle);
      return NULL;
     }

   /* Write placeable header */
   wrote = _hwrite (hFile, lpMh, sizeof (METAFILEHEADER));
   if (wrote == -1 || wrote < sizeof (METAFILEHEADER))
     {_lclose (hFile);
      GlobalUnlock (handle);
      GlobalFree (handle);
      return NULL;
     }

   /* Write the rest of the metafile */
   wrote = _hwrite (hFile, lpHeader, filesize);
   if (wrote == -1 || wrote < filesize)
     {_lclose (hFile);
      GlobalUnlock (handle);
      GlobalFree (handle);
      return NULL;
     }

   _lclose (hFile);

   /* Return a handle to the new metafile */
   GlobalUnlock (handle);
   return (HMETAFILE) SetMetaFileBitsBetter ((HMETAFILE) handle);
  } // end CopyMetaFileBetter


