/*

TESTINS.C - Tests Instance function
            (C) 1993, Dennis CHUAH

*/

#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <toolhelp.h>
#include <string.h>
#include <stdio.h>
#include <instance.h>
#include "res.h"


/* Application specific messages */
#define WM_GETMODULES		(WM_USER + 0x100)
#define WM_SELCHANGED		(WM_USER + 0x101)
#define WM_GETHINSTANCE		(WM_USER + 0x102)


static char sBuffer[256];	// Temporary string storage


BOOL CALLBACK DlgProc (HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
static void _wm_getmodules (HWND hWnd);
static void _wm_selchanged (HWND hWnd);
static void _wm_gethinstance (HWND hWnd);
static void _wm_command (HWND hWnd, int iCtrlID, WORD wCode);


#pragma argsused
int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrev, LPSTR lpCmdLine,
                    int nCmdShow)
  {WNDCLASS wc;
   HWND hWnd;
   MSG msg;

   if (hPrev == NULL)
     {/* Register dialog class */
      wc.style = CS_HREDRAW | CS_VREDRAW;
      wc.lpfnWndProc = DefDlgProc;
      wc.cbClsExtra = 0;
      wc.cbWndExtra = DLGWINDOWEXTRA;
      wc.hInstance = hInstance;
      wc.hIcon = LoadIcon (hInstance, MAKEINTRESOURCE (MAIN));
      wc.hCursor = LoadCursor (NULL, IDC_ARROW);
      wc.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
      wc.lpszMenuName = NULL;
      wc.lpszClassName = MAINCLASS;
      RegisterClass (&wc);
     }

   /* Create modeless dialog box */
   hWnd = CreateDialog (hInstance, MAKEINTRESOURCE (MAIN), NULL, DlgProc);
   ShowWindow (hWnd, nCmdShow);
   UpdateWindow (hWnd);

   /* Message loop for modeless dialogbox */
   while (GetMessage (&msg, NULL, 0, 0))
     {if (!IsDialogMessage (hWnd, &msg))
        {TranslateMessage (&msg);
         DispatchMessage (&msg);
        }
     }

   return msg.wParam;
  } // end WinMain


/* Dialogbox procedure */
BOOL CALLBACK DlgProc (HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
  {switch (msg)
     {case WM_INITDIALOG:
         PostMessage (hWnd, WM_GETMODULES, 0, 0L);
         break;

      case WM_GETMODULES:
         _wm_getmodules (hWnd);
         break;

      case WM_SELCHANGED:
         _wm_selchanged (hWnd);
         break;

      case WM_GETHINSTANCE:
         _wm_gethinstance (hWnd);
         break;

      case WM_COMMAND:
         _wm_command (hWnd, wParam, HIWORD (lParam));
         break;

      case WM_DESTROY:
         PostQuitMessage (0);
         break;

      default:
         return FALSE;
     } // end switch

   return TRUE;
  } // end DlgProc


// Fills the listbox with a list of modules in the system
static void _wm_getmodules (HWND hWnd)
  {HWND hList;
   MODULEENTRY me;
   BOOL retval;

   // Clear the listbox contents
   hList = GetDlgItem (hWnd, IDLISTBOX);
   (void) ListBox_ResetContent (hList);

   // Get the first module in the system list
   me.dwSize = sizeof (MODULEENTRY);
   retval = ModuleFirst (&me);

   // Get the rest of the modules
   while (retval)
     {sprintf (sBuffer, "hModule: 0x%04X, Name: %s", me.hModule, me.szModule);
      (void) ListBox_AddString (hList, sBuffer);
      retval = ModuleNext (&me);
     }

   // Set the fist item in the listbox as the default
   (void) ListBox_SetCurSel (hList, 0);
   PostMessage (hWnd, WM_SELCHANGED, 0, 0L);
  } // end _wm_getmodules


// Fills the path and usage boxes with information pertaining to the
//   currently selected module
static void _wm_selchanged (HWND hWnd)
  {MODULEENTRY me;
   int selection;
   HWND hList, hPath, hUsage;
   HMODULE hModule;

   /* Get hModule from LISTBOX */
   hList = GetDlgItem (hWnd, IDLISTBOX);
   selection = ListBox_GetCurSel (hList);
   if (selection == LB_ERR) return;
   (void) ListBox_GetText (hList, selection, sBuffer);
   sscanf (sBuffer + 11, "%04X", &hModule);
   me.dwSize = sizeof (MODULEENTRY);

   // Get the HWND of other child controls
   hPath = GetDlgItem (hWnd, IDPATH);
   hUsage = GetDlgItem (hWnd, IDUSAGE);

   // Retrieve module information
   if (ModuleFindHandle (&me, hModule) == NULL)
     {Edit_SetText (hPath, "");
      Edit_SetText (hUsage, "");
     }
   else
     {Edit_SetText (hPath, me.szExePath);
      sprintf (sBuffer, "%d", me.wcUsage);
      Edit_SetText (hUsage, sBuffer);
     } // endif
  } // end _wm_selchanged


// Displays the hInstance message box
static void _wm_gethinstance (HWND hWnd)
  {MODULEENTRY me;
   int selection, len;
   HWND hList;
   HMODULE hModule;

   /* Get hModule from LISTBOX */
   hList = GetDlgItem (hWnd, IDLISTBOX);
   selection = ListBox_GetCurSel (hList);
   if (selection == LB_ERR) return;
   (void) ListBox_GetText (hList, selection, sBuffer);
   sscanf (sBuffer + 11, "%04X", &hModule);
   me.dwSize = sizeof (MODULEENTRY);

   // Retrieve module information
   if (ModuleFindHandle (&me, hModule) == NULL)
     {MessageBeep (0);
      return;
     }
   len = strlen (me.szExePath);
   /* Rudimentary way to check for a .DLL */
   if (stricmp (me.szExePath + len - 4, ".DLL") != 0)
     {sprintf (sBuffer, "hModule (0x%04X) does not refer to a .DLL", "",
         hModule);
      MessageBox (hWnd, sBuffer, "", MB_OK | MB_TASKMODAL);
      return;
     } // endif

   /* Display hInstance */
   sprintf (sBuffer, "hModule = 0x%04X\n"
                     "hInstance = 0x%04X",
            hModule, GetDllModuleInstance (hModule));
   MessageBox (hWnd, sBuffer, "", MB_OK | MB_TASKMODAL);
  } // end _wm_gethinstance


// Handles WM_COMMAND message from controls
static void _wm_command (HWND hWnd, int iCtrlID, WORD wCode)
  {switch (iCtrlID)
     {case IDOK:
      case IDCANCEL:
         EndDialog (hWnd, 0);
         break;

      case IDUPDATE:
         PostMessage (hWnd, WM_GETMODULES, 0, 0L);
         break;

      case IDGETHINSTANCE:
         PostMessage (hWnd, WM_GETHINSTANCE, 0, 0L);
         break;

      case IDLISTBOX:
         switch (wCode)
           {case LBN_DBLCLK:
               PostMessage (hWnd, WM_GETHINSTANCE, 0, 0L);
               break;

            case LBN_SELCHANGE:
               PostMessage (hWnd, WM_SELCHANGED, 0, 0L);
               break;
           }
         break;
     } // end switch
  } // end _wm_command



