{$S-,R-,V-,D-,T-}
{\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\}
{         TechnoJocks Turbo Toolkit v4.00            Released: Feb 1, 1988    }
{                                                                             }
{         Module: MiscTTT    --   a few miscellaneous procs                   }
{                                                                             }
{                       Copyright R. D. Ainsbury (c) 1986                     }
{\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\}

Unit MiscTTT;

Interface

Uses CRT,DOS;

Function Exist(Filename:string):boolean;
Function time: string;
Function Date: String;
Procedure PrintScreen;
Procedure Beep;
Function printer_ready :boolean;
Procedure FlushKeyBuffer;
Procedure Reset_Printer;

Implementation

Function Exist(Filename:string):boolean;
{returns true if file exists}
var Fil : file;
begin
 Assign(Fil,Filename);
 {$I-}
 Reset(Fil);
 Close(Fil);
 {$I+}
 Exist := (IOresult = 0);
end;  {Func Exist}

function time: string;
var
  hour,min,sec:     string[2];
  H,M,S,T : word;
begin
    GetTime(H,M,S,T);
    Str(H,Hour);
    Str(M,Min);
    Str(S,Sec);
    if S < 10 then            {pad a leading zero if sec is < 10 }
      sec := '0'+sec;
    if M < 10 then            {pad a leading zero if min is < 10 }
        min := '0'+min;
    if H > 12 then           { assign an a.m. or p.m. string }
    begin
       str(H - 12,hour);
       IF length(hour) = 1 then Hour := ' '+hour;
          time := hour+':'+min+':'+sec+' p.m.'
    end
    else
       time := hour+':'+min+':'+sec+' a.m.';
    if H = 12 then
       time := hour+':'+min+':'+sec+' p.m.';
end;

function Date: String;
type
  WeekDays = array[0..6]  of string[9];
  Months   = array[1..12] of string[9];
const
    DayNames   : WeekDays  = ('Sunday','Monday','Tuesday','Wednesday',
                              'Thursday','Friday','Saturday');
    MonthNames : Months    = ('January','February','March','April','May',
                              'June','July','August','September',
                              'October','November','December');
var
 Y,
 M,
 D,
 DayOfWeek : word;
 Year   : string;
 Day    : string;
begin
    GetDate(Y,M,D,DayofWeek);
    Str(Y,Year);
    Str(D,Day);
    Date := DayNames[DayOfWeek]+' '+MonthNames[M]+' '+Day+', '+Year;
end;


Procedure PrintScreen;
var Regpack : registers;
begin
    intr($05,regpack);
end;

procedure Beep;
begin
    sound(800);Delay(150);
    sound(600);Delay(100);
    Nosound;
end;


function printer_ready :boolean;
var Recpack : registers;
begin
    with recpack do
    begin
        ah := 2;
        dx := 0;
        intr($17,recpack);
        if ah = 144 then
           printer_ready := true
        else
           printer_ready := false;
    end;
end;

Procedure FlushKeyBuffer;
var Recpack : registers;
begin
    with recpack do
    begin
        Ax := ($0c shl 8) or 6;
        Dx := $00ff;
    end;
    Intr($21,recpack);
end;

Procedure Reset_Printer;

var address: integer absolute $0040:$0008;
             portno,delay : integer;

begin
    portno := address + 2;
    port[portno] := 232;
    for delay := 1 to 2000 do {nothing};
        port[portno] := 236;
end;

end.