 
program CommandLineDemo;
{This program shows how to access the command line in Turbo Pascal}
         var 
             CommandLine : string\127] absolute cseg: $0080;
             CopyOfLine : string \127];
         begin 
           CopyOfLine := CommandLine;
           writeln;
           writeln('This is the command line:');
           writeln(CopyOfLine);
         end.
 
 
 
PROGRAM FONTS(INPUT,OUTPUT);
CONST
      KEY1='TOGGLE'; KEY2=' '; KEY3='SHLT'; KEY4='SHRT'; KEY5='SHUP';
      KEY6='SHDN'; KEY7='CLR'; KEY8='FILL'; KEY9='#'; KEY10='MENU';
      KEYINS='+1'; KEYDEL='-1';
 
      MAXFONT=255; BIT1=0; BIT8=7;
 
      DOT=22; HLINE=205; VLINE=186; LUC=201; RUC=187; RLC=188; LLC=200;
 {                   M          :        I        ;        <        H    }
 
      { LOCATION OF FRAME. LUCR0 & LUCC0 LOCATE UPPER LEFT-HAND CORNER, WHILE
        HSTEP & VSTEP DETERMINE ITS SIZE. }
 
      LUCR0=3; LUCC0=4; HSTEP=2; VSTEP=1;
 
      MENUR=5; MENUC=40;
 
TYPE
    BIGSTR = STRING\80];
    BYTEBITS = BIT1..BIT8;
    PATTERN_SET = SET OF BYTEBITS; CHAR_PATTERN = ARRAY\1..8] OF PATTERN_SET;
    FILE_NAME_TYPE = STRING\14];
    CHAR_PATTERN_FILE = FILE OF CHAR_PATTERN;
    REG_LENGTH = (REG_WORD,REG_BYTE);
    REGPACK = RECORD CASE REG_LENGTH OF
                     REG_WORD: (AX,BX,CX,DX,BPX,SIX,DIX,DSX,ESX,FLAGX: INTEGER);
                     REG_BYTE: (AL,AH,BL,BH,CL,CH,DL,DH:BYTE;
                                BP,SI,DI,DS,ES,FLAG:INTEGER);
                     END;
 
   KEYS = (NOKEY,NOTFCT,
           F1,F2,F3,F4,F5,F6,F7,F8,F9,F10,
           HOME,UP,PGUP,LT,RT,EN,DN,PGDN,INS,DEL);
 
   ON_OFF = (ON,OFF);
 
VAR
    FONTS: ARRAY\0..MAXFONT] OF CHAR_PATTERN;
    FILENAME1,FILENAME2: FILE_NAME_TYPE;
    FILE1,FILE2:CHAR_PATTERN_FILE;
    FONTNO,FONTNR,FONTNC,XYR,XYC: INTEGER;
    KEY:KEYS; CH,CHX:CHAR;
    I,J:INTEGER;
    CURROW,CURCOL:INTEGER; { CURRENT LOGICAL CURSOR POSITION }
    QUIT:BOOLEAN;
 
{*************************** P R O C E D U R E S  **************************}
PROCEDURE REVERSE; { CHANGES OUTPUT TO REVERSE VIDEO }
          BEGIN TEXTCOLOR(BLACK); TEXTBACKGROUND(WHITE); END;
 
PROCEDURE NORMAL; { CHANGES OUTPUT TO NORMAL VIDEO }
          BEGIN TEXTCOLOR(WHITE); TEXTBACKGROUND(BLACK); END;
 
FUNCTION GETKEY(VAR CHX,CH:CHAR): KEYS;
CONST ESC=27;
BEGIN
IF KEYPRESSED THEN BEGIN  { READ KEYBOARD, AND MAP INTO 'KEYS' TYPE }
   READ(KBD,CH); CHX:=CHR(0);
   IF ORD(CH)=ESC THEN
      IF KEYPRESSED THEN BEGIN CHX:=CH; READ(KBD,CH) END;
 
   IF CHX=CHR(0) THEN GETKEY:=NOTFCT
   ELSE CASE CH OF
        ';':  GETKEY:=F1;
        '<':  GETKEY:=F2;
        '=':  GETKEY:=F3;
        '>':  GETKEY:=F4;
        '?':  GETKEY:=F5;
        '@':  GETKEY:=F6;
        'A':  GETKEY:=F7;
        'B':  GETKEY:=F8;
        'C':  GETKEY:=F9;
        'D':  GETKEY:=F10;
        'G':  GETKEY:=HOME;
        'H':  GETKEY:=UP;
        'I':  GETKEY:=PGUP;
        'K':  GETKEY:=LT;
        'M':  GETKEY:=RT;
        'O':  GETKEY:=EN;
        'P':  GETKEY:=DN;
        'Q':  GETKEY:=PGDN;
        'R':  GETKEY:=INS;
        'S':  GETKEY:=DEL;
        ELSE GETKEY:=NOTFCT;
        END { CASE }
    END {KEYPRESSED}
ELSE GETKEY:=NOKEY;
END; {GETKEY}
 
PROCEDURE BLINKVIDEO;
          BEGIN TEXTCOLOR(WHITE+BLINK) END;
 
FUNCTION LOCATE_ROW(I:INTEGER): INTEGER;
         BEGIN LOCATE_ROW:=LUCR0+VSTEP*I; END;
 
FUNCTION LOCATE_COL(I:BYTEBITS): INTEGER;
         BEGIN LOCATE_COL:=LUCC0+HSTEP*(I+1); END;
 
PROCEDURE GOTORC(ROW,COL:INTEGER);
          BEGIN GOTOXY(COL,ROW); END;
 
{**** REVERSE THE BITS IN A SET TYPE.  THE BIT NUMBERING FOR GRAPHICS
      PATTERNS IS A MIRROR IMAGE OF THE BIT NUMBERING FOR PASCAL SETS. }
PROCEDURE REVFONT(FONT:CHAR_PATTERN;VAR TFONT:CHAR_PATTERN);
VAR I:INTEGER;
 
{*} PROCEDURE REVSET(PSET:PATTERN_SET;VAR TPSET:PATTERN_SET);
    VAR I:BYTEBITS;
    BEGIN TPSET:=\];
          FOR I:=BIT1 TO BIT8 DO IF I IN PSET THEN TPSET:=TPSET + \BIT8-I];
    END;
 
BEGIN
   FOR I:=1 TO 8 DO REVSET(FONT\I],TFONT\I]);
END;
 
PROCEDURE DISPLAY_COORD(ROW:INTEGER;COL:BYTEBITS);
VAR X,Y:INTEGER;
BEGIN X:=WHEREX; Y:=WHEREY; GOTORC(XYR,XYC); REVERSE;
      WRITE(' ',ROW:1,',',COL+1:1,' '); NORMAL;
      GOTOXY(X,Y); END;
 
PROCEDURE DOT_CLR(I:INTEGER;J:BYTEBITS; CURSOR:ON_OFF);
          BEGIN FONTS\FONTNO]\I]:= FONTS\FONTNO]\I] - \J];
                GOTORC(LOCATE_ROW(I),LOCATE_COL(J));
                IF CURSOR=ON THEN BEGIN
                   DISPLAY_COORD(I,J); BLINKVIDEO; WRITE(CHR(DOT)); NORMAL; END
                ELSE WRITE(' ');
          END;
 
PROCEDURE DOT_SET(I:INTEGER;J:BYTEBITS; CURSOR:ON_OFF);
          BEGIN FONTS\FONTNO,I] := FONTS\FONTNO,I] + \J];
                GOTORC(LOCATE_ROW(I),LOCATE_COL(J));
                IF CURSOR=ON THEN BEGIN
                   DISPLAY_COORD(I,J); HIGHVIDEO END
                ELSE LOWVIDEO;
                WRITE(CHR(DOT));
          NORMAL;
          END;
 
PROCEDURE DOT_CURSOR(ROW:INTEGER;COL:BYTEBITS;CURSOR:ON_OFF);
          BEGIN GOTORC(LOCATE_ROW(ROW),LOCATE_COL(COL));
                IF COL IN FONTS\FONTNO,ROW] THEN BEGIN
                   IF CURSOR=ON THEN BEGIN
                      DISPLAY_COORD(ROW,COL); HIGHVIDEO END
                   ELSE LOWVIDEO; WRITE(CHR(DOT)) END
                ELSE IF CURSOR=ON THEN BEGIN
                        DISPLAY_COORD(ROW,COL);BLINKVIDEO; WRITE(CHR(DOT)); END
                     ELSE WRITE(' ');
           NORMAL;
           END;
 
PROCEDURE LINE25; { PRINTOUT THE LINE 25 INFORMATION }
VAR KEYNO:INTEGER;
  PROCEDURE WRITEKEY(KEY:BIGSTR);
            BEGIN NORMAL; KEYNO:=KEYNO+1;
            IF KEYNO<>1 THEN WRITE(' ');
            IF KEYNO<=10 THEN WRITE(KEYNO:1)
            ELSE IF KEYNO=11 THEN WRITE('INS') ELSE WRITE('DEL');
            REVERSE; WRITE(KEY); NORMAL; END;
 
BEGIN
   GOTOXY(1,25);  KEYNO:=0;
   WRITEKEY(KEY1); WRITEKEY(KEY2); WRITEKEY(KEY3); WRITEKEY(KEY4); WRITEKEY(KEY5);
   WRITEKEY(KEY6); WRITEKEY(KEY7); WRITEKEY(KEY8); WRITEKEY(KEY9); WRITEKEY(KEY10);
   WRITEKEY(KEYINS); WRITEKEY(KEYDEL);
END; {LINE25}
 
PROCEDURE DISPLAY_BORDER;
VAR I,RTCOL,BTMROW:INTEGER;
BEGIN
   HIGHVIDEO;
 
   { WRITE OUT CORNER CHARACTERS }
   GOTORC(LUCR0,LUCC0); WRITE(CHR(LUC));
   RTCOL:=LUCC0+9*HSTEP; GOTORC(LUCR0,RTCOL); WRITE(CHR(RUC));
   BTMROW:=LUCR0+9*VSTEP; GOTORC(BTMROW,LUCC0); WRITE(CHR(LLC));
   GOTORC(BTMROW,RTCOL); WRITE(CHR(RLC));
 
   { WRITE OUT LINES OF FRAME }
   FOR I:=LUCC0+1 TO RTCOL-1 DO BEGIN
       GOTORC(LUCR0,I); WRITE(CHR(HLINE)); GOTORC(BTMROW,I); WRITE(CHR(HLINE)); END;
   FOR I:=LUCR0+1 TO BTMROW-1 DO BEGIN
       GOTORC(I,LUCC0); WRITE(CHR(VLINE)); GOTORC(I,RTCOL); WRITE(CHR(VLINE)); END;
 
   { INITIALIZE THE SCREEN POSITION OF THE FONT NUMBER }
   FONTNR:=LUCR0-1; FONTNC:=RTCOL-4;
   XYR:=FONTNR; XYC:=LUCC0;
 
END; { DISPLAY_BORDER }
 
PROCEDURE DISPLAY_FONTNO(FONTNO:INTEGER);
          BEGIN REVERSE; GOTORC(FONTNR,FONTNC); WRITE(' ',FONTNO:3,' '); NORMAL; END;
 
PROCEDURE DISPLAY_FONTS(FONT:CHAR_PATTERN);
VAR I,ROW:INTEGER; COL,J:BYTEBITS;
BEGIN
    LOWVIDEO;
    FOR I:=1 TO 8 DO BEGIN
        ROW:=LOCATE_ROW(I); { GET SCREEN POSITION OF THE Ith ROW }
        FOR J:=BIT1 TO BIT8 DO BEGIN
            COL:=LOCATE_COL(J); { GET SCREEN POSITION OF THE Jth COLUMN }
            GOTORC(ROW,COL);
            IF J IN FONT\I] THEN WRITE(CHR(DOT)) ELSE WRITE(' ');
            END;
        END;
    CURROW:=1; CURCOL:=BIT1; DOT_CURSOR(CURROW,CURCOL,ON);
END; { DISPLAY A FONT }
 
PROCEDURE DISPLAY_FONT(FONTNO:INTEGER);
BEGIN DISPLAY_FONTS(FONTS\FONTNO]); END;
 
PROCEDURE MENUS;
LABEL TO_LBL,FROM_LBL,NUM_LBL;
CONST ROMOFS=$FA6E; ROMSEG=$F000;
VAR CMD:1..4; QROW:INTEGER;
    FONT:CHAR_PATTERN;
    SFONT,DFONT,CODE,NUM,I,STRPOS,XPOS,YPOS:INTEGER;
    INSTRING: STRING\80];
    ROM:BOOLEAN;
    PATTERN: PATTERN_SET; MEMBYTE:BYTE ABSOLUTE PATTERN;
    ANS:CHAR;
    FILENAME:FILE_NAME_TYPE;
 
  {*}PROCEDURE WRITE_OPTION(ROW:INTEGER;STR:BIGSTR);
  BEGIN
     GOTORC(ROW,MENUC); WRITE(STR); END;
  {*}PROCEDURE CLEAR_ROWS(ROW:INTEGER);
  VAR I:INTEGER;
  BEGIN
      FOR I:=ROW TO 24 DO BEGIN GOTORC(I,MENUC); CLREOL; END;
  END;
  {*}FUNCTION OPEN_INPUT_FILE(VAR FILEVAR:CHAR_PATTERN_FILE;FILENAME:FILE_NAME_TYPE):BOOLEAN;
  BEGIN
      OPEN_INPUT_FILE:=TRUE;
      ASSIGN(FILEVAR,FILENAME); {$I-} RESET(FILEVAR); {$I+}
      IF IORESULT <> 0 THEN BEGIN
         GOTORC(24,MENUC); WRITE('NON-EXISTENT FILE'); OPEN_INPUT_FILE:=FALSE END;
  END;
  {*}PROCEDURE STRIP_LBLANKS(VAR STR:BIGSTR);
     VAR I:INTEGER; DONE:BOOLEAN;
     BEGIN DONE:=FALSE;
           WHILE (STR\1]=' ') AND (NOT DONE) DO
                 BEGIN MOVE(STR\2],STR\1],LENGTH(STR)-1);
                       STR\0]:=CHR(ORD(STR\0])-1);
                       IF ORD(STR\0])<=0 THEN DONE:=TRUE; END;
        END; { STRIP }
 
BEGIN
     WRITE_OPTION(MENUR,'1. QUIT');
     WRITE_OPTION(MENUR+1,'2. READ FILE');
     WRITE_OPTION(MENUR+2, '3. WRITE FILE');
     WRITE_OPTION(MENUR+3,'4. COPY FONTS');
     WRITE_OPTION(MENUR+5,'COMMAND: ');
     READ(CMD);
     QROW:=MENUR+7; CLEAR_ROWS(QROW);
     CASE CMD OF
     1: BEGIN GOTORC(QROW,MENUC); WRITE('SURE ? (Y/N): ');
              READ(ANS); IF (ANS='y') OR (ANS='Y') THEN QUIT:=TRUE; END;
     2: BEGIN
          GOTORC(QROW,MENUC); WRITE('INPUT FILENAME:'); READ(FILENAME1);
          IF OPEN_INPUT_FILE(FILE1,FILENAME1) THEN BEGIN
             DFONT:=0; WHILE NOT EOF(FILE1) DO BEGIN
                              READ(FILE1,FONT);
                              REVFONT(FONT,FONTS\DFONT]);
                              DFONT:=(DFONT+1) MOD 256; END;
             CLOSE (FILE1); END;
          WRITE(' OK'); DISPLAY_FONT(FONTNO); END;
     3: BEGIN
          GOTORC(QROW,MENUC);
          IF LENGTH(FILENAME2)=0 THEN FILENAME2:=FILENAME1;
          WRITE('OUTPUT FILENAME (',FILENAME2,'): '); READ(FILENAME);
          IF LENGTH(FILENAME)<>0 THEN FILENAME2:=FILENAME;
          ASSIGN(FILE2,FILENAME2); REWRITE(FILE2);
          FOR SFONT:=0 TO MAXFONT DO BEGIN
              REVFONT(FONTS\SFONT],FONT); WRITE(FILE2,FONT); END;
          CLOSE(FILE2); WRITE(' OK'); END;
     4: BEGIN
TO_LBL:
           GOTORC(QROW,MENUC); WRITE('TO (',FONTNO:1,'):');
           DFONT:=FONTNO; {$I-} READ(DFONT); {$I+}
           IF IORESULT <> 0 THEN GOTO TO_LBL;
 
FROM_LBL:  GOTORC(QROW+1,MENUC); WRITE('FROM (<FONT#> | ROM <FONT#>):');
           XPOS:=WHEREX; YPOS:=WHEREY; READ(INSTRING);
           { PARSE INSTRING; IF CONTAINS WORD 'ROM' THEN COPY FROM ROM }
           STRPOS:=POS('ROM',INSTRING); ROM:=FALSE;
           IF STRPOS<>0 THEN BEGIN ROM:=TRUE; DELETE(INSTRING,STRPOS,3);END;
           STRIP_LBLANKS(INSTRING); VAL(INSTRING,SFONT,CODE);
           IF CODE<>0 THEN BEGIN
              GOTOXY(XPOS,YPOS); CLREOL; GOTO FROM_LBL; END;
 
NUM_LBL:
           GOTORC(QROW+2,MENUC); WRITE('NUM (1):'); NUM:=1; {$I-}READ(NUM); {$I+}
           IF IORESULT <> 0 THEN GOTO NUM_LBL;
 
           IF ROM THEN BEGIN
              MOVE(MEM\ROMSEG:(ROMOFS+SFONT*8)],FONTS\DFONT],NUM*8);
              FOR I:=DFONT TO DFONT+NUM-1 DO {REVERSE BIT PATTERNS}
                  REVFONT(FONTS\I],FONTS\I]);
              END
           ELSE MOVE(FONTS\SFONT],FONTS\DFONT],NUM*8);
           WRITE(' OK'); DISPLAY_FONT(FONTNO); END; { 4 }
 
      ELSE { DO NOTHING } END; { CASE }
END; { MENUS }
 
PROCEDURE PERFORM(KEY:KEYS); { MAJOR ROUTINE FOR EXECUTING THE NON-MENU COMMANDS }
VAR I:INTEGER; J:BYTEBITS;
BEGIN
    CASE KEY OF
    F1: { TURN ON BIT }
        IF CURCOL IN FONTS\FONTNO,CURROW] THEN DOT_CLR(CURROW,CURCOL,ON)
                                          ELSE DOT_SET(CURROW,CURCOL,ON);
    F2: { NOTHING IMPLEMENTED };
    F3: BEGIN { SHIFT LEFT }
        FOR J:=BIT1 TO BIT8 DO FOR I:=1 TO 8 DO
            IF J=BIT8 THEN DOT_CLR(I,J,OFF)
            ELSE IF J+1 IN FONTS\FONTNO,I] THEN DOT_SET(I,J,OFF)
                                           ELSE DOT_CLR(I,J,OFF);
        DOT_CURSOR(CURROW,CURCOL,ON); END;
    F4: BEGIN { SHIFT RIGHT }
        FOR J:=BIT8 DOWNTO BIT1 DO FOR I:=1 TO 8 DO
            IF J=BIT1 THEN DOT_CLR(I,J,OFF)
            ELSE IF J-1 IN FONTS\FONTNO,I] THEN DOT_SET(I,J,OFF)
                                           ELSE DOT_CLR(I,J,OFF);
        DOT_CURSOR(CURROW,CURCOL,ON); END;
    F5: BEGIN { SHIFT UP }
        FOR I:=1 TO 8 DO FOR J:=BIT1 TO BIT8 DO
            IF I=8 THEN DOT_CLR(I,J,OFF)
            ELSE IF J IN FONTS\FONTNO,I+1] THEN DOT_SET(I,J,OFF)
                                           ELSE DOT_CLR(I,J,OFF);
        DOT_CURSOR(CURROW,CURCOL,ON); END;
    F6: BEGIN { SHIFT DOWN }
        FOR I:=8 DOWNTO 1 DO FOR J:=BIT1 TO BIT8 DO
            IF I=1 THEN DOT_CLR(I,J,OFF)
            ELSE IF J IN FONTS\FONTNO,I-1] THEN DOT_SET(I,J,OFF)
                                           ELSE DOT_CLR(I,J,OFF);
        DOT_CURSOR(CURROW,CURCOL,ON); END;
    F7: BEGIN { CLEAR FONT }
        FOR I:=1 TO 8 DO FOR J:=BIT1 TO BIT8 DO DOT_CLR(I,J,OFF);
        CURROW:=1; CURCOL:=0; DOT_CURSOR(1,0,ON); END;
    F8: BEGIN { FILL FONT }
        FOR I:=1 TO 8 DO FOR J:=BIT1 TO BIT8 DO DOT_SET(I,J,OFF);
        CURROW:=1; CURCOL:=0; DOT_CURSOR(1,0,ON); END;
    F9: { GET NEW FONT NUMBER TO DISPLAY }
        BEGIN GOTORC(FONTNR,FONTNC); REVERSE; READ(FONTNO);
        DISPLAY_FONTNO(FONTNO); DISPLAY_FONT(FONTNO) END;
    INS:{ NEXT FONT }
        BEGIN FONTNO:=(FONTNO+1)MOD 256;
        DISPLAY_FONTNO(FONTNO); DISPLAY_FONT(FONTNO) END;
    DEL:{ PREVIOUS FONT }
        BEGIN FONTNO:=(FONTNO+255) MOD 256;
        DISPLAY_FONTNO(FONTNO); DISPLAY_FONT(FONTNO) END;
    F10:{ MENUS }
        MENUS;
    { CURSOR MOVEMENT ROUTINES }
    HOME: BEGIN DOT_CURSOR(CURROW,CURCOL,OFF);
                CURROW:=(CURROW+6)MOD 8+1; CURCOL:=(CURCOL+7)MOD 8;
                DOT_CURSOR(CURROW,CURCOL,ON); END;
    UP:   BEGIN DOT_CURSOR(CURROW,CURCOL,OFF);
                CURROW:=(CURROW+6)MOD 8+1;
                DOT_CURSOR(CURROW,CURCOL,ON); END;
    PGUP: BEGIN DOT_CURSOR(CURROW,CURCOL,OFF);
                CURROW:=(CURROW+6)MOD 8+1; CURCOL:=(CURCOL+1) MOD 8;
                DOT_CURSOR(CURROW,CURCOL,ON); END;
    LT:   BEGIN DOT_CURSOR(CURROW,CURCOL,OFF);
                CURCOL:=(CURCOL+7)MOD 8;
                DOT_CURSOR(CURROW,CURCOL,ON); END;
    RT:   BEGIN DOT_CURSOR(CURROW,CURCOL,OFF);
                CURCOL:=(CURCOL+1) MOD 8;
                DOT_CURSOR(CURROW,CURCOL,ON); END;
    EN:   BEGIN DOT_CURSOR(CURROW,CURCOL,OFF);
                CURROW:=CURROW MOD 8+1; CURCOL:=(CURCOL+7)MOD 8;
                DOT_CURSOR(CURROW,CURCOL,ON); END;
    DN:   BEGIN DOT_CURSOR(CURROW,CURCOL,OFF);
                CURROW:=CURROW MOD 8+1;
                DOT_CURSOR(CURROW,CURCOL,ON); END;
    PGDN: BEGIN DOT_CURSOR(CURROW,CURCOL,OFF);
                CURROW:=CURROW MOD 8+1; CURCOL:=(CURCOL+1) MOD 8;
                DOT_CURSOR(CURROW,CURCOL,ON); END;
    END;
END; { PERFORM }
 
PROCEDURE CENTER_WRITE(ROW:INTEGER; STR:BIGSTR);
VAR COL:INTEGER;
BEGIN COL:=41-LENGTH(STR) DIV 2; GOTOXY(COL,ROW); WRITE(STR); END;
 
BEGIN  {************** MAIN PROGRAM ********************}
    { SIGN ON }
    CLRSCR; REVERSE;
    CENTER_WRITE(8,' C R E A T E   F O N T S ');
    CENTER_WRITE(10,' B Y ');
    CENTER_WRITE(12, ' L .  J .  W I N K L E R ');
    CENTER_WRITE(16,' COPYRIGHT 1984 LAWRENCE J. WINKLER ');
    NORMAL; DELAY(4000); CLRSCR;
 
    { INITIALIZE VARIABLES }
    FOR FONTNO:=0 TO MAXFONT DO FOR I:=1 TO 8 DO FONTS\FONTNO,I]:=\];
    FONTNO:=0; CURROW:=1; CURCOL:=BIT1; QUIT:=FALSE;
    FILENAME1:=''; FILENAME2:='';
    LINE25;
    DISPLAY_BORDER;
    DISPLAY_FONTNO(FONTNO); DISPLAY_FONT(FONTNO);
 
    WHILE NOT QUIT DO
          IF KEYPRESSED THEN BEGIN
             KEY:=GETKEY(CHX,CH);
             IF (KEY <> NOKEY) AND (KEY <> NOTFCT) THEN PERFORM(KEY);
             END;
 
    GOTORC(24,10); WRITELN(' C R E A T E   F O N T S   TERMINATING');
 
END.
 
 
program ShowDateAndTime;
 
type
  Str = string\11];
 
var
 Hr,Mi,Se,Hu : integer;
 Yr,Mo,Da : integer;
 
function Date(var Year, Month, Day : integer): Str;
{returns date as string as well as components of date as integers}
 
type
  regpack = record
              ax,bx,cx,dx,bp,si,ds,es,flags: integer;
            end;
 
var
  recpack:       regpack;                {record for MsDos call}
  MonthString,
  DayString:     string\2];
  YearString:    string\4];
  dx,cx:         integer;
 
begin
  with recpack do
  begin
    ax := $2a shl 8;
  end;
  MsDos(recpack);                        { call function }
  with recpack do
  begin
    Year := cx;
    Day := dx mod 256;
    Month := dx shr 8;
    str(Year,YearString);                        {convert to string}
    str(Day,DayString);
    str(Month,MonthString);
  end;
  date := MonthString+'/'+DayString+'/'+YearString;
end;
 
 
function Time(var Hours, Minutes, Seconds, Hundredths : integer) : Str;
{Returns time as a string as well as the  components of the time as integers}
 
type
  regpack = record
              ax,bx,cx,dx,bp,si,ds,es,flags: integer;
            end;
 
var
  recpack:       regpack;                {record for MsDos call}
  HourString,MinuteString,
  SecondString,HundredthString : string\2];
  dx,cx:         integer;
 
begin
  with recpack do
  begin
    ax := $2c shl 8;
  end;
  MsDos(recpack);                        { call DOS function }
  with recpack do
  begin
    Hours := cx shr 8;
    Minutes := cx and $ff;
    Seconds := dx shr 8;
    Hundredths := dx and $ff;
    str(Hours, HourString);                {convert to string}
    str(Minutes, MinuteString);
    str(Seconds, SecondString);
    str(Hundredths, HundredthString);
  end;
  Time := HourString+':'+MinuteString+':'+SecondString+'.'+HundredthString;
end;
 
begin  {ShowDateAndTime}
  gotoxy(1,1);
  write('Time = ', time(Hr,Mi,Se,Hu));
  writeln('   ',Hr:2,Mi:3,Se:3,Hu:3);
  gotoxy(1,2);
  write('Date = ', date(Yr,Mo,Da));
  writeln('   ',Mo:2,Da:3,Yr:5)
end.
 
 
program DisplaySwitch(input,output);
var
   which : integer;
 
procedure SwitchToColor;
begin
memw\0000:$0410] := (mem\0000:$0410] and $00cf) or $0010;
textmode
end;
 
procedure SwitchToMono;
begin
memw\0000:$0410] := mem\0000:0410] or $0030;
textmode
end;
 
begin
repeat
write( ' Enter 0 for mono, 1 for color, 2 to stop: ');
readln( which);
if which = 0 then SwitchToMono;
if which = 1 then SwitchToColor;
until (which > 1);
end.
 
 
program HeapTest(input, output);
 
{This program demonstrates a bug in Turbo Pascal, version 2.
I put 10 integers on the stack, then release the stack and put
10 integers on the stack again.  In v. 1.0 we get the same results
each time, as we should.  In v. 2.0 we get different answers.  Apparently
the procedure Release(HeapTop) is not working properly.}
 
{The procedure ReleaseHeap is a replacement for Release(HeapTop) and
seems to work correctly}
 
type
  IntegerPointer = ^integer;
 
var
  Number :  ^integer;
  HeapTop : ^integer;
  Mem : real;
 
procedure ReleaseHeap (AHeapPointer : IntegerPointer);
var i : integer;
begin
  i := ((seg(heapptr^) - seg(AHeapPointer^)) shl 4) +
        (ofs(heapptr^) - ofs(AHeapPointer^));
  FreeMem(AHeapPointer,i);
end;
 
procedure report; {report memory available}
begin
    Mem := MemAvail;
    if (Mem < 0) then Mem := 65536.0+MemAvail;
    write('MemAvail = ',Mem:7:0, ' paragraphs ', Mem*16.0:9:0, ' bytes');
end;
 
procedure FillTheHeap(xc,yc,Depth : integer); {fill the heap to Depth}
var
  n : integer;
begin
for n := 1 to Depth do
    begin
    New(Number) ;
    Number^ := n;
    gotoxy(xc,yc);
    report;
    end
end;
 
begin
    Mark(HeapTop);  {Mark the top of the heap}
    gotoxy(5,20);
    report;               {1: Report memory available}
    FilltheHeap(5,21,10); {2: Fill the heap with 10 integers}
    ReleaseHeap(HeapTop); {Release the heap using the fix}
   {Release(HeapTop);      This does not work!}
    gotoxy(5,22);
    report;               {3: Report memory available; should be same as in 1}
    FilltheHeap(5,23,10); {4: Put 10 integers on again; should be same as in 2}
end.
 
 
procedure Menu(  xcoord, ycoord : integer; {where to start writing menu}
              var CommandNumber : integer; {which command was chosen}
               NumberOfCommands : integer; {how many commands there are}
                    var Command : CommandArray; { array\1..NumberOfCommands]
                                                  of string\40] giving the
                                                  names of the commands}
                      var Letter: AString);      {string\80] of command
                                                  abbreviations (lower case)}
 
var
  ch1,ch2 : char;
  i  : integer;
 
procedure Reverse;
begin
TextColor(black);
TextBackground(white)
end;
 
procedure Normal;
begin
TextColor(white);
TextBackground(black);
LowVideo
end;
 
procedure HighLightLine(CommandNumber : integer);
begin
gotoxy (xcoord,ycoord+CommandNumber);
Reverse;
write(command\CommandNumber]);
end;
 
procedure UnHighLight(CommandNumber : integer);
begin
gotoxy(xcoord,ycoord+CommandNumber);
Normal;
write(command\CommandNumber]);
end;
 
function WhichCommand(Ch : char) : integer;
var
  i : integer;
 
begin
  WhichCommand :=0;
  for i:=1 to NumberOfCommands do
  if((Ch1 = Letter\i]) or (Ch1 = UpCase(Letter\i])))
  then WhichCommand := i
end;
 
begin
for i := 1 to NumberOfCommands do
begin
  LowVideo;
  gotoxy(xcoord,ycoord+i);
  write(Command\i])
end;
CommandNumber := 1;
repeat
HighLightLine(CommandNumber);
read(Kbd,Ch1);
If (Ch1 = #27) then
     begin
     repeat read(Kbd,Ch2) until Ch2 in \'P','H'];
     UnHighLight(CommandNumber);
       case ch2 of
         'P' : CommandNumber := CommandNumber + 1;
         'H' : CommandNumber := CommandNumber - 1;
       end;
     If CommandNumber > NumberOfCommands then CommandNumber := 1;
     If CommandNumber < 1 then CommandNumber := NumberOfCommands;
     end
else if(WhichCommand(Ch1) > 0) then
     begin
       UnHighLight(CommandNumber);
       CommandNumber := WhichCommand(Ch1)
     end
until (eoln(Kbd));
Normal
end;
 
 
{----------------------------MENU - Write Command Menu ---------------------}
program MenuDemo(input,output);
 
{This program sets up a nice menu routine.  You can move through the menu
by using either the cursor keys or typing the one letter abbreviation.
The procedure returns the number of the command chosen.  The guts of the routine
are in the procedure MENU, which is self-contained.  The rest of the program
sets up the definitions and calls MENU.  This program was written by Hal R.
Varian.  Permission to copy and use is given to all. }
 
const
  MaxCommands = 5; {maximum number of commands}
 
type
   CommandArray = array\1..MaxCommands] of string\40];
   AString = string\80];
 
var
   Command : CommandArray;
   CommandNumber : integer;
   NumberOfCommands, xcoord, ycoord : integer;
   Letter : AString;
 
{$Imenu.pas}
 
procedure SetUpMenu;
begin
  Command\1] := 'Command 1';
  Command\2] := 'Command 2';
  Command\3] := 'Command 3';
  Command\4] := 'Command 4';
  Command\5] := 'Quit';
  Letter := '1234q';
  NumberOfCommands := 5;
end;
 
procedure CenterLine(InputString:AString ;ycoord : integer);
begin
gotoxy(40 - Length(InputString) div 2,ycoord);
write(InputString);
end;
 
procedure WriteALine(Symbol : char; ycoord : integer);
var i : integer;
begin
gotoxy(1,ycoord);
for i := 1 to 80 do
write(Symbol)
end;
 
procedure WriteTitle;
begin
LowVideo;
CenterLine('MENU demonstration program',1);
WriteALine('\',2);
end;
 
begin
  SetUpMenu;
  WriteTitle;
  repeat
  Menu(35,10,CommandNumber,NumberOfCommands,Command,Letter);
  gotoxy(28,22);
  write('The command chosen was ', CommandNumber);
  until(CommandNumber = 5)
end.
 
 
program polydemo(input,output);
 
VAR
   x_coord, y_coord : integer ;
   x_first, x_last, y_first, y_last : integer ;
   y_center, x_center, alpha, radius, aspect : real ;
   sides, incolor, backgrnd: integer;
   resp_1, resp_2 : char ;
 
procedure SwitchToColor;
begin
memw\0000:$0410] := (mem\0000:$0410] and $00cf) or $0010;
textmode
end;
 
{$Ipolygon.pas}
 
begin
switchtocolor;
repeat
   textmode(3);
   textbackground(blue);
   textcolor(red);
   writeln(' Hit Ctrl-Break to stop, any key to draw new polygon');
   write(' Enter x-center, y-center, alpha, color: ') ;
   readln(x_center, y_center, alpha, incolor) ;
   write(' Enter radius, aspect, number of sides: ');
   readln(radius, aspect, sides) ;
   alpha := alpha*pi/180 ;
   graphcolormode;
   graphbackground(blue);
   palette(0);
   polygon(x_center, y_center, alpha, radius, aspect,sides, incolor) ;
   repeat until(keypressed)
until (1 = 0)
 
end.
 
end.
 
 
procedure polygon(x_center, y_center, alpha, radius, aspect :real;
                  sides, incolor : integer) ;
 
{This procedure will draw a polygon.  Written by John Cross with slight
modifications by Hal Varian.}
 
VAR
   theta, beta, beta_one, beta_two : real ;
   x_one, y_one, x_two, y_two : real ;
   i, x_1in, x_2in, y_1in, y_2in : integer ;
   root, k_fraction, piece_1 : real ;
 
begin
theta := (2*pi)/sides ;
y_one := radius*sin(alpha) ;
x_one := radius*cos(alpha) ;
k_fraction := cos(theta) ;
beta_one := alpha ;
for i := 1 to sides do begin
   beta_two := beta_one + theta ;
   y_two := radius*sin(beta_two) ;
 
   if (abs(x_one) < 0.001) then begin
      x_two := radius*cos(pi/2 + theta) ;
      if (beta_one > pi) then x_two := -x_two
      end
   else begin
      piece_1 := y_one*(y_two - k_fraction*y_one) ;
      x_two := k_fraction*x_one - piece_1/x_one ;
   end ;
 
   y_1in := round(y_center + aspect*y_one) ;
   y_2in := round(y_center + aspect*y_two) ;
   x_1in := round(x_one + x_center) ;
   x_2in := round(x_two + x_center) ;
   draw(x_1in, y_1in, x_2in, y_2in, InColor) ;
   x_one := x_two ;
   y_one := y_two ;
   beta_one := beta_two ;
   end ;
end ;
 
 
program ScreenSave(input,output);
var
   ScreenBuffer : array\1..$4000] of byte absolute $b800:0000;
   {This is the address of the graphics screen buffer.  See BASIC manual
       discussion of BSAVE}
 
   ScreenImage  : array\1..$4000] of byte;
   {This is where we'll store the screen image.  We could also write
       a file to disk.}
 
procedure SwitchToColor;
begin
memw\0000:$0410] := (mem\0000:$0410] and $00cf) or $0010;
textmode
end;
 
procedure DrawIt; {Draw a bunch of random lines}
const mx = 319; my = 199;
var i,j:integer;
begin
j := 1;
for i := 1 to 50 do
    begin
    draw(random(mx),random(my),random(mx),random(my),j);
    j := j+1; if j > 3 then j := 1;
    end;
end;
 
procedure SaveScreen; {Copy the screenbuffer to the screen image array}
begin
move(ScreenBuffer\1], ScreenImage\1], $4000)
end;
 
 
procedure RestoreScreen; {Copy the screen image array to the screenbuffer}
begin
move(ScreenImage\1], ScreenBuffer\1], $4000)
end;
 
begin
SwitchToColor;
GraphColorMode;   {Clear the screen}
Palette(1);       {Set the palette}
DrawIt;           {Draw random lines}
SaveScreen;       {Save the screen}
GraphColorMode;   {Clear the screen}
Delay(200);       {Pause for a moment...}
Palette(1);       {Set the palette again}
RestoreScreen;    {Restore the screen}
DrawIt;           {Draw some more random lines}
end.
 
 
program WordCount;
type
  AString = string\80];
var
  NumberOfWords : integer;
  NameOfFile : AString;
  TextFile : text;
  NotThere : boolean;
 
procedure CheckFileName(var TextFilename : AString; var Error : boolean);
begin
  assign(TextFile,TextFileName);
  {$I-}
  Reset(TextFile);
  {$I+}
  if IOresult <> 0 then Error := true else Error := false;
end;
 
procedure GetFileName(var TextFileName : Astring; var Error : boolean);
var
  cline : string\15] absolute cseg: $0080;
begin
   TextFileName := copy(cline,2,14);
   CheckFileName(TextFileName, Error)
end;
 
procedure CountWords(var TextFile : text; var NumberOfWords : integer);
var
  ThisCh, LastCh : char;
  Letters : set of char;
begin
NumberOfWords := 0;
LastCh := ' ';
Letters := \'A'..'Z', 'a'..'z', '0'..'9', '''','-'];
while (not Eof(Textfile)) do
   begin
   read(TextFile, ThisCh);
   if ((LastCh in Letters) and not(ThisCh in letters)) then NumberOfWords :=
          NumberOfWords + 1;
   LastCh := ThisCh;
   end;
end;
 
begin
  GetFileName(NameOfFile, NotThere);
  if (NotThere) then
     begin
       writeln;
       write ('Enter name of file: ');
       readln(NameOfFile);
     end;
  assign(TextFile,NameOfFile);
  reset(TextFile);
  CountWords(TextFile, NumberOfWords);
  writeln;
  writeln(NumberOfWords,' words counted.');
end.
 
 
{$C-,I-,V-,R-,K-}
{++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{+                                                      +}
{+  PROGRAM TITLE:      Cross Reference Generator       +}
{+                                                      +}
{+  WRITTEN BY:         Peter Grogono                   +}
{+  DATE WRITTEN:       ?                               +}
{+                                                      +}
{+  SUMMARY:                                            +}
{+      1. Output Files:                                +}
{+         a. first output file is a numbered listing   +}
{+            of the input source                       +}
{+         b. second output file is cross reference     +}
{+            with each identifier followed by the      +}
{+            line numbers on which it appears.         +}
{+      2. Listing Device:                              +}
{+         The numbered source listing may optionally   +}
{+         be routed to the screen or printer (but not  +}
{+         both).                                       +}
{+                                                      +}
{+  MODIFICATION RECORD:                                +}
{+      17-APR-84       -Modified for Turbo Pascal so   +}
{+                       $ includes are supported       +}
{+                                                      +}
{+                                                      +}
{++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
PROGRAM XREFG2;
{ Cross Reference Generator }
CONST
        alfa_length     =  15;
        dflt_str_len    = 255;
        entrygap        =    0;   { # of blank lines between line numbers}
        heading         : string\23] = 'Cross-Reference Listing';
        headingsize     =    3;   {number of lines for heading}
        LLmax           = dflt_str_len;
        MaxOnLine       =   8;
        Maxlines        = MAXINT; {longest document permitted}
        MaxWordlen      = alfa_length;{longest word read without truncation}
        Maxlinelen      =   80;   {length of output line}
        MaxOnPage       =   60;   {size of output page}
        NumKeys         =   70;   {number of Pascal reseve words}
                                  {Read your Pascal manuals on this one!}
        NumberWidth     =    6;
        space           : char = ' ';
TYPE
        ALFA    = string\alfa_length];
        CHARNAME = (lletter, uletter, digit, blank, quote, atab,
                      EndOfLine, FileMark, otherchar );
        CHARINFO = RECORD
                     name : charname;
                     valu : CHAR
                   END;
        COUNTER = 1..Maxlines;
        pageindex = BYTE;
        Wordindex = 1..MaxWordlen;
        Queuepointer = ^Queueitem;
        Queueitem = RECORD
                        linenumber : counter;
                        NextInQueue: Queuepointer
                    END;
        EntryType = RECORD
                        Wordvalue : alfa;
                        FirstInQueue,
                        lastinQueue: Queuepointer
                     END;
        treepointer = ^node;
        node = RECORD
                 entry : EntryType;
                 left,
                 right : treepointer
               END;
        GenStr  = string\255];
VAR
  bell          : CHAR;
  fatal_error   : BOOLEAN;
  FILE_ID,                      { Input file name }
  PRN_ID,                       { basic file name + '.PRN' }
  New_ID        : string\20];   { basic file name + '.XRF' }
  form_feed     : CHAR;
  Key           : ARRAY\1..NumKeys] OF alfa;
  LISTING       : BOOLEAN;
  tab           : CHAR;
  WordTree      : treepointer;
  GAP           : char      ;
  Currentline: INTEGER;
  FOUT: TEXT; { print output file }
  XOUT: TEXT; { xref  output file }
 
 
PROCEDURE PAGE(VAR fx: TEXT);
BEGIN
  WRITELN(fx);
  WRITE(fx, form_feed);
END;
 
{ FUNCTYPE:                                                        }
{ Do binary search for keyword in 'key' list.  If found, return    }
{ TRUE, else FALSE.                                                }
Function Find_in_Reserve(var kword: alfa) : boolean;
Label Return;
Var
    low, high, mid : integer;
Begin
    low  := 1;
    high := NUMKEYS;
    while (low <= high) do begin
        mid := (low+high) div 2;
        if kword < key\mid] then
            high := mid - 1
        else if kword > key\mid] then
            low  := mid + 1
        else begin
            Find_in_Reserve := TRUE;
            goto Return;
            end;
        end;
    Find_in_Reserve := FALSE;
Return:
End;
 
PROCEDURE BuildTree(VAR tree: treepointer; VAR INFILE: GenStr);
VAR
  CurrentWord : alfa;
  FIN : TEXT; { local input file }
  currchar,                     { Current operative character }
  nextchar      : charinfo;     { Look-ahead character }
  flushing      : (KNOT, DBL, STD, LIT, SCANFN, SCANFN2);
  fname         : string\30];
  DoInclude     : boolean; { TRUE if we discovered include file }
  fbuffer       : string\255];  { Format buffer - before final Print }
  LineIn        : string\255];
  LineInLast    : string\255];
  cp            : 0..255;
  xeof,                 { EOF status AFTER a read }
  xeoln         : BOOLEAN;      { EOLN status after a read }
 
   PROCEDURE Entertree(VAR subtree: treepointer;
                           Word   : alfa;
                           line   :counter);
   VAR
     nextitem : Queuepointer;
   BEGIN
     IF subtree=nil THEN
       BEGIN {create a new entry}
         NEW(subtree);
         WITH subtree^ DO BEGIN
           left := nil;
           right := nil;
           WITH entry DO BEGIN
             Wordvalue := Word;
             NEW(FirstInQueue);
             LastinQueue := FirstInQueue;
             WITH FirstInQueue^ DO BEGIN
                linenumber := line;
                NextInQueue := nil;
             END;{WITH FirstInQueue}
           END;{WITH entry}
         END;{WITH subtree}
       END {create a new entry}
     ELSE {append a list item}
       WITH subtree^, entry DO
         IF Word=Wordvalue THEN
           BEGIN
             IF lastinQueue^.linenumber <> line THEN
                BEGIN
                  NEW(nextitem);
                  WITH Nextitem^ DO BEGIN
                    linenumber := line;
                    NextInQueue := nil;
                  END;{WITH}
                  lastinQueue^.NextInQueue := Nextitem;
                  lastinQueue := nextitem;
                END;
           END
         ELSE
           IF Word < Wordvalue THEN
             Entertree(left,Word,line)
           ELSE
             Entertree(right,Word,line);
   END;{Entertree}
 
Procedure ReadC({updating} VAR nextchar : charinfo;
                {returning}VAR currchar : charinfo );
Var
  Look          : char; { Character read in from File }
BEGIN   {+++ File status module. +++
   Stores file status "AFTER" a read.
   NOTE this play on words - after one char is
   actually "PRIOR TO" the next character               }
  if xeoln then begin
     LineInLast := LineIn;
     if (not EOF(FIN)) then begin
        readln(FIN, LineIn);
        cp := 0;
        xeoln := FALSE;
        end
      else
        xeof := TRUE;
      end;
  if cp >= length(LineIn) then begin
     xeoln := TRUE;
     xeof  := EOF(FIN);
     Look  := ' ';
     end
  else begin
     cp := cp + 1;
     Look := LineIn\cp];
     End;
        {+++ current operative character module +++}
  currchar := nextchar;
        {+++ Classify the character just read +++}
  WITH nextchar DO BEGIN{ Look-ahead character name module }
    IF xeof THEN
        name := FileMark
    ELSE IF xeoln THEN
        name := EndOfLine
    ELSE IF Look IN \'a'..'z'] THEN {lower case plus}
        name := lletter
    ELSE IF Look IN \'^','$','_','A'..'Z'] THEN {upper case}
        name := uletter
    ELSE IF Look IN \'0'..'9'] THEN {digit}
        name := digit
    ELSE IF Look = '''' THEN
        name := quote
    ELSE IF Look = TAB THEN
        name := atab
    ELSE IF Look = space THEN
        name := blank
    ELSE
        name := otherchar;
    CASE name of{ store character value module }
        EndOfLine,
        FileMark:       Valu := space;
        lletter:        Valu := upcase(look);       { Cnvrt to uppcase }
        ELSE            valu := look;
    END{ case name of };
  End{ Look-ahead character name module };
END; {of ReadC}
 
PROCEDURE GetL( VAR fbuffer :  GenStr      );
{++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{+      Get a line of text into users buffer.           +}
{+      Flushes comment lines:                          +}
{+      Flushes lines of Literals:  'this is it'        +}
{+      Ignores special characters & tabs:              +}
{+      Recognizes End of File and End of Line.         +}
{+                                                      +}
{+GLOBAL                                                +}
{+      flushing : (KNOT, DBL, STD, LIT, SCANFN);       +}
{+      LLmax   = 0..Max Line length;                   +}
{++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
VAR
  state : (scanning, terminal, overflow);
  sawdot : boolean;
BEGIN { GetL }
   fbuffer := '';
   fname := '';
   fatal_error := FALSE;
   state := scanning;
  REPEAT
    ReadC(nextchar, currchar);
    IF (length(fbuffer) >= LLmax) THEN{ exceeded length of buffer }
      BEGIN{ reset EOLN }
        fatal_error := TRUE;
        state := overflow;
        fbuffer := '';
        WRITE(bell);
        WRITELN('EXCEEDED LENGTH OF INPUT BUFFER');
      END
    ELSE
      BEGIN
        IF (currchar.name IN \FileMark,EndOfLine]) THEN
          state:=terminal{ END of line or END of file };
        CASE flushing of
            KNOT:
                CASE currchar.name of
                lletter, uletter, digit, blank:
                        BEGIN{ store }
                        fbuffer := concat(FBUFFER,CURRCHAR.VALU) ;
                        END;
                atab, quote, otherchar:
                        BEGIN{   Flush comments -convert
                                 tabs & other chars to spaces }
                        IF (currchar.valu='(') and (nextchar.valu='*')
                          THEN flushing := DBL
                        ELSE IF (currchar.valu='{') THEN
                           flushing := STD
                        ELSE IF currchar.name=quote THEN
                           flushing := LIT;
                        { convert to a space }
                           fbuffer := concat(fbuffer,GAP);
                        END;
                ELSE         { END of line -or- file mark }
                        fbuffer := concat(fbuffer,currchar.valu)
                END{ case currchar name of };
            DBL:  { scanning for a closing  - double comment }
                IF (currchar.valu ='*') and (nextchar.valu =')')
                  THEN flushing := KNOT;
            STD:  begin { scanning for a closing curley  }
                  IF currchar.valu = '}' THEN
                      flushing := KNOT;
{ Check if incl } if (currchar.valu = '$') and (nextchar.valu = 'I') then
                      flushing := SCANFN;
                  end;
            LIT:  { scanning for a closing quote }
                  IF currchar.name = quote THEN
                    flushing := KNOT;
            SCANFN: if (nextchar.valu<>' ') and (nextchar.valu<>TAB) then
                    begin
                    flushing := SCANFN2;
                    SAWDOT := FALSE;
                    end;
            SCANFN2: if (currchar.valu in \'A'..'Z','0'..'9','.'])
                     then begin
                        fname := concat(fname, currchar.valu);
                        if currchar.valu = '.' then SAWDOT := TRUE;
                        end
                     else begin
                        if length(fname) = 0 then  { Make sure we ignore $I-}
                           DoInclude := FALSE      { compiler directive }
                        else begin
                           if not SAWDOT then fname := Concat(fname, '.PAS');
                           DoInclude := TRUE;
                           end;
                        flushing := STD;
                        end;
        END{ flushing case }
      END{ ELSE }
  UNTIL (state<>scanning);
END; {of GetL}
 
PROCEDURE ReadWord;
{++++++++++++++++++++++++++++++++++++++++++++++++}
{+                                              +}
{+       Analyze the Line into "words"          +}
{+                                              +}
{++++++++++++++++++++++++++++++++++++++++++++++++}
LABEL   1;
VAR
  ix,           {temp indexer}
  idlen,        {length of the word}
  Cpos : BYTE; { Current Position pointer }
BEGIN{ ReadWord }
  Cpos := 1; { start at the beginning of a line }
  WHILE Cpos < length(fbuffer) DO
    BEGIN {Cpos<length(fbuffer)}
      WHILE (Cpos < length(fbuffer)) AND (fbuffer\Cpos]=space) DO
        Cpos:=Cpos + 1;    {--- skip spaces ---}
      idlen := 0;
      WHILE (Cpos < length(fbuffer)) AND (fbuffer\Cpos ] <> space) DO
        BEGIN{ accept only non-spaces }
          IF idlen < MaxWordlen THEN
            BEGIN
              idlen := idlen + 1;
              CurrentWord\idlen] := fbuffer\Cpos];
            END;
          Cpos := Cpos +1;
        END{ WHILE };
      CurrentWord\0] := chr(idlen);
      IF length(CurrentWord)=0 THEN {no word was found} GOTO 1;
 
      IF (not Find_in_Reserve(CurrentWord)) and    {check if reserved word}
         (not (CurrentWord\1] in \'0'..'9'])) then {or numeric constant}
         EnterTree(tree,CurrentWord,Currentline);
 
      1:{Here is no word <length of word=0>};
    END; {WHILE Cpos<length(fbuffer)}
END; {of Readword}
 
BEGIN{BuildTree}
   flushing := KNOT{ flushing };
   DoInclude := FALSE;
   xeoln := TRUE;
   xeof  := FALSE;
   LineIn := '';
   ASSIGN(FIN,INFILE);
   RESET(FIN);
   IF IOresult <> 0 THEN
      BEGIN
        WRITE(BELL);
        WRITELN('File ',INFILE,' not found !!!!!!');
        fatal_error := TRUE;
      END;
     nextchar.name := blank;       { Initialize next char to a space }
     nextchar.valu := space;
     ReadC({update}    nextchar,   { Initialize current char to space }
           {returning} currchar);  { First char from file in nextchar }
     WHILE ((currchar.name<>filemark) AND (NOT fatal_error)) DO
       BEGIN
         Currentline := Currentline + 1;
         GetL(fbuffer) { attempt to read the first line };
         Writeln(Fout, Currentline:6,': ',LineInLast);
         IF listing THEN Writeln(Currentline:6,': ',LineInLast)
         else if (Currentline mod 100) = 0 then
           writeln('ON LINE : ',Currentline:0);
         ReadWord; {Analyze the Text into single 'words' }
         if DoInclude then Begin
            BuildTree(tree, fname);  { recursively do include }
            DoInclude := FALSE;
            end;
       END; {While}
       close(FIN);
 
END; {of BuildTree}{CLOSE(PRN_ID);}
 
PROCEDURE PrintTree(tree: treepointer);
{
GLOBAL
        MaxOnLine   = max line references per line
        NumberWidth = field for each number
}
VAR
  pageposition: pageindex;
   PROCEDURE PrintEntry(subtree: treepointer;
                        VAR position: pageindex);
   VAR  ix: Wordindex;
        itemcount : 0..Maxlinelen;
        itemptr : Queuepointer;
        PROCEDURE PrintLine(VAR Currentposition: pageindex;
                                newlines: pageindex);
        VAR
          linecounter: pageindex;
        BEGIN
          IF (Currentposition + newlines) < MaxOnPage THEN
            BEGIN
                FOR linecounter:=1 TO newlines DO WRITELN(XOUT);
                Currentposition := Currentposition + newlines;
            END
          ELSE
            BEGIN
              PAGE(XOUT);
              WRITELN(XOUT,heading);
              FOR linecounter := 1 TO headingsize - 1 DO
                 WRITELN(XOUT);
              Currentposition := headingsize + 1;
            END
        END;{PrintLine}
 
   BEGIN{PrintEntry}
     IF subtree<>nil THEN
        WITH subtree^ DO BEGIN
          PrintEntry(left,position);
          PrintLine(position,entrygap + 1);
          WITH entry DO BEGIN
            FOR ix := 1 to length(WordValue) do WRITE(XOUT, WordValue\ix]);
            WRITE(XOUT, space:(MaxWordLen-length(WordValue)));
            itemcount := 0;
            itemptr := FirstInQueue;
            WHILE itemptr <> nil DO
              BEGIN
                itemcount := itemcount + 1;
                IF itemcount > MaxOnLine THEN
                  BEGIN
                    PrintLine(position,1);
                    WRITE(XOUT, space:MaxWordlen);
                    itemcount := 1;
                  END;
                WRITE(XOUT, itemptr^.linenumber: numberwidth);
                itemptr := itemptr^.NextInQueue;
              END;{WHILE}
          END; {WITH entry}
          PrintEntry(right,position);
        END; {WITH subtree^}
   END; {PrintEntry}
 
BEGIN{PrintTree}
  PagePosition := MaxOnPage;
  PrintEntry(tree,PagePosition);
END; {of PrintTree}{CLOSE(New_ID);}
 
FUNCTION ConnectFiles: boolean;
TYPE
  Linebuffer = string\80];
VAR
  ix  : BYTE;
BEGIN{ ConnectFiles }
  fatal_error := FALSE;
  ConnectFiles := TRUE;
   WRITELN('Enter Complete Filenames') ;
   WRITELN ;
   WRITE('Input File: ');
   READLN(FILE_ID);
   WRITELN;
   WRITE('Printed output: ');
   READLN(PRN_ID);
   WRITELN;
   WRITE('Cross-Reference output: ');
   READLN(NEW_ID);
   WRITELN;
   Assign(fout,PRN_ID);
   Rewrite(FOUT);
   if IOresult <> 0 then begin
      writeln('Could not open ',PRN_ID,' (print output file).');
      ConnectFiles := FALSE;
      fatal_error  := TRUE;
      end;
  assign(xout,NEW_ID);
  Rewrite(Xout) ;
  if IOresult <> 0 then begin
     writeln('Could not open ',NEW_ID,' (xref output file).');
     ConnectFiles := FALSE;
     fatal_error := TRUE;
     end;
END{ of ConnectFiles };
 
PROCEDURE Initialize;
VAR
  Ch: CHAR;
BEGIN
  bell := ^G; GAP := ' ' ;
  Currentline := 0;
  IF ConnectFiles THEN
    BEGIN
        Key\ 1] := 'ABSOLUTE';
        Key\ 2] := 'AND';
        Key\ 3] := 'ARRAY';
        Key\ 4] := 'ASSIGN';
        Key\ 5] := 'BEGIN';
        Key\ 6] := 'BOOLEAN';
        Key\ 7] := 'BYTE';
        Key\ 8] := 'CASE';
        Key\ 9] := 'CHAIN';
        Key\10] := 'CHAR';
        Key\11] := 'CHR';
        Key\12] := 'CLOSE';
        Key\13] := 'CONCAT';
        Key\14] := 'CONST';
        Key\15] := 'COPY';
        Key\16] := 'DELETE';
        Key\17] := 'DIV';
        Key\18] := 'DO';
        Key\19] := 'DOWNTO';
        Key\20] := 'ELSE';
        Key\21] := 'END';
        Key\22] := 'EOF';
        Key\23] := 'EOLN';
        Key\24] := 'EXECUTE';
        Key\25] := 'EXIT';
        Key\26] := 'EXTERNAL';
        Key\27] := 'FALSE';
        Key\28] := 'FILE';
        Key\29] := 'FILLCHAR';
        Key\30] := 'FOR';
        Key\31] := 'FORWARD';
        Key\32] := 'FUNCTION';
        Key\33] := 'GOTO';
        Key\34] := 'IF';
        Key\35] := 'IN';
        Key\36] := 'INLINE';
        Key\37] := 'INPUT';
        Key\38] := 'INTEGER';
        Key\39] := 'LABEL';
        Key\40] := 'LENGTH';
        Key\41] := 'MOD';
        Key\42] := 'NIL';
        Key\43] := 'NOT';
        Key\44] := 'OF';
        Key\45] := 'OR';
        Key\46] := 'ORD';
        Key\47] := 'OUTPUT';
        Key\48] := 'PACKED';
        Key\49] := 'PROCEDURE';
        Key\50] := 'PROGRAM';
        Key\51] := 'REAL';
        Key\52] := 'RECORD';
        Key\53] := 'REPEAT';
        Key\54] := 'SET';
        Key\55] := 'SHL';
        Key\56] := 'SHR';
        Key\57] := 'STRING';
        Key\58] := 'SUCC';
        Key\59] := 'TEXT';
        Key\60] := 'THEN';
        Key\61] := 'TO';
        Key\62] := 'TRUE';
        Key\63] := 'TYPE';
        Key\64] := 'UNTIL';
        Key\65] := 'VAR';
        Key\66] := 'WHILE';
        Key\67] := 'WITH';
        Key\68] := 'WRITE';
        Key\69] := 'WRITELN';
        Key\70] := 'XOR';
        tab     := CHR(9);  { ASCII Tab character }
        form_feed := CHR(12);  gap  := CHR(32);
        WRITE('List file to console (Y/N)?: ');
        READ(kbd,Ch);
        LISTING := ( (Ch='Y') OR (Ch='y') );
        WRITELN; WRITELN;
    END; {IF ConnectFiles}
END; {of Initialize}
 
BEGIN { Cross Reference }
  CLRSCR;
  WRITELN(' ':22, 'CROSS REFERENCE GENERATOR');
  WRITELN;WRITELN;WRITELN;WRITELN;
  Initialize;
  IF NOT fatal_error THEN
    BEGIN
      WordTree := NIL;          {Make the Tree empty}
      writeln('Pass 1 \Listing] Begins ...');BuildTree(WordTree, FILE_ID);
      close(FOUT) ;
      writeln('Pass 2 \Cross-Ref] Begins ...');PrintTree(WordTree);
      close(XOUT);
    END;
  WRITELN;
END. { Cross Reference }
 
