{TUG PDS CERT 1.01 (Pascal)

==========================================================================

                  TUG PUBLIC DOMAIN SOFTWARE CERTIFICATION

The Turbo User Group (TUG) is recognized by Borland International as the
official support organization for Turbo languages.  This file has been
compiled and verified by the TUG library staff.  We are reasonably certain
that the information contained in this file is public domain material, but
it is also subject to any restrictions applied by its author.

This diskette contains PROGRAMS and/or DATA determined to be in the PUBLIC
DOMAIN, provided as a service of TUG for the use of its members.  The
Turbo User Group will not be liable for any damages, including any lost
profits, lost savings or other incidental or consequential damages arising
out of the use of or inability to use the contents, even if TUG has been
advised of the possibility of such damages, or for any claim by any
other party.

To the best of our knowledge, the routines in this file compile and function
properly in accordance with the information described below.

If you discover an error in this file, we would appreciate it if you would
report it to us.  To report bugs, or to request information on membership
in TUG, please contact us at:

             Turbo User Group
             PO Box 1510
             Poulsbo, Washington USA  98370

--------------------------------------------------------------------------
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
File used with TPSTACK.PAS.

* ASSOCIATED FILES
TPSTACK.PAS
TPSTACK.ASM
TPSTACK.DOC
TPSTACK.OBJ

* CHECKED BY
DRM 08/08/88

* KEYWORDS
TURBO PASCAL V4.0

==========================================================================
}
;******************************************************
;                  TPSTACK.ASM 1.00
;               by TurboPower Software
;******************************************************

;****************************************************** Equates

Ofst            EQU     (WORD PTR 0)
Segm            EQU     (WORD PTR 2)

;****************************************************** Data

DATA    SEGMENT WORD PUBLIC

        EXTRN   OurSS : WORD            ;value of SS when program began
        EXTRN   LowestSP : WORD         ;lowest value for SP
        EXTRN   HeapHigh : DWORD        ;highest address pointed to by HeapPtr
        EXTRN   HeapPtr : DWORD
        EXTRN   CountsPerTick : WORD
        EXTRN   Counts : WORD

DATA    ENDS

;****************************************************** Code

CODE    SEGMENT BYTE PUBLIC

        ASSUME  CS:CODE,DS:DATA

        PUBLIC  ActualSaveInt8, Int8

ActualSaveInt8  DD      0               ;stores previous INT 8 handler

;****************************************************** Int8

;procedure Int8;
;Interrupt service routine used to monitor stack and heap usage

Flags   EQU     WORD PTR [BP+6]         ;position of pushed flags

Int8    PROC NEAR

        PUSH    BP                      ;set up stack frame
        MOV     BP,SP
        PUSH    AX                      ;save registers used
        PUSH    DI
        PUSH    DS
        MOV     AX,SEG DATA             ;set up DS
        MOV     DS,AX

        MOV     AX,SS                   ;make sure we're in the right SS
        CMP     AX,OurSS
        JNE     WrongSS

        LEA     DI,Flags                ;flags are where SS:SP was when the
        CMP     DI,LowestSP             ;interrupt occurred
        JNB     WrongSS
        MOV     LowestSP,DI

WrongSS:
        ;compare HeapPtr and HeapHigh; both are normalized
        MOV     AX,HeapPtr.Segm         ;HeapPtr into AX:DI
        MOV     DI,HeapPtr.Ofst
        CMP     AX,HeapHigh.Segm        ;if the segment is higher,
        JA      IsHigher                ;HeapPtr points higher
        JNE     Done                    ;check offsets only if segments equal
        CMP     DI,HeapHigh.Ofst        ;done if offset isn't higher
        JNA     Done

IsHigher:
        MOV     HeapHigh.Ofst,DI        ;HeapHigh = HeapPtr
        MOV     HeapHigh.Segm,AX

Done:   INC     Counts                  ;increment counter
        MOV     AX,CountsPerTick        ;see if we need to chain to old ISR
        CMP     Counts,AX
        JAE     Chain
        MOV     AL,20h                  ;send EOI to interrupt controller
        OUT     20h,AL
        POP     DS                      ;restore registers used
        POP     DI
        POP     AX
        POP     BP
        IRET

Chain:  MOV     Counts,0                ;reset counter
        POP     DS                      ;restore registers used
        POP     DI
        POP     AX
        POP     BP
        JMP     DWORD PTR ActualSaveInt8 ;chain to old INT $8 handler

Int8    ENDP

CODE    ENDS

        END
