{$debug-,$ocode-}

program build (output,infile,outfile);

var
  infile, outfile : text;
  done            : boolean;
  items_in        : word;
  items_out       : word;
  column          : word;
  max             : word;
  average         : word;
  refcount        : word;
  inline          : lstring (99);
  prior_item      : lstring (99);
  up_item         : lstring (99);
  up_prior_item   : lstring (99);
  item            : lstring (99);
  maxitem         : lstring (99);
  number          : lstring (99);
  

procedure initialize;
  begin
    writeln;
    writeln ('Index building program, (C) Copyright Peter Norton 1983');
    writeln;
    done := false;
    items_in := 0;
    items_out := 0;
    column    := 0;
    max       := 0;
    refcount  := 0;
    maxitem   := null;
    prior_item := ' ';
    prior_item [1] := chr (0);
    up_prior_item := ' ';
    up_prior_item [1] := chr (0);
    reset   (infile);
    rewrite (outfile);
  end;

procedure finish_up;
  begin
    writeln;
    writeln;
    writeln (items_in, ' individual references in');
    writeln (items_out,' separate index entries out');
    writeln (max,      ' greatest number of references, to ',maxitem);
    if items_out  = 0 then
      items_out  := 1;
    average := items_in div items_out;
    if ((items_in mod items_out) * 2) >= items_out then
      average := average + 1;
    writeln (average,  ' average references per index entry');
  end;

function digest : boolean;
  var [static]
    start, stop, i : word;   
  begin
    if inline.len < 7 then
      begin
        for i := 1 to inline.len do
          if inline [i] <> ' ' then
            begin
              writeln (chr(7));
              writeln;
              writeln ('Invalid input line: "',inline,'"');
              writeln;
              break;
            end;
        digest := false;
        return;
      end;
    if inline [7] <> '=' then
      begin
        writeln (chr(7));
        writeln;
        writeln ('Invalid input line: "',inline,'"');
        writeln;
        digest := false;
        return;
      end;
    digest := true;
    start := 1;
    for i := 1 to 5 do
      if inline [i] = '0' then
        start := i + 1
      else
        break;
    stop := 6;
    for i := 6 downto 2 do
      if inline [i] = ' ' then
        stop := i - 1
      else
        break;
    number := null;
    for i := start to stop do
      begin
        number.len := number.len + 1;
        number [number.len] := inline [i];
      end;
    item := null;
    for i := 8 to inline.len do
      begin
        item.len := item.len + 1;
        item [i-7] := inline [i];
      end;
    up_item := item;
    for i := 1 to up_item.len do
      if up_item [i] in ['a'..'z'] then
         up_item [i] := chr (ord(up_item [i]) - 32);
  end;

procedure process_line;
  begin
    readln (infile,inline);
    if not digest then
      return;
    items_in := items_in + 1;
    if up_item = up_prior_item then
      begin
        write (output, ', ');
        write (outfile,', ');
        column := column + 2;
      end
    else
      begin
        if refcount > max then
          begin
            max := refcount;
            maxitem := prior_item;
          end;
        refcount := 0;
        prior_item := item;
        up_prior_item := up_item;
        items_out := items_out + 1;
        writeln (output);
        writeln (outfile);
        writeln (output);
        writeln (outfile);
        write   (output, item);
        write   (outfile,item);
        write   (output, ' ');
        write   (outfile,' ');
        column := item.len + 1;
      end;
    if column > 72 then
      begin
        column := 5;
        writeln (output);
        writeln (outfile);
        write   (output, ' ':5);
        write   (outfile,' ':5);
      end;
    write (output, number);
    write (outfile,number);
    refcount := refcount + 1;
    column := column + number.len;
  end;

begin
  initialize;
  while not eof (infile) do
    process_line;
  finish_up;
end.