/*
 * Decompiled with CFR 0.152.
 */
package cc.gammasoft.date;

import cc.gammasoft.date.DateModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.text.DateFormat;
import javax.swing.JComponent;

public class StatusPanel
extends JComponent {
    private String todayString = DateFormat.getDateInstance(3).format(DateModel.TODAY.getTime());
    private Color ovalColor = Color.RED;
    private Color todayLabelColor = Color.WHITE;
    private Font todayLabelFont = new Font("Dialog", 0, 11);
    private Dimension dimension = new Dimension(15, this.todayLabelFont.getSize() + 2);
    private boolean isOvalVisible = true;

    StatusPanel() {
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(g2);
        if (this.isOvalVisible) {
            g2.setColor(this.ovalColor);
            g2.drawOval(1, 2, this.getHeight() + 3, this.getHeight() - 5);
        }
        g2.setColor(this.todayLabelColor);
        g2.setFont(this.todayLabelFont);
        g2.drawString(" " + this.todayString, this.getWidth() / 7, this.getHeight() - 3);
    }

    public Dimension getPreferredSize() {
        return this.dimension;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.todayLabelFont = font;
        this.dimension = new Dimension(15, font.getSize() + 2);
    }

    public void setForeground(Color todayLabelColor) {
        super.setForeground(todayLabelColor);
        this.todayLabelColor = todayLabelColor;
    }

    public void setBackground(Color background) {
        super.setBackground(background);
    }
}

