/*
 * Decompiled with CFR 0.152.
 */
package cc.gammasoft.date;

import cc.gammasoft.date.DateModel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MonthYearPanel
extends JPanel
implements ChangeListener {
    private SpinnerNumberModel yearModel;
    private JSpinner spinnerYear;
    private SpinnerListModel monthModel;
    private YearEditor yearEditor;
    private MonthEditor monthEditor;
    private JSpinner spinnerMonth = new JSpinner();
    private DateModel dateModel;
    public static final int SHORT_MONTH_NAME = 0;
    public static final int LONG_MONTH_NAME = 1;

    MonthYearPanel() {
        this.initComponent();
    }

    private void initComponent() {
        this.setLayout(new GridLayout());
        this.yearModel = new SpinnerNumberModel();
        this.spinnerYear = new JSpinner(this.yearModel);
        this.yearEditor = new YearEditor();
        this.monthModel = new SpinnerListModel();
        this.spinnerMonth.setModel(this.monthModel);
        this.monthEditor = new MonthEditor();
        this.spinnerYear.addChangeListener(this.yearEditor);
        this.spinnerYear.setEditor(this.yearEditor);
        this.spinnerMonth.addChangeListener(this.monthEditor);
        this.spinnerMonth.setEditor(this.monthEditor);
        this.yearModel.setMinimum(new Integer(0));
        this.add(this.spinnerMonth);
        this.add(this.spinnerYear);
        this.spinnerYear.setOpaque(true);
        this.spinnerMonth.setOpaque(true);
        this.spinnerYear.setBackground(Color.WHITE);
        this.spinnerMonth.setBackground(Color.WHITE);
    }

    public void setMonthNames(SimpleDateFormat dateFormat, int type) {
        if (dateFormat == null) {
            throw new NullPointerException("Null Date Format");
        }
        String[] name = type == 0 ? dateFormat.getDateFormatSymbols().getShortMonths() : dateFormat.getDateFormatSymbols().getMonths();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < name.length - 1) {
            list.add(name[i]);
            ++i;
        }
        this.monthModel.setList(list);
    }

    public JSpinner getYearSpinner() {
        return this.spinnerYear;
    }

    public JSpinner getMonthSpinner() {
        return this.spinnerMonth;
    }

    public void setDateModel(DateModel dateModel) {
        if (this.dateModel != null) {
            this.dateModel.removeChangeListener(this);
        }
        this.dateModel = dateModel;
        this.dateModel.addChangeListener(this);
    }

    public void stateChanged(ChangeEvent e) {
        Calendar calendar = this.dateModel.getValue();
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        this.yearModel.setValue(new Integer(calendar.get(1)));
        int index = calendar.get(2);
        this.monthModel.setValue(this.monthModel.getList().get(index));
    }

    public int getMonth() {
        return this.monthModel.getList().indexOf(this.monthModel.getValue());
    }

    public int getYear() {
        return this.yearModel.getNumber().intValue();
    }

    public SpinnerNumberModel getYearModel() {
        return this.yearModel;
    }

    public SpinnerListModel getMonthModel() {
        return this.monthModel;
    }

    public JLabel getYearEditor() {
        return this.yearEditor;
    }

    public JLabel getMonthEditor() {
        return this.monthEditor;
    }

    private class YearEditor
    extends JLabel
    implements ChangeListener {
        YearEditor() {
            this.setHorizontalAlignment(4);
            this.setFont(new Font("Arial", 0, 12));
            this.setBorder(null);
            this.setOpaque(false);
        }

        public void stateChanged(ChangeEvent e) {
            this.setText(MonthYearPanel.this.yearModel.getValue().toString());
        }

        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.paintComponent(g);
        }
    }

    private class MonthEditor
    extends JLabel
    implements ChangeListener {
        MonthEditor() {
            this.setFont(new Font("Arial", 0, 12));
        }

        public void stateChanged(ChangeEvent e) {
            this.setText(MonthYearPanel.this.monthModel.getValue().toString());
        }

        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.paintComponent(g);
        }
    }
}

