/*
 * Decompiled with CFR 0.152.
 */
package cc.gammasoft.date;

import cc.gammasoft.date.DateModel;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractDateModel
implements DateModel {
    private boolean isTrackSelectedValues = false;
    private Calendar calendar = Calendar.getInstance();
    private TreeSet selectedValues = new TreeSet(new SelectedValuesComparator());
    private ArrayList listeners = new ArrayList();
    private boolean isReselectionEnabled = false;

    public AbstractDateModel() {
        this.setValue(Calendar.getInstance());
    }

    public AbstractDateModel(Calendar calendar) {
        this.setValue(calendar);
    }

    public boolean setValue(Calendar calendar) {
        boolean addReturnValue = true;
        if (calendar == null) {
            this.calendar = null;
            this.fireValueChanged();
            return true;
        }
        Calendar oldCalendar = null;
        if (this.calendar != null) {
            oldCalendar = (Calendar)this.calendar.clone();
        }
        this.calendar = (Calendar)calendar.clone();
        if (this.isTrackSelectedValues) {
            addReturnValue = this.selectedValues.add(this.calendar);
        } else if (this.selectedValues.size() != 0) {
            if (this.selectedValues.contains(this.calendar)) {
                return false;
            }
            this.fireValueChanged();
            return true;
        }
        if (addReturnValue) {
            this.fireValueChanged();
        } else if (this.isReselectionEnabled) {
            this.fireValueChanged();
        } else {
            this.calendar = (Calendar)oldCalendar.clone();
            return false;
        }
        return true;
    }

    public boolean setValue(int year, int month, int date) {
        boolean addReturnValue = true;
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
        }
        Calendar oldCalendar = (Calendar)this.calendar.clone();
        this.calendar = (Calendar)this.calendar.clone();
        this.calendar.set(1, year);
        this.calendar.set(2, month);
        this.calendar.set(5, date);
        if (this.isTrackSelectedValues) {
            addReturnValue = this.selectedValues.add(this.calendar);
        } else if (this.selectedValues.size() != 0) {
            if (this.selectedValues.contains(this.calendar)) {
                return false;
            }
            this.fireValueChanged();
            return true;
        }
        if (addReturnValue) {
            this.fireValueChanged();
        } else {
            if (this.isReselectionEnabled) {
                this.fireValueChanged();
                return false;
            }
            this.calendar = (Calendar)oldCalendar.clone();
        }
        return true;
    }

    public boolean setValue(String sqlDate) {
        return this.setSQLDate(sqlDate);
    }

    public boolean setSQLDate(String SQLDate) {
        if (SQLDate == null || SQLDate.equals("")) {
            this.setValue((Calendar)null);
            return false;
        }
        Date date = Date.valueOf(SQLDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return this.setValue(calendar.get(1), calendar.get(2), calendar.get(5));
    }

    public boolean setTimestamp(String timeStamp) {
        if (timeStamp == null || timeStamp.equals("")) {
            this.setValue((Calendar)null);
            return false;
        }
        Timestamp timestamp = Timestamp.valueOf(timeStamp);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        return this.setValue(calendar);
    }

    public String getSQLDateValue() {
        if (this.getValue() == null) {
            return null;
        }
        return new Date(this.getValue().getTime().getTime()).toString();
    }

    public String getTimestampValue() {
        if (this.getValue() == null) {
            return null;
        }
        return new Timestamp(this.getValue().getTime().getTime()).toString();
    }

    public Calendar getValue() {
        if (this.calendar == null) {
            return null;
        }
        return (Calendar)this.calendar.clone();
    }

    public void enableSelectionTracking(boolean value) {
        this.isTrackSelectedValues = value;
        this.fireValueChanged();
    }

    public boolean isSelectionTrackingEnabled() {
        return this.isTrackSelectedValues;
    }

    public void enableReselection(boolean value) {
        this.isReselectionEnabled = value;
    }

    public boolean isReselectionEnabled() {
        return this.isReselectionEnabled;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public TreeSet getSelectedValues() {
        return this.selectedValues;
    }

    public void setSelectedValues(Calendar[] values) {
        if (this.selectedValues == null) {
            this.selectedValues = new TreeSet(new SelectedValuesComparator());
        } else {
            this.selectedValues.clear();
        }
        int i = 0;
        while (i < values.length) {
            this.selectedValues.add(values[i]);
            ++i;
        }
        this.fireValueChanged();
    }

    public void fireValueChanged() {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ChangeListener changeListener = (ChangeListener)it.next();
            changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    private class SelectedValuesComparator
    implements Comparator {
        private SelectedValuesComparator() {
        }

        public int compare(Object o1, Object o2) {
            Calendar value = (Calendar)o1;
            Calendar value1 = (Calendar)o2;
            if (value.get(1) == value1.get(1)) {
                AbstractDateModel.this.calendar;
                if (value.get(2) == value1.get(2) && value.get(5) == value1.get(5)) {
                    return 0;
                }
            }
            if (value.after(value1)) {
                return 1;
            }
            return -1;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }
    }
}

