/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.CharacterConverter;
import oracle.sql.converter.CharacterConverterSJIS;

class CharacterSetSJIS
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterSJIS";
    static final short MAX_7BIT = 127;
    static final short MIN_8BIT_SB = 161;
    static final short MAX_8BIT_SB = 223;
    static Class m_charConvSuperclass;

    CharacterSetSJIS(int n2, CharacterConverterSJIS characterConverterSJIS) {
        super(n2, characterConverterSJIS);
    }

    int decode(CharacterWalker characterWalker) throws SQLException {
        int n2 = characterWalker.bytes[characterWalker.next] & 0xFF;
        ++characterWalker.next;
        if (n2 > 223 || n2 > 127 && n2 < 161) {
            if (characterWalker.bytes.length > characterWalker.next) {
                n2 = n2 << 8 | characterWalker.bytes[characterWalker.next];
                ++characterWalker.next;
            } else {
                throw new SQLException("destination too small");
            }
        }
        return n2;
    }

    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        int n3 = 0;
        int n4 = 1;
        while (n2 >> n3 != 0) {
            n3 = (short)(n3 + 8);
            n4 = (short)(n4 + 1);
        }
        CharacterSet.need(characterBuffer, n4);
        while (n3 >= 0) {
            characterBuffer.bytes[characterBuffer.next++] = (byte)(n2 >> n3 & 0xFF);
            n3 = (short)(n3 - 8);
        }
    }

    static CharacterSetSJIS getInstance(int n2, CharacterConverter characterConverter) {
        if (characterConverter.getGroupId() == 4) {
            return new CharacterSetSJIS(n2, (CharacterConverterSJIS)characterConverter);
        }
        return null;
    }
}

