/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.ClobDBAccess;
import oracle.sql.DatumWithConnection;

public class CLOB
extends DatumWithConnection
implements Clob {
    public static final int MAX_CHUNK_SIZE = 32768;
    public static final int DURATION_SESSION = 1;
    public static final int DURATION_CALL = 2;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    ClobDBAccess m_dbaccess;
    private int m_dbChunkSize;
    private short csform;

    protected CLOB() {
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        this(oracleConnection, null);
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray) throws SQLException {
        super(byArray);
        if (byArray != null) {
            this.csform = (byArray[5] & 0xC0) == 64 ? (short)2 : (short)1;
        }
        DatumWithConnection.assertNotNull(oracleConnection);
        this.setPhysicalConnectionOf(oracleConnection);
        this.m_dbaccess = ((oracle.jdbc.internal.OracleConnection)oracleConnection).createClobDBAccess();
        this.m_dbChunkSize = -1;
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray, short s2) throws SQLException {
        this(oracleConnection, byArray);
        this.csform = s2;
    }

    public boolean isNCLOB() {
        boolean bl = this.csform == 2;
        return bl;
    }

    public long length() throws SQLException {
        return this.getDBAccess().length(this);
    }

    public String getSubString(long l2, int n2) throws SQLException {
        char[] cArray;
        int n3;
        if (n2 < 0 || l2 < 1L) {
            DBError.check_error(68, "getSubString");
        }
        String string = null;
        string = n2 == 0 ? new String() : ((n3 = this.getChars(l2, n2, cArray = new char[n2])) > 0 ? new String(cArray, 0, n3) : new String());
        return string;
    }

    public Reader getCharacterStream() throws SQLException {
        return this.getDBAccess().newReader(this, this.getBufferSize(), 0L);
    }

    public InputStream getAsciiStream() throws SQLException {
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), 0L);
    }

    public long position(String string, long l2) throws SQLException {
        return this.getDBAccess().position(this, string, l2);
    }

    public long position(Clob clob, long l2) throws SQLException {
        return this.getDBAccess().position(this, (CLOB)clob, l2);
    }

    public int getChars(long l2, int n2, char[] cArray) throws SQLException {
        return this.getDBAccess().getChars(this, l2, n2, cArray);
    }

    public Writer getCharacterOutputStream() throws SQLException {
        return this.getDBAccess().newWriter(this, this.getBufferSize(), 0L);
    }

    public OutputStream getAsciiOutputStream() throws SQLException {
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), 0L);
    }

    public byte[] getLocator() {
        return this.getBytes();
    }

    public void setLocator(byte[] byArray) {
        this.setBytes(byArray);
    }

    public int putChars(long l2, char[] cArray) throws SQLException {
        int n2 = this.getDBAccess().putChars(this, l2, cArray, cArray != null ? cArray.length : 0);
        return n2;
    }

    public int putChars(long l2, char[] cArray, int n2) throws SQLException {
        return this.getDBAccess().putChars(this, l2, cArray, n2);
    }

    public int putString(long l2, String string) throws SQLException {
        if (l2 < 1L) {
            DBError.check_error(68, "putString()");
        }
        int n2 = 0;
        if (string != null && string.length() != 0) {
            n2 = this.putChars(l2, string.toCharArray());
        }
        return n2;
    }

    public int getChunkSize() throws SQLException {
        if (this.m_dbChunkSize <= 0) {
            this.m_dbChunkSize = this.getDBAccess().getChunkSize(this);
        }
        return this.m_dbChunkSize;
    }

    public int getBufferSize() throws SQLException {
        int n2 = this.getChunkSize();
        int n3 = 0;
        n3 = n2 >= 32768 || n2 <= 0 ? 32768 : 32768 / n2 * n2;
        return n3;
    }

    public static CLOB empty_lob() throws SQLException {
        byte[] byArray = new byte[86];
        byArray[1] = 84;
        byArray[5] = 24;
        CLOB cLOB = new CLOB();
        cLOB.setShareBytes(byArray);
        return cLOB;
    }

    public boolean isEmptyLob() throws SQLException {
        return (this.shareBytes()[5] & 0x10) != 0;
    }

    public OutputStream getAsciiOutputStream(long l2) throws SQLException {
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), l2);
    }

    public Writer getCharacterOutputStream(long l2) throws SQLException {
        return this.getDBAccess().newWriter(this, this.getBufferSize(), l2);
    }

    public InputStream getAsciiStream(long l2) throws SQLException {
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), l2);
    }

    public Reader getCharacterStream(long l2) throws SQLException {
        return this.getDBAccess().newReader(this, this.getBufferSize(), l2);
    }

    public void trim(long l2) throws SQLException {
        if (l2 < 0L) {
            DBError.throwSqlException(68);
        }
        this.getDBAccess().trim(this, l2);
    }

    public static CLOB createTemporary(Connection connection, boolean bl, int n2) throws SQLException {
        if (connection == null || n2 != 1 && n2 != 2) {
            DBError.throwSqlException(68);
        }
        oracle.jdbc.internal.OracleConnection oracleConnection = OracleConnection.physicalConnectionWithin(connection);
        return CLOB.getDBAccess(oracleConnection).createTemporaryClob(oracleConnection, bl, n2);
    }

    public static void freeTemporary(CLOB cLOB) throws SQLException {
        if (cLOB == null) {
            return;
        }
        cLOB.freeTemporary();
    }

    public static boolean isTemporary(CLOB cLOB) throws SQLException {
        if (cLOB == null) {
            return false;
        }
        return cLOB.isTemporary();
    }

    public void freeTemporary() throws SQLException {
        this.getDBAccess().freeTemporary(this);
    }

    public boolean isTemporary() throws SQLException {
        return this.getDBAccess().isTemporary(this);
    }

    public void open(int n2) throws SQLException {
        this.getDBAccess().open(this, n2);
    }

    public void close() throws SQLException {
        this.getDBAccess().close(this);
    }

    public boolean isOpen() throws SQLException {
        return this.getDBAccess().isOpen(this);
    }

    public int setString(long l2, String string) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public int setString(long l2, String string, int n2, int n3) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public OutputStream setAsciiStream(long l2) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Writer setCharacterStream(long l2) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public void truncate(long l2) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public Object toJdbc() throws SQLException {
        return this;
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    public Reader characterStreamValue() throws SQLException {
        return this.getCharacterStream();
    }

    public InputStream asciiStreamValue() throws SQLException {
        return this.getAsciiStream();
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getAsciiStream();
    }

    public Object makeJdbcArray(int n2) {
        return new CLOB[n2];
    }

    public ClobDBAccess getDBAccess() throws SQLException {
        if (this.m_dbaccess == null) {
            if (this.isEmptyLob()) {
                DBError.throwSqlException(98);
            }
            this.m_dbaccess = this.getInternalConnection().createClobDBAccess();
        }
        return this.m_dbaccess;
    }

    public static ClobDBAccess getDBAccess(Connection connection) throws SQLException {
        return OracleConnection.physicalConnectionWithin(connection).createClobDBAccess();
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }

    public OracleConnection getConnection() throws SQLException {
        return super.getConnection();
    }
}

