/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;
import oracle.net.nt.NTAdapter;

public class TcpNTAdapter
implements NTAdapter {
    static final boolean DEBUG = false;
    int port;
    String host;
    String prot;
    private Socket socket;

    public TcpNTAdapter(String string) throws NLException {
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair = new NVFactory().createNVPair(string);
        if (nVPair == null) {
            throw new NLException(100);
        }
        NVPair nVPair2 = nVNavigator.findNVPair(nVPair, "PROTOCOL");
        NVPair nVPair3 = nVNavigator.findNVPair(nVPair, "HOST");
        NVPair nVPair4 = nVNavigator.findNVPair(nVPair, "PORT");
        if (nVPair2 == null || nVPair3 == null || nVPair4 == null) {
            throw new NLException(100);
        }
        this.prot = nVPair2.getAtom();
        this.host = nVPair3.getAtom();
        this.port = Integer.parseInt(nVPair4.getAtom());
        if (!this.prot.equals("TCP") && !this.prot.equals("tcp")) {
            throw new NLException(100);
        }
    }

    public void connect() throws IOException {
        this.socket = new Socket(this.host, this.port);
    }

    public void disconnect() throws IOException {
        this.socket.close();
        this.socket = null;
    }

    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }
}

