/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InputStream;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.DataPacket;
import oracle.net.ns.MarkerPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.Packet;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class NetInputStream
extends InputStream
implements SQLnetDef {
    protected Packet packet;
    protected DataPacket daPkt;
    protected MarkerPacket mkPkt;
    protected SessionAtts sAtts;
    private byte[] tmpBuf = new byte[1];

    public NetInputStream(SessionAtts sessionAtts) {
        this.sAtts = sessionAtts;
        this.packet = new Packet(sessionAtts);
    }

    public int available() throws IOException {
        return this.daPkt.availableBytesToRead;
    }

    protected void getNextPacket() throws IOException, NetException, BreakNetException {
        if (this.sAtts.dataEOF) {
            throw new NetException(202);
        }
        if (this.sAtts.nsOutputStream.available() > 0) {
            this.sAtts.nsOutputStream.flush();
        }
        this.packet.receive();
        this.processPacket();
    }

    protected void processPacket() throws IOException, NetException, BreakNetException {
        switch (this.packet.type) {
            case 6: {
                this.daPkt = new DataPacket(this.packet);
                break;
            }
            case 12: {
                this.mkPkt = new MarkerPacket(this.packet);
                this.sAtts.onBreakReset = this.mkPkt.isBreakPkt();
                throw new BreakNetException(500);
            }
            default: {
                throw new NetException(205);
            }
        }
    }

    public int read() throws IOException, NetException, BreakNetException {
        return this.read(this.tmpBuf) < 0 ? -1 : this.tmpBuf[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException, NetException, BreakNetException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException, NetException, BreakNetException {
        int n4 = 0;
        try {
            do {
                if (this.daPkt != null && this.daPkt.availableBytesToRead > 0) continue;
                this.getNextPacket();
            } while ((n4 += this.daPkt.getDataFromBuffer(byArray, n2 + n4, n3 - n4)) < n3);
        }
        catch (NetException netException) {
            if (netException.getErrorNumber() == 0) {
                return -1;
            }
            throw netException;
        }
        return n4;
    }
}

