/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBError;
import oracle.sql.CLOB;

public class OracleClobWriter
extends Writer {
    DBAccess db_access;
    DBConversion db_conversion;
    CLOB clob;
    long lob_offset;
    char[] charBuf;
    byte[] nativeBuf;
    int pos;
    int count;
    int chunkSize;
    boolean isClosed;

    public OracleClobWriter(CLOB cLOB) throws SQLException {
        this(cLOB, cLOB.getConnection().db_access.getDefaultStreamChunkSize() / 3, 1L);
    }

    public OracleClobWriter(CLOB cLOB, int n2) throws SQLException {
        this(cLOB, n2, 1L);
    }

    public OracleClobWriter(CLOB cLOB, int n2, long l2) throws SQLException {
        if (cLOB == null || n2 <= 0 || cLOB.getConnection() == null || l2 < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.db_access = cLOB.getConnection().db_access;
        this.db_conversion = cLOB.getConnection().conversion;
        this.clob = cLOB;
        this.lob_offset = l2;
        this.charBuf = new char[n2];
        this.nativeBuf = new byte[n2 * 3];
        this.count = 0;
        this.pos = 0;
        this.chunkSize = n2;
        this.isClosed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cArray, int n2, int n3) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            int n4 = n2;
            int n5 = n4 + Math.min(n3, cArray.length - n2);
            while (n4 < n5) {
                int n6 = Math.min(this.chunkSize - this.count, n5 - n4);
                System.arraycopy(cArray, n4, this.charBuf, this.count, n6);
                n4 += n6;
                this.count += n6;
                if (this.count < this.chunkSize) continue;
                this.flushBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.flushBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flushBuffer();
            this.isClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.count > 0) {
                    this.clob.putString((int)this.lob_offset, new String(this.charBuf, 0, this.count));
                    this.lob_offset += (long)this.count;
                    this.count = 0;
                }
            }
            catch (SQLException sQLException) {
                DBError.SQLToIOException(sQLException);
            }
        }
    }

    void ensureOpen() throws IOException {
        try {
            if (this.isClosed) {
                DBError.check_error(57, null);
            }
        }
        catch (SQLException sQLException) {
            DBError.SQLToIOException(sQLException);
        }
    }
}

