/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALYM;
import oracle.sql.JAVA_STRUCT;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORADataFactory;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;

public class OracleCallableStatement
extends OraclePreparedStatement
implements oracle.jdbc.internal.OracleCallableStatement {
    public OracleCallableStatement(OracleConnection oracleConnection, String string, int n2, int n3) throws SQLException {
        this(oracleConnection, string, n2, n3, 1003, 1007);
    }

    public OracleCallableStatement(OracleConnection oracleConnection, String string, int n2, int n3, int n4, int n5) throws SQLException {
        super(oracleConnection, string, n2, n3, n4, n5);
        this.statementType = 2;
        this.parseSqlKind();
        this.binds_out = this.connection.db_access.createDBDataSet(oracleConnection, this, n2, 2);
    }

    public synchronized void registerOutParameter(int n2, int n3, String string) throws SQLException {
        if (n3 != 2002 && n3 != 2008 && n3 != 2003 && n3 != 2006 && n3 != 2007) {
            DBError.throwSqlException(12, "sqlType=" + n3);
        }
        int n4 = this.get_internal_type(n3);
        int n5 = n2 - 1;
        this.checkBindTypes(false, n5, n4);
        this.resetBatch();
        if (n3 == 2002 || n3 == 2006 || n3 == 2008) {
            StructDescriptor structDescriptor = StructDescriptor.createDescriptor(string, this.connection);
            this.binds_out.setType(n5, n4, structDescriptor.getOracleTypeADT());
        } else if (n3 == 2003) {
            ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor(string, this.connection);
            this.binds_out.setType(n5, n4, arrayDescriptor.getOracleTypeCOLLECTION());
        } else if (n3 == 2007) {
            OpaqueDescriptor opaqueDescriptor = OpaqueDescriptor.createDescriptor(string, this.connection);
            this.binds_out.setType(n5, n4, (OracleTypeOPAQUE)opaqueDescriptor.getPickler());
        }
    }

    public synchronized void registerOutParameterBytes(int n2, int n3, int n4, int n5) throws SQLException {
        if (n3 == 2002 || n3 == 2008 || n3 == 2003 || n3 == 2006 || n3 == 2007) {
            DBError.throwSqlException(12, "sqlType=" + n3);
        }
        int n6 = n2 - 1;
        int n7 = this.get_internal_type(n3);
        this.checkBindTypes(false, n6, n7);
        this.resetBatch();
        int n8 = this.max_field_size;
        if (n7 == 96 || n7 == 1 || n7 == 999) {
            if (n5 != -1 && n8 < n5) {
                n8 = n5;
            }
            this.binds_out.setType(n6, 1, n3, n8, this.binds_out.getFormOfUse(n6));
        } else if (n7 == 8) {
            if (n5 != -1 && n8 < n5) {
                n8 = n5;
            }
            this.binds_out.setType(n6, 1, n3, n8, this.binds_out.getFormOfUse(n6));
        } else if (n7 == 24 || n7 == 23) {
            if (n5 != -1 && n8 < n5) {
                n8 = n5;
            }
            this.binds_out.setType(n6, 23, n3, n8, this.binds_out.getFormOfUse(n6));
        } else if (n7 == 102) {
            this.binds_out.setType(n6, 102, n3, 0, this.binds_out.getFormOfUse(n6));
            this.has_ref_cursors = true;
        } else {
            this.binds_out.setType(n6, n7, n3, n8, this.binds_out.getFormOfUse(n6));
        }
    }

    public synchronized void registerOutParameterChars(int n2, int n3, int n4, int n5) throws SQLException {
        int n6 = this.connection.db_access.getNlsRatio();
        if (n3 == 1 || n3 == 12) {
            this.registerOutParameterBytes(n2, n3, n4, n5 * n6);
        } else {
            this.registerOutParameterBytes(n2, n3, n4, n5);
        }
    }

    public synchronized void registerOutParameter(int n2, int n3, int n4, int n5) throws SQLException {
        this.registerOutParameterBytes(n2, n3, n4, n5 * this.connection.dataSizeScale);
    }

    private void resetBatch() {
        this.batch = 1;
    }

    public synchronized void setExecuteBatch(int n2) throws SQLException {
        this.resetBatch();
    }

    public synchronized int sendBatch() throws SQLException {
        return this.valid_rows;
    }

    public void registerOutParameter(int n2, int n3) throws SQLException {
        this.registerOutParameter(n2, n3, 0, -1);
    }

    public void registerOutParameter(int n2, int n3, int n4) throws SQLException {
        this.registerOutParameter(n2, n3, n4, -1);
    }

    public boolean wasNull() throws SQLException {
        return this.wasNullValue();
    }

    public String getString(int n2) throws SQLException {
        return this.getStringValue(false, n2);
    }

    public Datum getOracleObject(int n2) throws SQLException {
        return this.getOracleObjectValue(false, n2);
    }

    public ROWID getROWID(int n2) throws SQLException {
        return this.getROWIDValue(false, n2);
    }

    public NUMBER getNUMBER(int n2) throws SQLException {
        return this.getNUMBERValue(false, n2);
    }

    public DATE getDATE(int n2) throws SQLException {
        return this.getDATEValue(false, n2);
    }

    public INTERVALYM getINTERVALYM(int n2) throws SQLException {
        return this.getINTERVALYMValue(false, n2);
    }

    public TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        return this.getTIMESTAMPValue(false, n2);
    }

    public TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        return this.getTIMESTAMPTZValue(false, n2);
    }

    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        return this.getTIMESTAMPLTZValue(false, n2);
    }

    public REF getREF(int n2) throws SQLException {
        return this.getREFValue(false, n2);
    }

    public ARRAY getARRAY(int n2) throws SQLException {
        return this.getARRAYValue(false, n2);
    }

    public STRUCT getSTRUCT(int n2) throws SQLException {
        return this.getSTRUCTValue(false, n2);
    }

    public OPAQUE getOPAQUE(int n2) throws SQLException {
        return this.getOPAQUEValue(false, n2);
    }

    public CHAR getCHAR(int n2) throws SQLException {
        return this.getCHARValue(false, n2);
    }

    public Reader getCharacterStream(int n2) throws SQLException {
        return this.getCharacterStreamValue(false, n2);
    }

    public RAW getRAW(int n2) throws SQLException {
        return this.getRAWValue(false, n2);
    }

    public BLOB getBLOB(int n2) throws SQLException {
        return this.getBLOBValue(false, n2);
    }

    public CLOB getCLOB(int n2) throws SQLException {
        return this.getCLOBValue(false, n2);
    }

    public BFILE getBFILE(int n2) throws SQLException {
        return this.getBFILEValue(false, n2);
    }

    public boolean getBoolean(int n2) throws SQLException {
        return this.getBooleanValue(false, n2);
    }

    public byte getByte(int n2) throws SQLException {
        return this.getByteValue(false, n2);
    }

    public short getShort(int n2) throws SQLException {
        return this.getShortValue(false, n2);
    }

    public int getInt(int n2) throws SQLException {
        return this.getIntValue(false, n2);
    }

    public long getLong(int n2) throws SQLException {
        return this.getLongValue(false, n2);
    }

    public float getFloat(int n2) throws SQLException {
        return this.getFloatValue(false, n2);
    }

    public double getDouble(int n2) throws SQLException {
        return this.getDoubleValue(false, n2);
    }

    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        return this.getBigDecimalValue(false, n2, n3);
    }

    public byte[] getBytes(int n2) throws SQLException {
        return this.getBytesValue(false, n2);
    }

    public Date getDate(int n2) throws SQLException {
        return this.getDateValue(false, n2);
    }

    public Time getTime(int n2) throws SQLException {
        return this.getTimeValue(false, n2);
    }

    public Timestamp getTimestamp(int n2) throws SQLException {
        return this.getTimestampValue(false, n2);
    }

    public InputStream getAsciiStream(int n2) throws SQLException {
        return this.getAsciiStreamValue(false, n2);
    }

    public InputStream getUnicodeStream(int n2) throws SQLException {
        return this.getUnicodeStreamValue(false, n2);
    }

    public InputStream getBinaryStream(int n2) throws SQLException {
        return this.getBinaryStreamValue(false, n2);
    }

    public Object getObject(int n2) throws SQLException {
        return this.getObjectValue(false, n2);
    }

    public Object getAnyDataEmbeddedObject(int n2) throws SQLException {
        byte[] byArray;
        int n3 = n2 - 1;
        if (!this.connection.getProtocolType().equals("oci") && !this.connection.getProtocolType().equals("oci8")) {
            DBError.throwSqlException(23);
        }
        this.prepare_for_new_get(false, n2);
        DBDataSet dBDataSet = this.binds_out;
        int n4 = this.m_currentRank;
        OracleTypeADT oracleTypeADT = (OracleTypeADT)dBDataSet.getOtype(n3);
        if (dBDataSet.getType(n3) != 109 || oracleTypeADT == null || !oracleTypeADT.getSimpleName().equals("ANYDATA")) {
            DBError.throwSqlException(4);
        }
        if ((byArray = dBDataSet.getBytesItem(n3, n4)) == null || byArray.length == 0) {
            return null;
        }
        TypeDescriptor typeDescriptor = this.connection.db_access.getAnyDataEmbTypeDesc(this.dbstmt, dBDataSet, oracleTypeADT, n4, n3);
        Datum datum = null;
        int n5 = this.connection.db_access.getAnyDataEmbDataPos(this.dbstmt, n4, n3);
        int n6 = byArray.length - n5;
        byte[] byArray2 = new byte[n6];
        System.arraycopy(byArray, n5, byArray2, 0, n6);
        switch (typeDescriptor.getTypeCode()) {
            case 2003: {
                datum = new ARRAY((ArrayDescriptor)typeDescriptor, byArray2, this.connection);
                break;
            }
            case 2002: {
                datum = new STRUCT((StructDescriptor)typeDescriptor, byArray2, this.connection);
                break;
            }
            case 2007: {
                datum = new OPAQUE((OpaqueDescriptor)typeDescriptor, byArray2, this.connection);
                break;
            }
            case 2008: {
                datum = new JAVA_STRUCT((StructDescriptor)typeDescriptor, byArray2, this.connection);
                break;
            }
            default: {
                DBError.throwSqlException(4);
            }
        }
        return datum.toJdbc();
    }

    public Object getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        return this.getCustomDatumValue(false, n2, customDatumFactory);
    }

    public Object getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        return this.getORADataValue(false, n2, oRADataFactory);
    }

    public ResultSet getCursor(int n2) throws SQLException {
        return this.getCursorValue(false, n2);
    }

    public synchronized void clearParameters() throws SQLException {
        if (this.binds_out != null) {
            this.binds_out.clearItems();
        }
        super.clearParameters();
    }

    public Object getObject(int n2, Map map) throws SQLException {
        return this.getObjectValue(false, n2, map);
    }

    public Ref getRef(int n2) throws SQLException {
        return this.getREFValue(false, n2);
    }

    public Blob getBlob(int n2) throws SQLException {
        return this.getBLOBValue(false, n2);
    }

    public Clob getClob(int n2) throws SQLException {
        return this.getCLOBValue(false, n2);
    }

    public Array getArray(int n2) throws SQLException {
        return this.getARRAYValue(false, n2);
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        return this.getBigDecimalValue(false, n2, 0);
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        return this.getDateValue(false, n2, calendar);
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        return this.getTimeValue(false, n2, calendar);
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        return this.getTimestampValue(false, n2, calendar);
    }

    public void addBatch() throws SQLException {
        if (this.binds_out.getNoOfArgs() > 0) {
            DBError.throwSqlException(90, "Stored procedure with out or inout parameters cannot be batched");
        }
        super.addBatch();
    }

    private void cleanup() {
        if (this.connection.m_stmtClearMetaData && this.binds_out != null) {
            this.binds_out.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OracleCallableStatement oracleCallableStatement = this;
            synchronized (oracleCallableStatement) {
                super.close();
                this.cleanup();
            }
        }
    }

    public void registerOutParameter(String string, int n2) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void registerOutParameter(String string, int n2, int n3) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void registerOutParameter(String string, int n2, String string2) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public URL getURL(int n2) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public void setURL(String string, URL uRL) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setNull(String string, int n2) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setByte(String string, byte by) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setShort(String string, short s2) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setInt(String string, int n2) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setLong(String string, long l2) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setFloat(String string, float f2) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setDouble(String string, double d2) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setString(String string, String string2) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setDate(String string, Date date) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setTime(String string, Time time) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setObject(String string, Object object, int n2, int n3) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setObject(String string, Object object, int n2) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setObject(String string, Object object) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setCharacterStream(String string, Reader reader, int n2) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public String getString(String string) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public boolean getBoolean(String string) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return false;
    }

    public byte getByte(String string) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return 0;
    }

    public short getShort(String string) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return 0;
    }

    public int getInt(String string) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return 0;
    }

    public long getLong(String string) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return 0L;
    }

    public float getFloat(String string) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return 0.0f;
    }

    public double getDouble(String string) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return 0.0;
    }

    public byte[] getBytes(String string) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Date getDate(String string) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Time getTime(String string) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Object getObject(String string) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Object getObject(String string, Map map) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Ref getRef(String string) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Blob getBlob(String string) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Clob getClob(String string) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Array getArray(String string) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public URL getURL(String string) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public synchronized void registerIndexTableOutParameter(int n2, int n3, int n4, int n5) throws SQLException {
        if (n3 < 0) {
            DBError.throwSqlException(68, "maxLen < 0");
        }
        int n6 = this.get_internal_type(n4);
        this.checkPlsqlIndexTableBindTypes(false, n2 - 1, n3, n6, n5);
        this.resetBatch();
        this.binds_out.setPlsqlIndexTableType(n2 - 1, n3, n5, n6);
    }

    public synchronized Object getPlsqlIndexTable(int n2) throws SQLException {
        Datum[] datumArray = this.getOraclePlsqlIndexTable(n2);
        int n3 = this.binds_out.getPlsqlIndexTableType(n2 - 1);
        Object object = null;
        switch (n3) {
            case 1: 
            case 96: 
            case 999: {
                object = new String[datumArray.length];
                break;
            }
            case 2: 
            case 6: {
                object = new BigDecimal[datumArray.length];
                break;
            }
            case 23: {
                object = new byte[datumArray.length][];
                break;
            }
            case 12: {
                object = new Timestamp[datumArray.length];
                break;
            }
            default: {
                DBError.throwSqlException(1, "Invalid column type");
            }
        }
        int n4 = 0;
        while (n4 < ((Object[])object).length) {
            object[n4] = datumArray[n4] == null ? null : datumArray[n4].toJdbc();
            ++n4;
        }
        return object;
    }

    public synchronized Object getPlsqlIndexTable(int n2, Class clazz) throws SQLException {
        String string;
        Datum[] datumArray = this.getOraclePlsqlIndexTable(n2);
        if (clazz == null || !clazz.isPrimitive()) {
            DBError.throwSqlException(68);
        }
        if ((string = clazz.getName()).equals("byte")) {
            byte[] byArray = new byte[datumArray.length];
            int n3 = 0;
            while (n3 < datumArray.length) {
                byArray[n3] = datumArray[n3] != null ? datumArray[n3].byteValue() : (byte)0;
                ++n3;
            }
            return byArray;
        }
        if (string.equals("char")) {
            char[] cArray = new char[datumArray.length];
            int n4 = 0;
            while (n4 < datumArray.length) {
                cArray[n4] = datumArray[n4] != null ? (char)datumArray[n4].intValue() : (char)'\u0000';
                ++n4;
            }
            return cArray;
        }
        if (string.equals("double")) {
            double[] dArray = new double[datumArray.length];
            int n5 = 0;
            while (n5 < datumArray.length) {
                dArray[n5] = datumArray[n5] != null ? datumArray[n5].doubleValue() : 0.0;
                ++n5;
            }
            return dArray;
        }
        if (string.equals("float")) {
            float[] fArray = new float[datumArray.length];
            int n6 = 0;
            while (n6 < datumArray.length) {
                fArray[n6] = datumArray[n6] != null ? datumArray[n6].floatValue() : 0.0f;
                ++n6;
            }
            return fArray;
        }
        if (string.equals("int")) {
            int[] nArray = new int[datumArray.length];
            int n7 = 0;
            while (n7 < datumArray.length) {
                nArray[n7] = datumArray[n7] != null ? datumArray[n7].intValue() : 0;
                ++n7;
            }
            return nArray;
        }
        if (string.equals("long")) {
            long[] lArray = new long[datumArray.length];
            int n8 = 0;
            while (n8 < datumArray.length) {
                lArray[n8] = datumArray[n8] != null ? datumArray[n8].longValue() : 0L;
                ++n8;
            }
            return lArray;
        }
        if (string.equals("short")) {
            short[] sArray = new short[datumArray.length];
            int n9 = 0;
            while (n9 < datumArray.length) {
                sArray[n9] = datumArray[n9] != null ? (short)datumArray[n9].intValue() : (short)0;
                ++n9;
            }
            return sArray;
        }
        if (string.equals("boolean")) {
            boolean[] blArray = new boolean[datumArray.length];
            int n10 = 0;
            while (n10 < datumArray.length) {
                blArray[n10] = datumArray[n10] != null ? datumArray[n10].booleanValue() : false;
                ++n10;
            }
            return blArray;
        }
        DBError.throwSqlException(23);
        return null;
    }

    public synchronized Datum[] getOraclePlsqlIndexTable(int n2) throws SQLException {
        this.prepare_for_new_get(false, n2);
        if (this.binds_out.getType(n2 - 1) != 998) {
            DBError.throwSqlException(4);
        }
        return this.binds_out.getPlsqlIndexTableItem(n2 - 1, this.m_currentRank);
    }

    public synchronized void setFormOfUse(int n2, short s2) {
        this.binds_in.setFormOfUse(n2, s2);
        this.binds_out.setFormOfUse(n2, s2);
    }
}

