/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dbaccess;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBData;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBItem;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.StructDescriptor;

public class DBDataSetImpl
extends DBDataSet {
    private static int _MIN_ARG_COUNT = 1;
    private static final boolean DEBUG = false;
    protected OracleConnection m_connection;
    protected OracleStatement m_statement;
    private boolean m_dynamic = false;
    private int m_arrayDepth = 0;
    private boolean m_cleanedData = false;
    private byte m_sql_kind;
    private boolean m_sql_kind_cached;
    private int m_noOfArgs;
    protected int m_dataSetType;
    protected DBData[] data;
    protected DBType[] types;
    private DBItem[] m_last_bind_values = null;
    private boolean newDBType = false;
    private DBItem[] m_tmp_first_row_items = null;
    private DBType[] m_tmp_first_row_types = null;
    protected boolean m_first_row;
    private short[] form_of_use = null;

    private void init() {
        this.m_dynamic = false;
        this.m_first_row = true;
        this.m_noOfArgs = 0;
        this.data = null;
        this.types = null;
        this.m_cleanedData = false;
    }

    private void _transformToDynamic() {
        this.m_dynamic = true;
        this.m_arrayDepth = 0;
        if (!this.m_first_row) {
            this._cleanData();
            int n2 = 0;
            while (n2 < this.types.length) {
                this._allocData(n2);
                ++n2;
            }
        }
    }

    private final void _allocData(int n2) {
        if (this.data[n2] != null) {
            return;
        }
        this.data[n2] = this.m_dynamic ? new DBData() : new DBData(this.m_arrayDepth);
    }

    private final void _allocDataAndItems(int n2) throws SQLException {
        if (this.m_dynamic) {
            DBError.throwSqlException(89);
        }
        this._allocData(n2);
        this._allocItemsAndBuffers(n2);
    }

    private void _allocItemsAndBuffers(int n2) throws SQLException {
        int n3 = 0;
        int n4 = this.data[n2].getNItems();
        DBType dBType = this.types[n2];
        n3 = 0;
        while (n3 < n4) {
            this.data[n2].setItem(n3, this.m_connection.db_access.createDBItem(dBType));
            if (!dBType.is_stream && dBType.type != 109 && dBType.type != 111) {
                this.data[n2].getItem(n3).allocBuffer();
            }
            ++n3;
        }
    }

    public final void _cleanData() {
        if (this.data != null) {
            int n2 = this.data.length;
            int n3 = 0;
            while (n3 < n2) {
                if (this.data[n3] != null) {
                    this.data[n3].cleanup();
                    this.data[n3] = null;
                }
                ++n3;
            }
            this.m_cleanedData = true;
        }
    }

    public final DBItem _getDBItem(int n2, int n3) throws SQLException {
        if (this.data == null || this.data[n2] == null) {
            return null;
        }
        return this.data[n2].getItem(n3);
    }

    private final DBItem _getLastDBItem(int n2) throws SQLException {
        if (this.data == null || this.data[n2] == null) {
            return null;
        }
        if (this.m_dynamic) {
            int n3 = this.data[n2].getNItems();
            if (n3 == 0) {
                return null;
            }
            return this.data[n2].getItem(n3 - 1);
        }
        return this.data[n2].getItem(this.m_arrayDepth - 1);
    }

    private final void _setDBItem(DBItem dBItem, int n2, int n3) throws SQLException {
        if (this.data[n2] == null) {
            DBError.throwSqlException(44);
        }
        if (this.m_dynamic) {
            this.data[n2].addItem(dBItem);
        } else {
            this.data[n2].setItem(n3, dBItem);
        }
    }

    private final DBType _getDBType(int n2) {
        if (this.types != null && n2 >= 0 && n2 < this.types.length) {
            return this.types[n2];
        }
        return null;
    }

    private final void _setDBType(int n2, DBType dBType) {
        if (this.types != null && n2 >= 0 && n2 < this.types.length) {
            this.types[n2] = dBType;
        }
    }

    private void _alloc_tmp_binds(int n2, boolean bl) {
        if (this.m_tmp_first_row_types == null) {
            int n3 = Math.max(n2 + 1, _MIN_ARG_COUNT);
            if (bl) {
                this.m_tmp_first_row_items = new DBItem[n3];
            }
            this.m_tmp_first_row_types = new DBType[n3];
        } else if (n2 >= this.m_tmp_first_row_types.length) {
            Object[] objectArray;
            int n4 = this.m_tmp_first_row_types.length;
            n4 = Math.max(n2 + 1, n4);
            if (bl) {
                objectArray = new DBItem[2 * n4];
                System.arraycopy(this.m_tmp_first_row_items, 0, objectArray, 0, this.m_tmp_first_row_items.length);
                this.m_tmp_first_row_items = objectArray;
                objectArray = null;
            }
            objectArray = new DBType[2 * n4];
            System.arraycopy(this.m_tmp_first_row_types, 0, objectArray, 0, this.m_tmp_first_row_types.length);
            this.m_tmp_first_row_types = objectArray;
            objectArray = null;
        }
    }

    protected DBType _getBindDBType(int n2) {
        DBType dBType = null;
        if (this.m_first_row) {
            if (n2 + 1 > this.m_noOfArgs) {
                this.m_noOfArgs = n2 + 1;
            }
            this._alloc_tmp_binds(n2, true);
            dBType = this.m_tmp_first_row_types[n2];
        } else {
            dBType = this._getDBType(n2);
        }
        return dBType;
    }

    protected DBType _createOrGetBindDBType(int n2, int n3) throws SQLException {
        DBType dBType = this._getBindDBType(n2);
        if (dBType == null || dBType.type != n3) {
            this.newDBType = true;
            if (!this.m_sql_kind_cached) {
                this.m_sql_kind = this.m_statement.getSqlKind();
                this.m_sql_kind_cached = true;
            }
            dBType = this.m_sql_kind == 1 ? this.m_connection.db_access.createDBType(n3, this.m_dataSetType == 1, true) : this.m_connection.db_access.createDBType(n3, true, this.getFormOfUse(n2));
        } else {
            this.newDBType = false;
        }
        return dBType;
    }

    protected DBItem _createOrGetDBItem(int n2, DBType dBType, int n3) throws SQLException {
        DBItem dBItem = null;
        if (this.m_first_row) {
            dBItem = this.m_connection.db_access.createDBItem(dBType);
        } else {
            dBItem = this._getDBItem(n2, n3);
            DBItem dBItem2 = null;
            dBItem2 = n3 == 0 ? this._getLastDBItem(n2) : this._getDBItem(n2, n3 - 1);
            if (dBItem == null || dBItem2 != null && dBItem2.equals(dBItem)) {
                dBItem = this.m_connection.db_access.createDBItem(dBType);
            } else {
                dBItem.reinitialize(dBType.max_length);
            }
        }
        return dBItem;
    }

    protected void _setBindDBItem(int n2, DBItem dBItem) {
        if (this.m_first_row) {
            this.m_tmp_first_row_items[n2] = dBItem;
        } else {
            this.m_last_bind_values[n2] = dBItem;
        }
    }

    protected void _setBindDBType(int n2, DBType dBType) {
        dBType.FormOfUse = this.getFormOfUse(n2);
        dBType.ncs = dBType.isNType() ? (int)this.m_connection.conversion.getNCharSet() : (int)this.m_connection.conversion.getDbCharSet();
        if (this.m_first_row) {
            if (this.m_tmp_first_row_types[n2] == null) {
                this.m_tmp_first_row_types[n2] = dBType;
            }
        } else {
            this._setDBType(n2, dBType);
        }
    }

    private final void _setRowItems(int n2, DBItem dBItem) throws SQLException {
        if (this.m_dynamic) {
            DBError.throwSqlException(89);
        }
        this.data[n2].setItem(0, dBItem);
        int n3 = 1;
        while (n3 < this.m_arrayDepth) {
            DBItem dBItem2 = dBItem.clone(this.types[n2], this.m_connection.db_access);
            this.data[n2].setItem(n3, dBItem2);
            ++n3;
        }
    }

    private void _bindsRowCompleted(int n2) throws SQLException {
        int n3;
        if (n2 == -1 && !this.m_dynamic) {
            this._transformToDynamic();
        }
        if (this.m_first_row) {
            this.m_first_row = false;
            this.data = new DBData[this.m_noOfArgs];
            this.types = new DBType[this.m_noOfArgs];
            this.m_last_bind_values = new DBItem[this.m_noOfArgs];
            n3 = 0;
            while (n3 < this.m_noOfArgs) {
                if (this.m_tmp_first_row_types != null && this.m_tmp_first_row_types[n3] != null) {
                    this.types[n3] = this.m_tmp_first_row_types[n3];
                    if (this.m_dataSetType == 1) {
                        this.m_last_bind_values[n3] = this.m_tmp_first_row_items[n3];
                        this._allocData(n3);
                    } else {
                        this._allocDataAndItems(n3);
                    }
                }
                ++n3;
            }
            if (this.m_tmp_first_row_types != null) {
                n3 = 0;
                while (n3 < this.m_tmp_first_row_types.length) {
                    this.m_tmp_first_row_types[n3] = null;
                    this.m_tmp_first_row_items[n3] = null;
                    ++n3;
                }
                this.m_tmp_first_row_items = null;
                this.m_tmp_first_row_types = null;
            }
        }
        if (this.m_cleanedData) {
            n3 = 0;
            while (n3 < this.m_noOfArgs) {
                if (this.types != null && this.types[n3] != null) {
                    if (this.m_dataSetType == 1) {
                        this._allocData(n3);
                    } else {
                        this._allocDataAndItems(n3);
                    }
                }
                ++n3;
            }
            this.m_cleanedData = false;
        }
        if (this.m_dataSetType == 1) {
            n3 = 0;
            while (n3 < this.types.length) {
                if (this.m_last_bind_values[n3] != null) {
                    this._setDBItem(this.m_last_bind_values[n3], n3, n2);
                }
                ++n3;
            }
        }
    }

    private void _definesRowCompleted() throws SQLException {
        this.m_first_row = false;
        if (!this.m_dynamic) {
            if (this.types == null) {
                DBError.throwSqlException(21);
            }
            if (this.types.length == 0) {
                DBError.throwSqlException(21);
            }
            int n2 = this.types.length;
            this.data = new DBData[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.data[n3] = new DBData(this.m_arrayDepth);
                ++n3;
            }
        }
        int n4 = 0;
        while (n4 < this.m_noOfArgs) {
            DBType dBType = this.types[n4];
            DBItem dBItem = this.m_connection.db_access.createDBItem(dBType);
            if (dBType.type != 109 && dBType.type != 111 && !dBType.is_stream) {
                dBItem.allocBuffer();
            }
            this._setRowItems(n4, dBItem);
            ++n4;
        }
    }

    private final void _createArrayFromTypes(int n2) throws SQLException {
    }

    public DBDataSetImpl(OracleConnection oracleConnection, OracleStatement oracleStatement, int n2, int n3) {
        this.init();
        this.m_connection = oracleConnection;
        this.m_statement = oracleStatement;
        this.m_arrayDepth = n2;
        this.m_dataSetType = n3;
    }

    public final boolean isDynamic() {
        return this.m_dynamic;
    }

    public int getNoOfArgs() {
        return this.m_noOfArgs;
    }

    public void setNoOfDefineCol(int n2) {
        if (this.m_dynamic || this.m_dataSetType != 0) {
            return;
        }
        this.m_noOfArgs = n2;
        DBType[] dBTypeArray = this.types;
        this.types = new DBType[this.m_noOfArgs];
        if (dBTypeArray != null) {
            int n3 = this.m_noOfArgs < dBTypeArray.length ? this.m_noOfArgs : dBTypeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                this.types[n4] = dBTypeArray[n4];
                ++n4;
            }
            dBTypeArray = null;
        }
    }

    public boolean isStreamType(int n2) {
        if (this.types != null && n2 < this.types.length && this.types[n2] != null) {
            return this.types[n2].is_stream;
        }
        return false;
    }

    public boolean hasStreamType() {
        if (this.types != null) {
            int n2 = 0;
            while (n2 < this.types.length) {
                if (this.types[n2] != null && this.types[n2].is_stream) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public int getMissingType() {
        int n2 = 0;
        while (n2 < this.types.length) {
            if (this.types[n2] == null) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public final byte[] getBytesItem(int n2, int n3) throws SQLException {
        DBItem dBItem;
        byte[] byArray = null;
        if (this.data != null && this.data[n2] != null && (dBItem = this.data[n2].getItem(n3)) != null && !dBItem.is_null) {
            byArray = new byte[dBItem.data_size];
            System.arraycopy(dBItem.byte_value, 0, byArray, 0, dBItem.data_size);
        }
        return byArray;
    }

    public final char[] getCharsItem(int n2, int n3, int[] nArray, short s2) throws SQLException {
        DBItem dBItem;
        char[] cArray = null;
        if (this.data != null && this.data[n2] != null && (dBItem = this.data[n2].getItem(n3)) != null && !dBItem.is_null) {
            dBItem.getChars(s2);
            cArray = dBItem.char_value;
            nArray[0] = dBItem.char_size;
        }
        return cArray;
    }

    public final InputStream getStreamItem(int n2, int n3) throws SQLException {
        if (this.data == null || this.data[n2] == null) {
            return null;
        }
        DBItem dBItem = this.data[n2].getItem(n3);
        if (dBItem == null || dBItem.is_null) {
            return null;
        }
        try {
            if (((OracleInputStream)dBItem.stream_value).isClosed()) {
                DBError.throwSqlException(27);
            }
            if (!((OracleInputStream)dBItem.stream_value).needBytes()) {
                dBItem.setNull();
                return null;
            }
            return dBItem.stream_value;
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
            return null;
        }
    }

    public final char[] getCharsStreamItem(int n2, int n3, int[] nArray) throws SQLException {
        if (this.data == null || this.data[n2] == null) {
            return null;
        }
        DBItem dBItem = this.data[n2].getItem(n3);
        if (dBItem == null || dBItem.is_null) {
            return null;
        }
        char[] cArray = dBItem.getChars((short)1);
        nArray[0] = dBItem.char_size;
        return cArray;
    }

    public final void setStreamItem(int n2, int n3, InputStream inputStream) throws SQLException {
        if (this.data == null || this.data[n2] == null) {
            return;
        }
        this.data[n2].getItem((int)n3).stream_value = inputStream;
    }

    public boolean dataAllocated(int n2) {
        return this.data != null && n2 < this.data.length && this.data[n2] != null;
    }

    public final byte[] getBytes(int n2, int n3) throws SQLException {
        if (this.data.length < n2) {
            return null;
        }
        return this.data[n2].getItem(n3).getBytes();
    }

    public final boolean isNull(int n2, int n3) throws SQLException {
        return this.data[n2].getItem((int)n3).is_null;
    }

    public final void setNull(int n2, int n3) throws SQLException {
        this.data[n2].getItem(n3).setNull();
    }

    public final int getType(int n2) {
        if (this.types == null || n2 < 0 || this.types.length <= n2 || this.types[n2] == null) {
            return -1;
        }
        return this.types[n2].type;
    }

    public final int getExternalType(int n2) {
        if (this.types == null || n2 < 0 || this.types.length <= n2 || this.types[n2] == null) {
            return -1;
        }
        return this.types[n2].external_type;
    }

    public final OracleType getOtype(int n2) {
        if (this.types == null || this.types.length <= n2 || this.types[n2] == null) {
            return null;
        }
        return this.types[n2].otype;
    }

    public final void setType(int n2, int n3, int n4, short s2) throws SQLException {
        this.setType(n2, n3, 0, n4, s2);
    }

    public void setType(int n2, int n3, int n4, int n5, short s2) throws SQLException {
        DBType dBType = null;
        if (this.m_dataSetType == 0) {
            if (n2 + 1 > this.m_noOfArgs) {
                this.setNoOfDefineCol(n2 + 1);
            }
            dBType = this.m_connection.db_access.createDBType(n3, false);
            if (n3 == 96 || n3 == 1 || n3 == 999) {
                if (n5 > 0) {
                    dBType.setMaxSize(n5);
                }
            } else if (n5 > 0 && n5 < dBType.max_length) {
                dBType.max_length = n5;
            }
            dBType.FormOfUse = s2;
            dBType.ncs = dBType.isNType() ? (int)this.m_connection.conversion.getNCharSet() : (int)this.m_connection.conversion.getDbCharSet();
            this._setDBType(n2, dBType);
        } else {
            dBType = this._createOrGetBindDBType(n2, n3);
            if (n5 > 0 && n5 < dBType.max_length) {
                dBType.max_length = n5;
            }
            this._setBindDBType(n2, dBType);
            if (this.m_dataSetType == 2 && !this.m_first_row) {
                this._allocDataAndItems(n2);
            }
        }
        dBType.setExternalType(n4);
    }

    public final void setType(int n2, int n3, OracleType oracleType) throws SQLException {
        if (this.m_dataSetType == 0) {
            if (n2 + 1 > this.m_noOfArgs) {
                this.setNoOfDefineCol(n2 + 1);
            }
            DBType dBType = this.m_connection.db_access.createDBType(n3, false);
            dBType.otype = oracleType;
            this._setDBType(n2, dBType);
        } else {
            DBType dBType = this._createOrGetBindDBType(n2, n3);
            dBType.otype = oracleType;
            this._setBindDBType(n2, dBType);
        }
    }

    public final void clearItems() {
        if (this.m_first_row && this.m_tmp_first_row_items != null) {
            int n2 = 0;
            while (n2 < this.m_noOfArgs) {
                this.m_tmp_first_row_items[n2] = null;
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < this.m_noOfArgs) {
                this.m_last_bind_values[n3] = null;
                ++n3;
            }
            if (this.data == null) {
                return;
            }
            int n4 = 0;
            while (n4 < this.data.length) {
                if (this.data[n4] != null) {
                    this.data[n4].clearItems();
                }
                ++n4;
            }
            this.m_cleanedData = true;
        }
    }

    public final void cleanup() {
        int n2;
        this.cleanTypes();
        this.cleanData();
        this.data = null;
        int n3 = 0;
        this.m_last_bind_values = null;
        if (this.m_tmp_first_row_items != null) {
            n2 = this.m_tmp_first_row_items.length;
            n3 = 0;
            while (n3 < n2) {
                this.m_tmp_first_row_items[n3] = null;
                ++n3;
            }
            this.m_tmp_first_row_items = null;
        }
        if (this.m_tmp_first_row_types != null) {
            n2 = this.m_tmp_first_row_types.length;
            n3 = 0;
            while (n3 < n2) {
                this.m_tmp_first_row_types[n3] = null;
                ++n3;
            }
            this.m_tmp_first_row_types = null;
        }
        this.init();
    }

    public final void cleanTypes() {
        if (this.types != null) {
            int n2 = 0;
            while (n2 < this.types.length) {
                this.types[n2] = null;
                ++n2;
            }
        }
        this.types = null;
        this.m_noOfArgs = 0;
    }

    public final void cleanData() {
        if (this.m_last_bind_values != null) {
            int n2 = this.m_last_bind_values.length;
            int n3 = 0;
            while (n3 < n2) {
                if (this.m_last_bind_values[n3] != null) {
                    this.m_last_bind_values[n3] = null;
                }
                ++n3;
            }
        }
        this._cleanData();
    }

    public void setBatchSize(int n2) throws SQLException {
        if (n2 == this.m_arrayDepth) {
            return;
        }
        this.m_arrayDepth = n2;
        if (this.m_first_row || this.m_dynamic) {
            return;
        }
        if (this.data != null && this.types != null) {
            int n3 = this.data.length;
            int n4 = 0;
            while (n4 < n3) {
                DBType dBType = this.types[n4];
                if (this.data[n4] == null) {
                    this.data[n4] = new DBData(this.m_arrayDepth);
                } else {
                    DBData dBData = this.data[n4];
                    int n5 = dBData.getNItems();
                    int n6 = n5 < n2 ? n5 : n2;
                    this.data[n4] = new DBData(n2);
                    int n7 = 0;
                    while (n7 < n6) {
                        this.data[n4].setItem(n7, dBData.getItem(n7));
                        ++n7;
                    }
                    int n8 = -1;
                    DBItem dBItem = dBData.getItem(0);
                    if (dBItem != null && dBItem.byte_value != null) {
                        n8 = dBItem.byte_value.length;
                    }
                    n7 = n6;
                    while (n7 < n2) {
                        DBItem dBItem2 = this.m_connection.db_access.createDBItem(dBType);
                        if (n8 == -1) {
                            dBItem2.allocBuffer();
                        } else {
                            dBItem2.allocBuffer(n8);
                        }
                        this.data[n4].setItem(n7, dBItem2);
                        ++n7;
                    }
                }
                ++n4;
            }
        }
    }

    public void rowCompleted(int n2) throws SQLException {
        if (this.m_dataSetType == 0) {
            this._definesRowCompleted();
        } else {
            this._bindsRowCompleted(n2);
        }
    }

    public boolean setBytesBindItem(int n2, int n3, int n4, byte[] byArray) throws SQLException {
        DBType dBType = this._createOrGetBindDBType(n2, n4);
        DBItem dBItem = this._createOrGetDBItem(n2, dBType, n3);
        boolean bl = this.newDBType;
        if (byArray == null) {
            dBItem.setNull();
        } else {
            if (dBType.max_length < byArray.length) {
                dBType.max_length = byArray.length;
                bl = true;
            }
            dBItem.setArrayData(false, byArray);
        }
        this._setBindDBType(n2, dBType);
        this._setBindDBItem(n2, dBItem);
        return bl;
    }

    public boolean setBytesBindItem(int n2, int n3, int n4, String string) throws SQLException {
        DBType dBType = this._createOrGetBindDBType(n2, n4);
        DBItem dBItem = this._createOrGetDBItem(n2, dBType, n3);
        boolean bl = this.newDBType;
        if (string == null) {
            dBItem.setNull();
        } else {
            dBItem.setArrayData(false, string, this.getFormOfUse(n2));
            if (dBType.max_length < dBItem.byte_value.length) {
                dBType.max_length = dBItem.byte_value.length;
                bl = true;
            }
        }
        this._setBindDBType(n2, dBType);
        this._setBindDBItem(n2, dBItem);
        return bl;
    }

    public void setStreamBindItem(int n2, int n3, int n4, InputStream inputStream, int n5) throws SQLException {
        DBType dBType = this._createOrGetBindDBType(n2, n4);
        DBItem dBItem = this._createOrGetDBItem(n2, dBType, n3);
        dBItem.setStreamData(false, n5, inputStream);
        this._setBindDBType(n2, dBType);
        this._setBindDBItem(n2, dBItem);
    }

    public boolean setNullADTBindItem(int n2, int n3, int n4, OracleType oracleType) throws SQLException {
        boolean bl = false;
        DBType dBType = this._createOrGetBindDBType(n2, n4);
        DBItem dBItem = this._createOrGetDBItem(n2, dBType, n3);
        ((OracleTypeADT)oracleType).getTOID();
        if (!oracleType.isInHierarchyOf(dBType.otype)) {
            bl = true;
            dBType.otype = oracleType;
        }
        dBType.max_length = 0;
        dBItem.setNull();
        this._setBindDBType(n2, dBType);
        this._setBindDBItem(n2, dBItem);
        return bl;
    }

    public void setNullBindItem(int n2, int n3, int n4) throws SQLException {
        DBType dBType = this._createOrGetBindDBType(n2, n4);
        DBItem dBItem = this._createOrGetDBItem(n2, dBType, n3);
        dBItem.setNull();
        this._setBindDBType(n2, dBType);
        this._setBindDBItem(n2, dBItem);
    }

    public void setADTBindType(int n2, int n3, int n4, OracleType oracleType) throws SQLException {
        DBType dBType = this._createOrGetBindDBType(n2, n4);
        DBItem dBItem = this._createOrGetDBItem(n2, dBType, n3);
        ((OracleTypeADT)oracleType).getTOID();
        dBType.max_length = 0;
        dBType.otype = oracleType;
        this._setBindDBType(n2, dBType);
        this._setBindDBItem(n2, null);
    }

    public boolean setADTBindItem(int n2, int n3, int n4, byte[] byArray, OracleType oracleType) throws SQLException {
        boolean bl = false;
        DBType dBType = this._createOrGetBindDBType(n2, n4);
        DBItem dBItem = this._createOrGetDBItem(n2, dBType, n3);
        ((OracleTypeADT)oracleType).getTOID();
        dBType.max_length = byArray.length;
        if (!oracleType.isInHierarchyOf(dBType.otype)) {
            bl = true;
            dBType.otype = oracleType;
        }
        dBItem.setArrayData(false, byArray);
        this._setBindDBType(n2, dBType);
        this._setBindDBItem(n2, dBItem);
        return bl;
    }

    public int checkBindTypes(DBDataSet dBDataSet, int n2, int n3) throws SQLException {
        DBType dBType;
        Object object;
        if (n2 < 0) {
            DBError.throwSqlException(3);
        }
        if (this.m_first_row) {
            return 0;
        }
        if (this.types != null && this.types.length > n2 && (object = this._getDBType(n2)) != null && (((DBType)object).type != n3 || ((DBType)object).max_length == 0 && !this.m_statement.isColumnSetNull(n2 + 1))) {
            return -1;
        }
        object = (DBDataSetImpl)dBDataSet;
        if (!(object == null || ((DBDataSetImpl)object).types == null || ((DBDataSetImpl)object).types.length <= n2 || (dBType = super._getDBType(n2)) == null || dBType.type == n3 || dBType.type == 96 && n3 == 1 || dBType.type == 1 && n3 == 96)) {
            DBError.throwSqlException(12);
        }
        return 0;
    }

    public int checkBindObjectTypes(DBDataSet dBDataSet, int n2, int n3, StructDescriptor structDescriptor) throws SQLException {
        DBType dBType;
        Object object;
        if (n2 < 0) {
            DBError.throwSqlException(3);
        }
        if (this.m_first_row) {
            return 0;
        }
        if (this.types != null && this.types.length > n2 && (object = this._getDBType(n2)) != null && (((DBType)object).type != n3 || ((DBType)object).max_length == 0 && !this.m_statement.isColumnSetNull(n2 + 1) || !((DBType)object).otype.isInHierarchyOf(structDescriptor))) {
            return -1;
        }
        object = (DBDataSetImpl)dBDataSet;
        if (!(object == null || ((DBDataSetImpl)object).types == null || ((DBDataSetImpl)object).types.length <= n2 || (dBType = super._getDBType(n2)) == null || dBType.type == n3 || dBType.type == 96 && n3 == 1 || dBType.type == 1 && n3 == 96)) {
            DBError.throwSqlException(12);
        }
        return 0;
    }

    public int checkBindsInAndOut(DBDataSet dBDataSet, int n2) throws SQLException {
        DBDataSetImpl dBDataSetImpl = (DBDataSetImpl)dBDataSet;
        int n3 = 0;
        if (this.types != null) {
            n3 = this.types.length;
        }
        if (dBDataSetImpl != null && dBDataSetImpl.types != null && dBDataSetImpl.types.length > n3) {
            n3 = dBDataSetImpl.types.length;
        }
        int n4 = 0;
        while (n4 < n3) {
            if (!(this.data != null && n4 < this.data.length && this.data[n4] != null && this.data[n4].getItem(n2) != null || dBDataSetImpl != null && dBDataSetImpl.data != null && n4 < dBDataSetImpl.data.length && dBDataSetImpl.data[n4] != null && dBDataSetImpl.data[n4].getItem(n2) != null)) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    public void removeFirstRow() throws SQLException {
        if (this.data != null) {
            int n2 = 0;
            while (n2 < this.data.length) {
                this.data[n2].removeFirstItem();
                ++n2;
            }
        }
    }

    public void prependRowidColumn() throws SQLException {
        ++this.m_noOfArgs;
        DBType[] dBTypeArray = new DBType[this.m_noOfArgs];
        dBTypeArray[0] = this.m_connection.db_access.createDBType(104, false);
        System.arraycopy(this.types, 0, dBTypeArray, 1, this.types.length);
        this.types = dBTypeArray;
    }

    public void removeRowidColumn() throws SQLException {
        --this.m_noOfArgs;
        DBType[] dBTypeArray = new DBType[this.m_noOfArgs];
        System.arraycopy(this.types, 1, dBTypeArray, 0, this.types.length - 1);
        this.types = dBTypeArray;
    }

    public void enterCache() throws SQLException {
        if (this.m_dataSetType != 0) {
            this.cleanData();
            this.setFirstRow(true);
        } else if (this.m_statement.columns_defined_by_user) {
            this.cleanTypes();
        }
    }

    public void reactivate() throws SQLException {
    }

    public DBType[] getDBTypes() {
        return this.types;
    }

    public DBData[] getDBData() {
        return this.data;
    }

    public final String getInfoString() throws SQLException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(this + "\n" + "  DBDataSetImpl.m_dynamic=" + this.m_dynamic + "\n" + "  DBDataSetImpl.m_arrayDepth=" + this.m_arrayDepth + " (valid only when m_dynamic=false)\n");
        stringBuffer.append("  DBDataSetImpl.m_dataSetType=" + this.m_dataSetType + "\n");
        stringBuffer.append("  DBDataSetImpl.m_noOfArgs=" + this.m_noOfArgs + "\n");
        if (this.types == null) {
            stringBuffer.append("  DBDataSetImpl.types is null");
        } else {
            stringBuffer.append("  DBDataSetImpl.types.length=" + this.types.length);
            n2 = 0;
            while (n2 < this.types.length) {
                if (this.types[n2] == null) {
                    stringBuffer.append("\n    types[" + n2 + "]=null");
                } else {
                    stringBuffer.append("\n    types[" + n2 + "].type=" + DBType.getStringType(this.types[n2].type) + " (max_length=" + this.types[n2].max_length + ")");
                }
                ++n2;
            }
        }
        stringBuffer.append("\n");
        if (this.data == null) {
            stringBuffer.append("  DBDataSetImpl.data is null");
        } else {
            stringBuffer.append("  DBDataSetImpl.data.length=" + this.data.length);
            n2 = 0;
            while (n2 < this.data.length) {
                if (this.data[n2] == null) {
                    stringBuffer.append("\n    data[" + n2 + "]=null");
                } else {
                    int n3 = 0;
                    while (n3 < this.data[n2].getNItems()) {
                        DBItem dBItem = this.data[n2].getItem(n3);
                        if (dBItem == null) {
                            stringBuffer.append("\n    data[" + n2 + "].items[" + n3 + "]=null");
                        } else {
                            stringBuffer.append("\n    data[" + n2 + "].items[" + n3 + "] has " + dBItem.data_size + " bytes:\n");
                            if (dBItem.byte_value != null) {
                                stringBuffer.append("\n    data[" + n2 + "].items[" + n3 + "] has " + dBItem.byte_value.length + " bytes allocated\n");
                                stringBuffer.append(OracleLog.bytesToFormattedStr(dBItem.byte_value, dBItem.data_size, "    "));
                            }
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
        }
        if (this.m_last_bind_values == null) {
            stringBuffer.append("  DBDataSetImpl.m_last_bind_values is null\n");
        } else {
            stringBuffer.append("  DBDataSetImpl.m_last_bind_values has size of " + this.m_last_bind_values.length + "\n");
        }
        if (this.m_tmp_first_row_items == null) {
            stringBuffer.append("  DBDataSetImpl.m_tmp_first_row_items is null\n");
        } else {
            stringBuffer.append("  DBDataSetImpl.m_tmp_first_row_items has size of " + this.m_tmp_first_row_items.length + "\n");
        }
        if (this.m_tmp_first_row_types == null) {
            stringBuffer.append("  DBDataSetImpl.m_tmp_first_row_types is null\n");
        } else {
            stringBuffer.append("  DBDataSetImpl.m_tmp_first_row_types has size of " + this.m_tmp_first_row_types.length + "\n");
        }
        return stringBuffer.toString();
    }

    public short getFormOfUse(int n2) {
        if (this.form_of_use == null) {
            return 1;
        }
        if (this.form_of_use.length <= n2) {
            return 1;
        }
        if (this.form_of_use[n2] == 0) {
            return 1;
        }
        return this.form_of_use[n2];
    }

    public void setFormOfUse(int n2, short s2) {
        DBType dBType;
        int n3;
        int n4 = n2 - 1;
        if (this.form_of_use == null) {
            n3 = Math.max(n4 + 1, _MIN_ARG_COUNT);
            this.form_of_use = new short[n3];
        } else if (n4 >= this.form_of_use.length) {
            n3 = this.form_of_use.length;
            n3 = Math.max(n4 + 1, n3);
            short[] sArray = new short[2 * n3];
            System.arraycopy(this.form_of_use, 0, sArray, 0, this.form_of_use.length);
            this.form_of_use = sArray;
            sArray = null;
        }
        this.form_of_use[n4] = s2;
        if (this.m_dataSetType == 2 && (dBType = this._getBindDBType(n4)) != null) {
            this._setBindDBType(n4, dBType);
        }
    }

    public void setFirstRow(boolean bl) {
        this.m_first_row = bl;
    }

    public void clearItem(int n2, boolean bl) {
        if (!bl && this.m_first_row && this.m_tmp_first_row_items != null) {
            int n3 = 0;
            while (n3 < this.m_noOfArgs) {
                this.m_tmp_first_row_items[n3] = null;
                ++n3;
            }
        } else {
            int n4;
            if (this.data == null) {
                return;
            }
            if (!bl) {
                n4 = 0;
                while (n4 < this.m_last_bind_values.length) {
                    this.m_last_bind_values[n4] = null;
                    ++n4;
                }
            }
            n4 = 0;
            while (n4 < this.data.length && this.data[n4] != null) {
                this.data[n4].clearItem(n2);
                ++n4;
            }
            this.m_cleanedData = true;
        }
    }
}

